/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.operations.internal;

import java.util.HashSet;
import java.util.Map;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.util.DomainInfo;
import oracle.eclipse.tools.weblogic.server.internal.util.DomainTemplateUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.TemplateInfo;
import oracle.eclipse.tools.weblogic.server.operations.IExtendDomainOp;
import oracle.eclipse.tools.weblogic.server.operations.IExtensionTemplate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class ExtensionTemplateValueChangeListener
extends FilteredListener<PropertyContentEvent> {
    boolean inAction = false;

    protected void handleTypedEvent(PropertyContentEvent event) {
        String name;
        if (this.inAction) {
            return;
        }
        this.inAction = true;
        Element m = event.property().element();
        IExtensionTemplate createTempl = (IExtensionTemplate)m;
        String newTempName = (String)createTempl.getName().content();
        IExtendDomainOp model = (IExtendDomainOp)createTempl.nearest(IExtendDomainOp.class);
        String serverId = (String)model.getServerid().content();
        IServer server = ExtensionTemplateValueChangeListener.getServer(serverId);
        IRuntime rt = server.getRuntime();
        Map<String, TemplateInfo> allTemplates = DomainTemplateUtil.findAllDomainExtensionTemplates(rt);
        WebLogicServerVersion wlsVer = WebLogicServerVersion.detect(rt);
        HashSet<TemplateInfo> dependencies = new HashSet<TemplateInfo>();
        TemplateInfo template = allTemplates.get(newTempName);
        DomainTemplateUtil.addDependencies(rt, template, dependencies);
        HashSet<String> existingNames = new HashSet<String>();
        WeblogicServer weblogicServer = (WeblogicServer)server.getAdapter(WeblogicServer.class);
        try {
            DomainInfo domainInfo = DomainTemplateUtil.parseDomainInfo(weblogicServer);
            if (domainInfo != null) {
                for (TemplateInfo templateInfo : domainInfo.extensionTemplates) {
                    name = templateInfo.getFullName();
                    existingNames.add(name);
                }
            }
        }
        catch (CoreException coreException) {}
        for (IExtensionTemplate iExtensionTemplate : model.getTemplates()) {
            name = iExtensionTemplate.getName().text();
            if (name == null) continue;
            if (template.getConflicts().contains(name)) {
                model.getTemplates().remove((Object)iExtensionTemplate);
                continue;
            }
            existingNames.add(name);
        }
        for (TemplateInfo templateInfo : dependencies) {
            if (!templateInfo.selectable.equals("true") || !templateInfo.type.equals("Extension Template") || existingNames.contains(templateInfo.getFullName()) || wlsVer.compareTo(WebLogicServerVersion.VERSION_12_1_2) < 0 && templateInfo.getFullName().contains("Oracle WSM Policy Manager")) continue;
            IExtensionTemplate c = (IExtensionTemplate)model.getTemplates().insert();
            c.setName(templateInfo.getFullName());
        }
        this.inAction = false;
    }

    protected static IServer getServer(String serverId) {
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getId().equals(serverId)) {
                return server;
            }
            ++n2;
        }
        return null;
    }
}

