/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.operations.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.weblogic.server.internal.util.DomainTemplateUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.TemplateInfo;
import oracle.eclipse.tools.weblogic.server.operations.ICreateDefaultDomainOp;
import oracle.eclipse.tools.weblogic.server.operations.ICreationTemplate;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class CreationTemplateValueChangeListener
extends FilteredListener<PropertyContentEvent> {
    static boolean inAction = false;

    protected void handleTypedEvent(PropertyContentEvent event) {
        String name;
        if (inAction) {
            return;
        }
        Element m = event.property().element();
        ICreationTemplate createTempl = (ICreationTemplate)m;
        String newTempName = (String)createTempl.getName().content();
        ICreateDefaultDomainOp model = (ICreateDefaultDomainOp)createTempl.nearest(ICreateDefaultDomainOp.class);
        String runtimeId = (String)model.getRuntimeid().content();
        IRuntime rt = ServerCore.findRuntime((String)runtimeId);
        Map<String, TemplateInfo> allTemplates = DomainTemplateUtil.findAllDomainExtensionTemplates(rt);
        HashSet<TemplateInfo> dependencies = new HashSet<TemplateInfo>();
        TemplateInfo template = allTemplates.get(newTempName);
        DomainTemplateUtil.addDependencies(rt, template, dependencies);
        inAction = true;
        HashSet<String> existingNames = new HashSet<String>();
        for (ICreationTemplate t : model.getTemplates()) {
            if (createTempl == t || (name = t.getName().text()) == null) continue;
            Set<String> conflicts = template.getConflicts();
            if (conflicts.contains(name)) {
                System.err.println(String.valueOf(name) + " conflicts with " + template.getFullName());
                model.getTemplates().remove((Object)t);
                continue;
            }
            existingNames.add(name);
        }
        for (TemplateInfo depend : dependencies) {
            name = depend.getFullName();
            if (!depend.selectable.equals("true") || !depend.type.equals("Extension Template") || existingNames.contains(name) || this.conflictWith(allTemplates, existingNames, name) || name.equals(newTempName)) continue;
            ICreationTemplate c = (ICreationTemplate)model.getTemplates().insert();
            c.setName(name);
            existingNames.add(name);
        }
        inAction = false;
        model.refresh();
    }

    private boolean conflictWith(Map<String, TemplateInfo> allTemplates, Set<String> existingNames, String name) {
        for (String s : existingNames) {
            TemplateInfo t = allTemplates.get(s);
            if (!t.getConflicts().contains(name)) continue;
            return true;
        }
        return false;
    }
}

