/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.operations.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WLSTRunnerUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.internal.ServerConfiguration;
import oracle.eclipse.tools.weblogic.server.internal.util.DomainTemplateUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.TemplateInfo;
import oracle.eclipse.tools.weblogic.server.operations.ICreateDefaultDomainOp;
import oracle.eclipse.tools.weblogic.server.operations.ICreationTemplate;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.Bundle;

public class CreateDefaultDomainOpMethods {
    public static final String NEW_DEFAULT_DOMAIN_SCRIPT = "/wlst.scripts/new_default_domain.py";
    public static final String NEW_DEFAULT_12C_DOMAIN_SCRIPT = "/wlst.scripts/new_default_12c_domain.py";
    private static final String DEFAULT_PASSWORD = "welcome1";
    private static final String OWM_DOMAIN_CONFIG_TEMPLATE_NAME = "wsmpm_config_template.jar";
    private static final String OWM_DOMAIN_CONFIG_TEMPLATE_PATH = "/templates/domain/";

    public static Status execute(ICreateDefaultDomainOp operation, ProgressMonitor monitor) {
        block14: {
            IRuntime runtime;
            block13: {
                if (monitor == null) {
                    monitor = new ProgressMonitor();
                }
                monitor.beginTask(Resources.executeTaskName, 50);
                String runtimeId = (String)operation.getRuntimeid().content();
                runtime = WlsRuntimeUtil.getRuntime(runtimeId);
                if (runtime != null) break block13;
                Status status = Status.createErrorStatus((String)("Invalid runtime " + runtimeId));
                monitor.done();
                return status;
            }
            try {
                String wlHome = runtime.getLocation().toPortableString();
                String beaHome = WlsRuntimeUtil.getMwHome(new File(wlHome)).getAbsolutePath().replace('\\', '/');
                Path path = CreateDefaultDomainOpMethods.getNewDomainScriptName(runtime);
                InputStream ios = FileLocator.openStream((Bundle)WlsCorePlugin.getPluginBundle(), (IPath)path, (boolean)false);
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("%BEA_HOME%", beaHome);
                props.put("%WL_HOME%", wlHome);
                String password = DEFAULT_PASSWORD;
                if (((Boolean)operation.getSpecifypassword().content()).booleanValue()) {
                    password = (String)operation.getPassword().content();
                }
                props.put("%PASSWORD%", password);
                String domainLocation = ((org.eclipse.sapphire.modeling.Path)operation.getLocation().content()).toPortableString();
                domainLocation = String.valueOf(domainLocation) + '/';
                domainLocation = String.valueOf(domainLocation) + (String)operation.getName().content();
                domainLocation = domainLocation.replace("\\", "/");
                props.put("%DOMAIN_LOCATION%", domainLocation);
                StringBuilder sb = new StringBuilder();
                ElementList<ICreationTemplate> templates = operation.getTemplates();
                if (templates.size() >= 0) {
                    ArrayList<TemplateInfo> list = new ArrayList<TemplateInfo>();
                    for (ICreationTemplate t : templates) {
                        String name = (String)t.getName().content();
                        TemplateInfo info = CreateDefaultDomainOpMethods.getTemplateInfo(runtime, name);
                        if (info == null) continue;
                        list.add(info);
                    }
                    Collections.sort(list);
                    for (TemplateInfo info : list) {
                        WebLogicServerVersion version;
                        String location = info.location;
                        if (location == null) continue;
                        sb.append("addTemplate('");
                        sb.append(location);
                        sb.append("')");
                        sb.append("\n");
                        if (!info.getFullName().startsWith("Oracle WSM Policy Manager - File") || (version = WebLogicServerVersion.detect(runtime)).compareTo(WebLogicServerVersion.VERSION_12_1_2) >= 0) continue;
                        CreateDefaultDomainOpMethods.addFileBasedOWSMDomainConfigTemplates(sb, info);
                    }
                    props.put("%ADD_TEMPLATES%", sb.toString());
                }
                monitor.setTaskName(Resources.executeTaskName);
                String ret = WLSTRunnerUtil.runWLSTScriptInCommandLine(runtime, ios, props, ProgressMonitorBridge.create((ProgressMonitor)monitor));
                LoggingService.logInfo((String)"oracle.eclipse.tools.weblogic", (String)(String.valueOf(Resources.executeTaskName) + ":" + ret));
                ServerConfiguration cfg = new ServerConfiguration((IPath)new Path(domainLocation));
                cfg.getServerInfo();
                monitor.done();
            }
            catch (IOException e) {
                e.printStackTrace();
                monitor.done();
                break block14;
            }
            catch (CoreException e) {
                try {
                    Status status = Status.createErrorStatus((String)Resources.creationFailed, (Throwable)e.getCause());
                    return status;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    monitor.done();
                }
            }
            monitor.done();
        }
        return Status.createOkStatus();
    }

    private static Path getNewDomainScriptName(IRuntime rt) {
        WebLogicServerVersion version = WebLogicServerVersion.detect(rt);
        if (version.compareTo(WebLogicServerVersion.VERSION_12_1_2) >= 0) {
            return new Path(NEW_DEFAULT_12C_DOMAIN_SCRIPT);
        }
        return new Path(NEW_DEFAULT_DOMAIN_SCRIPT);
    }

    protected static Status addFileBasedOWSMDomainConfigTemplates(StringBuilder sb, TemplateInfo info) {
        try {
            Path p = new Path("/templates/domain/wsmpm_config_template.jar");
            InputStream ios = FileLocator.openStream((Bundle)WlsCorePlugin.getPluginBundle(), (IPath)p, (boolean)false);
            if (ios == null) {
                return Status.createErrorStatus((String)("Missing OWSM domain config template " + p.toPortableString()));
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            File wsPloicyFileRoot = new File(root.getLocation().toFile(), "WsPloicy");
            wsPloicyFileRoot.mkdirs();
            File f = new File(wsPloicyFileRoot, OWM_DOMAIN_CONFIG_TEMPLATE_NAME);
            if (!f.exists()) {
                FileOutputStream fout = new FileOutputStream(f);
                byte[] buf = new byte[1024];
                int n = ios.read(buf);
                while (n > 0) {
                    fout.write(buf, 0, n);
                    n = ios.read(buf);
                }
                fout.close();
                ios.close();
            }
            sb.append("addTemplate('");
            sb.append(f.getAbsolutePath().replace('\\', '/'));
            sb.append("')");
            sb.append("\n");
        }
        catch (IOException e) {
            return Status.createErrorStatus((Throwable)e);
        }
        return Status.createOkStatus();
    }

    public static TemplateInfo getTemplateInfo(IRuntime runtime, String name) {
        Map<String, TemplateInfo> map = DomainTemplateUtil.findAllDomainExtensionTemplates(runtime);
        return map.get(name);
    }

    private static final class Resources
    extends NLS {
        public static String executeTaskName;
        public static String creationFailed;

        static {
            Resources.initializeMessages((String)CreateDefaultDomainOpMethods.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

