/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IWlsJMXHelper;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.modules.JavaEEModule;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModule;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModulesRoot;
import oracle.eclipse.tools.weblogic.server.modules.SharedLibraryRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;

public class PublishedModuleTarget
extends PublishedModule {
    protected PublishedModulesRoot parent;
    protected IServer server = null;
    protected SharedLibraryRoot shareLibRoot;

    public PublishedModuleTarget(PublishedModulesRoot root, IServer server, String targetName) {
        super(targetName, null, root);
        this.server = server;
    }

    public IServer getServer() {
        return this.server;
    }

    public Object getEditableValue() {
        return null;
    }

    private WeblogicServerBehaviour getWeblogicServerBehavior() {
        return (WeblogicServerBehaviour)this.server.loadAdapter(WeblogicServerBehaviour.class, null);
    }

    protected void newSharedLibraryRoot() {
        if (this.shareLibRoot == null) {
            this.shareLibRoot = new SharedLibraryRoot("Shared Libraries", null, this);
        }
    }

    @Override
    public Object[] getChildren() {
        if (this.childModules == null) {
            this.newSharedLibraryRoot();
            this.shareLibRoot.refresh();
            ArrayList<PublishedModule> moduleList = new ArrayList<PublishedModule>();
            this.createModuleList(moduleList, (IProgressMonitor)new NullProgressMonitor());
            for (PublishedModule m : moduleList) {
                this.addChild(m);
            }
        }
        PublishedModulesRoot parent = (PublishedModulesRoot)this.getParent();
        ArrayList<PublishedModule> ret = new ArrayList<PublishedModule>();
        if (this.getChildModules() != null) {
            for (PublishedModule m : this.getChildModules()) {
                if (m.isSharedLibrary()) {
                    this.shareLibRoot.addChild(m);
                    continue;
                }
                if (!parent.isShowEarModules() && m.getType().equals("ear") || !parent.isShowEjbModules() && m.getType().equals("ejb") || !parent.isShowWebModules() && m.getType().equals("war")) continue;
                ret.add(m);
            }
        }
        if (parent.isShowSharedLibraries()) {
            ret.add(this.shareLibRoot);
        }
        return ret.toArray(new PublishedModule[ret.size()]);
    }

    protected void createModuleList(ArrayList<PublishedModule> list, IProgressMonitor monitor) {
        try {
            WeblogicServerBehaviour behaviour = this.getWeblogicServerBehavior();
            if (behaviour == null) {
                this.childModules = null;
                return;
            }
            monitor.beginTask("Retrieving published modules list from WebLogic server", 100);
            monitor.worked(30);
            IJ2EEDeploymentHelper deployHelper = behaviour.getPublisher();
            IWlsJMXHelper jmxHelper = deployHelper.getWlsJMXHelper();
            HashMap<String, String> libModules = jmxHelper.getLibraries(this.name);
            HashMap<String, String> appDeployments = jmxHelper.getAppDeployment(this.name);
            monitor.worked(30);
            for (Map.Entry<String, String> entry : appDeployments.entrySet()) {
                String name = entry.getKey();
                String type = entry.getValue();
                JavaEEModule m = new JavaEEModule(name, type, this);
                list.add(m);
            }
            for (String name : libModules.keySet()) {
                String type = libModules.get(name);
                JavaEEModule m = new JavaEEModule(name, type, this.shareLibRoot, true);
                list.add(m);
            }
            monitor.done();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeChildModule(PublishedModule module) {
        PublishedModulesRoot root = (PublishedModulesRoot)this.getParent();
        try {
            WeblogicServerBehaviour weblogic = root.getWeblogicServerBehavior();
            try {
                if ("ear".equals(module.getType()) || "war".equals(module.getType()) || "ejb".equals(module.getType())) {
                    weblogic.undeploy(module.label(), this.label(), (IProgressMonitor)new NullProgressMonitor());
                } else {
                    IJ2EEDeploymentHelper deployHelper = weblogic.getPublisher();
                    deployHelper.undeploy(module.label(), false, (IProgressMonitor)new NullProgressMonitor());
                }
                this.getChildModules().remove(module);
            }
            catch (CoreException e) {
                WlsCorePlugin.logException((Exception)((Object)e));
            }
            Server server = (Server)weblogic.getServer();
            server.setModulePublishState(server.getModules(), 3);
        }
        catch (Exception exception) {}
    }
}

