/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.model;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.common.util.ResourceLoader;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.common.util.fileio.virtualfs.VirtualFileSystem;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerDeployment;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.VirtualEarManager;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import oracle.eclipse.tools.weblogic.server.model.WeblogicPublishOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;

public abstract class WeblogicWebPublishOperation
extends WeblogicPublishOperation {
    private static final ResourceLoader _resourceLoader = new ResourceLoader(WeblogicWebPublishOperation.class);
    protected static final Collection<String> EAR_TYPE_IDS = Arrays.asList("j2ee.ear", "jst.ear");
    protected static final Collection<String> WEB_TYPE_IDS = Arrays.asList("j2ee.web", "jst.web");

    public WeblogicWebPublishOperation(String taskName, String taskDescription, IServer server) {
        super(taskName, taskDescription, server);
    }

    @Override
    protected void processRootModule(IWeblogicModule rootModule, IProgressMonitor monitor) throws CoreException {
        if (rootModule.getKind() == 3) {
            return;
        }
        List<IWeblogicModule> childModules = rootModule.getChildModules();
        if (childModules.size() == 0) {
            IModule webModule = this.getWebModule(rootModule);
            if (webModule != null && this.shouldRun(null, webModule)) {
                if (this.hasPublishableChanges(null, rootModule)) {
                    this.processWebModule(null, null, webModule, monitor);
                }
                this.processWebModuleEvenIfNoChanges(null, webModule, monitor);
            }
        } else {
            for (IWeblogicModule childModule : childModules) {
                this.processRootChildModule(rootModule, childModule, monitor);
            }
        }
    }

    protected void copyGeneratedWebRoot(IModule webModule, IPath generatedWebRoot) throws CoreException {
        IPath deployPath = this.getDeploymentPath(webModule);
        if (generatedWebRoot != null) {
            try {
                EclipseFileUtil.copyFiles((File)generatedWebRoot.toFile(), (File)deployPath.toFile());
            }
            catch (IOException e) {
                Status status = new Status(4, "oracle.eclipse.tools.weblogic", 4, "error.copy.publish", (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
    }

    protected void processRootChildModule(IWeblogicModule rootModule, IWeblogicModule childModule, IProgressMonitor monitor) throws CoreException {
        if (childModule.getKind() == 3) {
            return;
        }
        IModule earModule = this.getEarModule(rootModule);
        IModule webModule = this.getWebModule(childModule);
        if (webModule != null && this.shouldRun(earModule, webModule)) {
            if (this.hasPublishableChanges(rootModule, childModule)) {
                this.processWebModule(rootModule, earModule, webModule, monitor);
            }
            this.processWebModuleEvenIfNoChanges(earModule, webModule, monitor);
        }
    }

    protected IModule getEarModule(IWeblogicModule weblogicModule) {
        IModule module = weblogicModule.getModule();
        String typeId = module.getModuleType().getId();
        if (EAR_TYPE_IDS.contains(typeId)) {
            return module;
        }
        return null;
    }

    protected IModule getWebModule(IWeblogicModule weblogicModule) {
        IModule module = weblogicModule.getModule();
        String typeId = module.getModuleType().getId();
        if (WEB_TYPE_IDS.contains(typeId)) {
            return module;
        }
        return null;
    }

    protected void updateSplitSourceDescriptor(IModule earModule, IModule webModule, IProgressMonitor monitor, IPath generatedWebRoot) throws CoreException {
        block16: {
            File file = null;
            CoreException originalException = null;
            IPath filePath = this.getDeploymentPath(earModule);
            file = filePath.toFile();
            VirtualFileSystem vfs = null;
            try {
                try {
                    vfs = VirtualEarManager.readDescriptor(file);
                    if (generatedWebRoot != null) {
                        IProject earProject = earModule.getProject();
                        IVirtualComponent webComp = ComponentCore.createComponent((IProject)webModule.getProject());
                        IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider((IProject)earProject);
                        String uri = earModel.getModuleURI(webComp);
                        if (uri != null) {
                            vfs.link(generatedWebRoot.toString(), uri);
                        }
                    }
                }
                catch (Exception e) {
                    Status status = new Status(4, "oracle.eclipse.tools.weblogic", 4, "error.split.source", (Throwable)e);
                    originalException = new CoreException((IStatus)status);
                    if (vfs == null) break block16;
                    try {
                        VirtualEarManager.writeDescriptor(file, vfs);
                    }
                    catch (IOException e2) {
                        if (originalException == null) {
                            Status status2 = new Status(4, "oracle.eclipse.tools.weblogic", 4, _resourceLoader.resource("error.split.source", new Object[0]), (Throwable)e2);
                            throw new CoreException((IStatus)status2);
                        }
                        throw originalException;
                    }
                }
            }
            finally {
                if (vfs != null) {
                    try {
                        VirtualEarManager.writeDescriptor(file, vfs);
                    }
                    catch (IOException e) {
                        if (originalException == null) {
                            Status status = new Status(4, "oracle.eclipse.tools.weblogic", 4, _resourceLoader.resource("error.split.source", new Object[0]), (Throwable)e);
                            throw new CoreException((IStatus)status);
                        }
                        throw originalException;
                    }
                }
            }
        }
    }

    protected void updateAutoGeneratedSplitSourceDescriptor(IModule webModule, IProgressMonitor monitor, IPath generatedWebRoot) throws CoreException {
        block16: {
            VirtualFileSystem vfs = null;
            CoreException originalException = null;
            Server server = (Server)this._server;
            IPath path = server.getTempDirectory();
            WeblogicServerBehaviour serverBehavior = (WeblogicServerBehaviour)server.loadAdapter(WeblogicServerBehaviour.class, monitor);
            WeblogicServer weblogicServer = (WeblogicServer)server.loadAdapter(WeblogicServer.class, null);
            if (weblogicServer.isRemote()) {
                return;
            }
            ServerInfo serverInfo = serverBehavior.getServerInfo();
            IPath dirPath = path.append(serverInfo.getDomainName()).append("_auto_generated_ear_");
            File earRoot = dirPath.toFile();
            try {
                try {
                    vfs = VirtualEarManager.readDescriptor(earRoot);
                    if (generatedWebRoot != null) {
                        String uri = String.valueOf(webModule.getName()) + ".war";
                        vfs.link(generatedWebRoot.toString(), uri);
                    }
                }
                catch (Exception e) {
                    Status status = new Status(4, "oracle.eclipse.tools.weblogic", 4, "error.split.source", (Throwable)e);
                    originalException = new CoreException((IStatus)status);
                    if (vfs == null) break block16;
                    try {
                        VirtualEarManager.writeDescriptor(earRoot, vfs);
                    }
                    catch (IOException e2) {
                        if (originalException == null) {
                            Status status2 = new Status(4, "oracle.eclipse.tools.weblogic", 4, _resourceLoader.resource("error.split.source", new Object[0]), (Throwable)e2);
                            throw new CoreException((IStatus)status2);
                        }
                        throw originalException;
                    }
                }
            }
            finally {
                if (vfs != null) {
                    try {
                        VirtualEarManager.writeDescriptor(earRoot, vfs);
                    }
                    catch (IOException e) {
                        if (originalException == null) {
                            Status status = new Status(4, "oracle.eclipse.tools.weblogic", 4, _resourceLoader.resource("error.split.source", new Object[0]), (Throwable)e);
                            throw new CoreException((IStatus)status);
                        }
                        throw originalException;
                    }
                }
            }
        }
    }

    protected IPath getDeploymentPath(IModule module) throws CoreException {
        IWeblogicServerDeployment wsDeployment = (IWeblogicServerDeployment)this._server.loadAdapter(IWeblogicServerDeployment.class, null);
        if (wsDeployment == null) {
            String msg = CorePlugin.getString("errorPublishTaskDelegate", new Object[0]);
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        return wsDeployment.getDeploymentPath(module);
    }

    protected abstract boolean hasPublishableChanges(IWeblogicModule var1, IWeblogicModule var2) throws CoreException;

    protected abstract void processWebModuleEvenIfNoChanges(IModule var1, IModule var2, IProgressMonitor var3) throws CoreException;

    protected abstract void processWebModule(IWeblogicModule var1, IModule var2, IModule var3, IProgressMonitor var4) throws CoreException;

    protected abstract boolean shouldRun(IModule var1, IModule var2) throws CoreException;
}

