/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TemplateInfo
implements Comparable {
    public String version = null;
    public String type = null;
    public String name = null;
    public String description = null;
    public String location = "";
    public String selectable = "false";
    public String compRef = null;
    private List<String> dependencyNames = new ArrayList<String>();
    private List<TemplateInfo> dependencies = new ArrayList<TemplateInfo>();
    private Set<String> conflictNames = new HashSet<String>();

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return String.valueOf(this.name) + " - " + this.version;
    }

    public String getCompRef() {
        return this.compRef;
    }

    public void setCompRef(String ref) {
        this.compRef = ref;
    }

    public List<String> getDependencyNames() {
        return this.dependencyNames;
    }

    public void addDependencyName(String name) {
        this.dependencyNames.add(name);
    }

    TemplateInfo() {
    }

    public void addDependency(TemplateInfo t) {
        this.dependencies.add(t);
    }

    public List<TemplateInfo> getDependencies() {
        return this.dependencies;
    }

    public void addConflict(String name) {
        this.conflictNames.add(name);
    }

    public Set<String> getConflicts() {
        return this.conflictNames;
    }

    public int compareTo(Object o) {
        if (o instanceof TemplateInfo) {
            TemplateInfo t2 = (TemplateInfo)o;
            if (this.isInDependency(t2, this, new HashSet<TemplateInfo>())) {
                return -1;
            }
            if (this.isInDependency(this, t2, new HashSet<TemplateInfo>())) {
                return 1;
            }
        }
        return 0;
    }

    private boolean isInDependency(TemplateInfo t1, TemplateInfo t2, HashSet<TemplateInfo> stack) {
        if (t1.equals(t2)) {
            return false;
        }
        for (TemplateInfo t : t1.getDependencies()) {
            if (t.equals(t2)) {
                return true;
            }
            if (!t.selectable.equals("true") || stack.contains(t)) continue;
            stack.add(t);
            boolean ret = this.isInDependency(t, t2, stack);
            if (!ret) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof TemplateInfo) {
            TemplateInfo t2 = (TemplateInfo)o;
            return t2.getFullName().equals(this.getFullName());
        }
        return super.equals(o);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.name, this.location, this.type, this.version});
    }

    public String toString() {
        StringBuffer dependencies = new StringBuffer();
        for (String s : this.dependencyNames) {
            dependencies.append(String.valueOf(s) + ",");
        }
        StringBuffer conflicts = new StringBuffer();
        for (String s : this.conflictNames) {
            conflicts.append(String.valueOf(s) + ",");
        }
        return String.valueOf(this.getFullName()) + "[ selectable=" + this.selectable + " ]" + (dependencies.length() > 0 ? ", Requires:[" + dependencies.toString() + "]" : "") + (conflicts.length() > 0 ? ", Conflicts:[" + conflicts.toString() + "]" : "") + "CompRef:[" + this.compRef + "]";
    }
}

