/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.ModuleUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.UpdateServerJob;

public class ServerLaunchUtils {
    public static final String ATTR_VM_CONNECTOR_ID = "ATTR_VM_CONNECTOR_ID";
    public static final String ATTR_ATTACH_DEBUG = "attachDebug";
    public static final String ID_WIDE_SOCKET_ATTACH_VM_CONNECTOR = "wideSocketAttachConnector";
    public static final String LAUNCH_BROWSER_AFTER_START = "LAUNCH_BROWSER_AFTER_START";
    public static final Object ID_ESSEX_RUNTIME = "com.bea.weblogic103";
    public static final String DEFAULT_URL = "DEFAULT_URL";
    public static final String J2EE_CP = "com.bea.wstudio.j2ee.container";
    public static final String OBSOLETE_J2EE_CP = "J2ee.runtime.m7";
    private static Map<String, IModule> serverModuleMap = new HashMap<String, IModule>();

    public static List<IProject> findAllWebProject(IServer server) {
        ArrayList<IProject> list = new ArrayList<IProject>();
        IModule[] modules = server.getModules();
        int i = 0;
        while (i < modules.length) {
            if (modules[i] instanceof Module) {
                Module module = (Module)modules[i];
                if (FacetUtil.hasWebFacet((IModule)module)) {
                    list.add(module.getProject());
                } else {
                    IModule[] childModules;
                    FacetUtil.hasEarFacet((IModule)module);
                    IModule[] iModuleArray = childModules = module.getChildModules((IProgressMonitor)new NullProgressMonitor());
                    int n = childModules.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModule m = iModuleArray[n2];
                        if (FacetUtil.hasWebFacet(m)) {
                            list.add(m.getProject());
                        }
                        ++n2;
                    }
                }
            }
            ++i;
        }
        return list;
    }

    public static IProject getFirstWebModuleInServer(IServer server) {
        IModule[] modules = server.getModules();
        if (modules != null && modules.length > 0) {
            int i = 0;
            while (i < modules.length) {
                IProject project;
                if (!(modules[i] instanceof DeletedModule) && (project = modules[i].getProject()) != null) {
                    IProject webProj;
                    String projectType = J2EEProjectUtilities.getJ2EEProjectType((IProject)project);
                    if ("jst.web".equals(projectType)) {
                        return project;
                    }
                    if ("jst.ear".equals(projectType) && (webProj = ServerLaunchUtils.getFirstWebProjectInEar(project)) != null) {
                        return webProj;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private static IProject getFirstWebProjectInEar(IProject project) {
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)project);
        IVirtualReference[] refs = earComp.getReferences();
        int i = 0;
        while (i < refs.length) {
            IVirtualComponent c = refs[i].getReferencedComponent();
            IProject p = c.getProject();
            String projectType = J2EEProjectUtilities.getJ2EEProjectType((IProject)p);
            if ("jst.web".equals(projectType)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public static String findOpenURLFromEAProject(String baseURL, IProject earProject) {
        String ctxRoot = null;
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        IVirtualReference[] refs = earComp.getReferences();
        int i = 0;
        while (i < refs.length) {
            IVirtualComponent c = refs[i].getReferencedComponent();
            IProject p = c.getProject();
            String projectType = J2EEProjectUtilities.getJ2EEProjectType((IProject)p);
            if ("jst.web".equals(projectType)) {
                ctxRoot = J2EEProjectUtilities.getServerContextRoot((IProject)p);
                break;
            }
            ++i;
        }
        if (ctxRoot != null) {
            return String.valueOf(baseURL) + (ctxRoot.startsWith("/") ? ctxRoot : "/" + ctxRoot);
        }
        return baseURL;
    }

    public static void addJarFilesFromFolder(File folder, List<URL> list) {
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() && files[i].getName().endsWith(".jar")) {
                try {
                    list.add(files[i].toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public static void cleanUpWebXml(File file) {
    }

    public static String checkProjectBuildPath(IProject p) {
        return ServerLaunchUtils.checkProjectBuildPath(p, false);
    }

    public static String checkProjectBuildPath(IProject p, boolean ignoreSrcOutput) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IJavaProject proj = JavaCore.create((IProject)p);
        IVirtualComponent c = ComponentCore.createComponent((IProject)p);
        IPath webRoot = c.getRootFolder().getUnderlyingResource().getFullPath();
        StringBuffer cpOutsideWEBINF = new StringBuffer();
        try {
            Hashtable<String, String> excludedCpList = new Hashtable<String, String>();
            IClasspathEntry[] cpEntries = proj.getRawClasspath();
            int i = 0;
            while (i < cpEntries.length) {
                IClasspathEntry cp = cpEntries[i];
                if (cp.getEntryKind() == 5) {
                    IPath path1 = cp.getPath();
                    String containerName = path1.toString();
                    if (containerName.indexOf("org.eclipse.jst.j2ee.internal.web.container") >= 0 || containerName.indexOf("org.eclipse.jst.server.core.container") >= 0 || containerName.indexOf("org.eclipse.jdt.launching.JRE_CONTAINER") >= 0 || containerName.indexOf("com.bea.workshop") >= 0 || containerName.indexOf("com.bea.wlp") >= 0 || containerName.indexOf("oracle.eclipse.tools") >= 0 || containerName.indexOf(J2EE_CP) >= 0 || containerName.indexOf(OBSOLETE_J2EE_CP) >= 0) {
                        IClasspathContainer cpc = JavaCore.getClasspathContainer((IPath)path1, (IJavaProject)proj);
                        if (cpc != null) {
                            IClasspathEntry[] es = cpc.getClasspathEntries();
                            int j = 0;
                            while (j < es.length) {
                                excludedCpList.put(es[j].getPath().toString(), "");
                                ++j;
                            }
                        }
                    } else {
                        System.out.println(containerName);
                    }
                }
                ++i;
            }
            HashMap<String, String> mapClspathCompDep = ServerLaunchUtils.getClasspathComponentDependencies(proj);
            IClasspathEntry[] allCpEntries = proj.getResolvedClasspath(true);
            int i2 = 0;
            while (i2 < allCpEntries.length) {
                block19: {
                    String path;
                    IClasspathEntry cpe;
                    block21: {
                        block20: {
                            block18: {
                                cpe = allCpEntries[i2];
                                if (cpe.getEntryKind() != 3) break block18;
                                IPath outputPath = cpe.getOutputLocation();
                                if (outputPath == null) {
                                    outputPath = proj.getOutputLocation();
                                }
                                path = outputPath.toString();
                                if (!ignoreSrcOutput && !ServerLaunchUtils.isPathInWEBINF(path, webRoot.toString()) && cpOutsideWEBINF.indexOf(path) < 0) {
                                    cpOutsideWEBINF.append(String.valueOf(path) + "\n");
                                }
                                break block19;
                            }
                            if (cpe.getEntryKind() != 4) break block20;
                            cpe = JavaCore.getResolvedClasspathEntry((IClasspathEntry)cpe);
                            break block21;
                        }
                        if (cpe.getEntryKind() != 2) break block21;
                        IProject p2 = workspace.getRoot().getProject(cpe.getPath().lastSegment());
                        IVirtualReference ref = c.getReference(p2.getName());
                        if (ref != null) break block19;
                        IJavaProject proj2 = JavaCore.create((IProject)p2);
                        try {
                            String[] clsPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)proj2);
                            int j = 0;
                            while (j < clsPath.length) {
                                cpOutsideWEBINF.append(String.valueOf(clsPath[j]) + "\n");
                                ++j;
                            }
                        }
                        catch (CoreException e1) {
                            e1.printStackTrace();
                        }
                    }
                    String cpath = cpe.getPath().toString();
                    if (excludedCpList.get(cpath) == null && !ServerLaunchUtils.isPathInWEBINF(cpath, webRoot.toString())) {
                        path = cpe.getPath();
                        String strPath = path.toString();
                        IResource res = workspace.getRoot().findMember((IPath)path);
                        if (res != null) {
                            strPath = res.getLocation().toPortableString();
                        }
                        if (mapClspathCompDep.get(strPath) == null) {
                            cpOutsideWEBINF.append(String.valueOf(strPath) + "\n");
                        }
                    }
                }
                ++i2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return cpOutsideWEBINF.toString();
    }

    public static HashMap<String, String> getClasspathComponentDependencies(IJavaProject p) {
        HashMap<String, String> ret = new HashMap<String, String>();
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Map map = ClasspathDependencyUtil.getComponentClasspathDependencies((IJavaProject)p, (boolean)true);
            for (Map.Entry entry : map.entrySet()) {
                IClasspathEntry resolvedEntry = (IClasspathEntry)entry.getKey();
                IClasspathAttribute attr = (IClasspathAttribute)entry.getValue();
                IPath path = resolvedEntry.getPath();
                String srcPath = path.toString();
                IResource res = workspace.getRoot().findMember(path);
                if (res != null) {
                    srcPath = res.getLocation().toPortableString();
                }
                String rtPath = attr.getValue();
                ret.put(srcPath, rtPath);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static boolean isPathInWEBINF(String strPath, String webRoot) {
        return strPath.indexOf(String.valueOf(webRoot) + "/WEB-INF/classes") >= 0 || strPath.indexOf(String.valueOf(webRoot) + "/WEB-INF/lib") >= 0;
    }

    public static boolean hasWebModule(IServer server) {
        IProject webProject = ServerLaunchUtils.getFirstWebModuleInServer(server);
        return webProject != null;
    }

    public static void setModuleToLaunch(IServer server, IModule module) {
        serverModuleMap.put(server.getId(), module);
    }

    public static IModule getModuleToLaunch(IServer server) {
        return serverModuleMap.get(server.getId());
    }

    public static void updateWlsServerState() {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            IServer server = servers[i];
            if (WebLogicServerUtil.isWebLogicServer(server)) {
                UpdateServerJob job = new UpdateServerJob(new IServer[]{server});
                job.schedule();
            }
            ++i;
        }
    }

    public static boolean hasEssexRuntime() {
        IRuntime[] rts;
        IRuntime[] iRuntimeArray = rts = ServerCore.getRuntimes();
        int n = rts.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IRuntime rt = iRuntimeArray[n2];
            IRuntimeType rtType = rt.getRuntimeType();
            if (rtType != null && ID_ESSEX_RUNTIME.equals(id = rtType.getId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Float getEclipseVMVersion() {
        String javaVer = System.getProperty("java.version", "");
        if (javaVer.length() > 2) {
            String version = javaVer.substring(0, 3);
            try {
                Float f = Float.valueOf(version);
                return f;
            }
            catch (Exception exception) {}
        }
        return new Float("1.5");
    }

    public static IPath getAutoGeneratedEarPath(Server server) {
        IPath path = server.getTempDirectory();
        WeblogicServerBehaviour weblogicServer = (WeblogicServerBehaviour)server.loadAdapter(WeblogicServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor());
        if (weblogicServer.getWeblogicServer().isRemote()) {
            return null;
        }
        ServerInfo serverInfo = weblogicServer.getServerInfo();
        IPath dirPath = path.append(serverInfo.getDomainName()).append("_auto_generated_ear_");
        return dirPath;
    }

    public static boolean hasEjbModules(Server server) {
        IModule[] modules;
        IModule[] iModuleArray = modules = server.getModules();
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            if (!(m instanceof DeletedModule)) {
                if (ModuleUtil.isEJBModule(m)) {
                    return true;
                }
                if (ModuleUtil.isEARModule(m)) {
                    IModule[] childModules;
                    IModule[] iModuleArray2 = childModules = server.getChildModules(new IModule[]{m}, (IProgressMonitor)new NullProgressMonitor());
                    int n3 = childModules.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModule cm = iModuleArray2[n4];
                        if (ModuleUtil.isEJBModule(cm)) {
                            return true;
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasMultiGarModulesInEar(Server server) {
        IModule[] modules;
        IModule[] iModuleArray = modules = server.getModules();
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            if (ModuleUtil.isEARModule(m)) {
                IModule[] childModules;
                boolean foundGar = false;
                IModule[] iModuleArray2 = childModules = server.getChildModules(new IModule[]{m}, (IProgressMonitor)new NullProgressMonitor());
                int n3 = childModules.length;
                int n4 = 0;
                while (n4 < n3) {
                    IModule cm = iModuleArray2[n4];
                    if (!(cm instanceof DeletedModule) && ModuleUtil.isCoherenceGarModule(cm)) {
                        if (foundGar) {
                            return true;
                        }
                        foundGar = true;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }
}

