/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal.util;

import oracle.eclipse.tools.weblogic.server.CorePlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;

public class ModuleUtil {
    private static final String COHERENCE_GAR = "oracle.coherence.gar";

    public static IResource findComponentResource(IModule module, String path) throws CoreException {
        IProject project = module.getProject();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project, (String)module.getName());
        IVirtualResource resource = component.getRootFolder().findMember(path);
        IResource[] resources = resource.getUnderlyingResources();
        if (resources == null || resources.length == 0) {
            return null;
        }
        IResource result = resources[0];
        int i = 1;
        int l = resources.length;
        while (i < l) {
            if (resources[i].getFullPath().segmentCount() < result.getFullPath().segmentCount()) {
                result = resources[i];
            }
            ++i;
        }
        return result;
    }

    public static boolean isEARModule(IModule[] modulePath) {
        return ModuleUtil.matchModuleType(modulePath, "jst.ear");
    }

    public static boolean isWebModule(IModule[] modulePath) {
        return ModuleUtil.matchModuleType(modulePath, "jst.web");
    }

    public static boolean isEJBModule(IModule[] modulePath) {
        return ModuleUtil.matchModuleType(modulePath, "jst.ejb");
    }

    public static boolean isUtilityModule(IModule[] modulePath) {
        return ModuleUtil.matchModuleType(modulePath, "jst.utility");
    }

    public static boolean isConnectorModule(IModule[] modulePath) {
        return ModuleUtil.matchModuleType(modulePath, "jst.connector");
    }

    public static boolean isClientModule(IModule[] modulePath) {
        return ModuleUtil.matchModuleType(modulePath, "jst.appclient");
    }

    public static boolean isEARModule(IModule module) {
        return ModuleUtil.matchModuleType(module, "jst.ear");
    }

    public static boolean isWebModule(IModule module) {
        return ModuleUtil.matchModuleType(module, "jst.web");
    }

    public static boolean isEJBModule(IModule module) {
        return ModuleUtil.matchModuleType(module, "jst.ejb");
    }

    public static boolean isUtilityModule(IModule module) {
        return ModuleUtil.matchModuleType(module, "jst.utility");
    }

    public static boolean isCoherenceGarModule(IModule module) {
        return ModuleUtil.matchModuleType(module, COHERENCE_GAR);
    }

    public static boolean isWebFragmentModule(IModule module) {
        return ModuleUtil.matchModuleType(module, "jst.webfragment");
    }

    public static boolean isConnectorModule(IModule module) {
        return ModuleUtil.matchModuleType(module, "jst.connector");
    }

    public static boolean isClientModule(IModule module) {
        return ModuleUtil.matchModuleType(module, "jst.appclient");
    }

    public static String getContextRoot(IModule module) {
        return J2EEProjectUtilities.getServerContextRoot((IProject)module.getProject());
    }

    private static boolean matchModuleType(IModule[] modulePath, String typeId) {
        IModule module = modulePath[modulePath.length - 1];
        IModuleType type = module.getModuleType();
        if (type == null) {
            return false;
        }
        return typeId.equals(type.getId());
    }

    private static boolean matchModuleType(IModule module, String typeId) {
        IModuleType type = module.getModuleType();
        if (type == null) {
            return false;
        }
        return typeId.equals(type.getId());
    }

    public static IStatus[] convertStatus(IMarker[] markers) {
        IStatus[] result = new IStatus[markers.length];
        int i = 0;
        while (i < markers.length) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(markers[i].getAttribute("message", ""));
            String resName = markers[i].getResource().getName();
            if (resName != null && resName.length() > 0) {
                buffer.append(" at " + resName);
            }
            result[i] = CorePlugin.createErrorStatus(buffer.toString());
            ++i;
        }
        return result;
    }
}

