/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal.util;

import oracle.eclipse.tools.weblogic.facets.WlsEarFacet;
import oracle.eclipse.tools.weblogic.facets.WlsGarFacet;
import oracle.eclipse.tools.weblogic.facets.WlsWebFacet;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;

public class FacetUtil {
    public static final IProjectFacet FACET_JST_EAR = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
    public static final IProjectFacet FACET_JST_WEB = ProjectFacetsManager.getProjectFacet((String)"jst.web");
    public static final IProjectFacet FACET_JST_UTE = ProjectFacetsManager.getProjectFacet((String)"jst.utility");
    public static final IProjectFacet FACET_JST_RAR = ProjectFacetsManager.getProjectFacet((String)"jst.connector");
    public static final IProjectFacet FACET_JST_EJB = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
    public static final CorePlugin.LevelLog LOG = CorePlugin.getLevelLog();

    public static final boolean hasProjectFacet(IModule module, IProjectFacet facet) {
        IFacetedProject facetProject;
        block7: {
            block6: {
                block5: {
                    try {
                        if (module != null) break block5;
                        return false;
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                }
                if (module.getProject() != null) break block6;
                return false;
            }
            facetProject = ProjectFacetsManager.create((IProject)module.getProject());
            if (facetProject != null) break block7;
            return false;
        }
        return facetProject.hasProjectFacet(facet);
    }

    public static final boolean hasEarFacet(IModule module) {
        return FacetUtil.hasProjectFacet(module, FACET_JST_EAR);
    }

    public static final boolean hasWebLogicEarFacet(IModule module) {
        return FacetUtil.hasProjectFacet(module, WlsEarFacet.FACET);
    }

    public static final boolean hasWebFacet(IModule module) {
        return FacetUtil.hasProjectFacet(module, FACET_JST_WEB);
    }

    public static final boolean hasWebLogicGarFacet(IModule module) {
        return FacetUtil.hasProjectFacet(module, WlsGarFacet.FACET);
    }

    public static final boolean hasWebLogicWebFacet(IModule module) {
        return FacetUtil.hasProjectFacet(module, WlsWebFacet.FACET);
    }

    public static final boolean hasEjbFacet(IModule module) {
        return FacetUtil.hasProjectFacet(module, FACET_JST_EJB);
    }

    public static final boolean hasUtilityFacet(IModule module) {
        return FacetUtil.hasProjectFacet(module, FACET_JST_UTE);
    }

    public static final boolean hasConnectorFacet(IModule module) {
        return FacetUtil.hasProjectFacet(module, FACET_JST_RAR);
    }

    public static final String getResourceExtension(IProject module) {
        IFacetedProject facetProject;
        block11: {
            block10: {
                block9: {
                    block8: {
                        if (module == null) {
                            return ".jar";
                        }
                        try {
                            facetProject = ProjectFacetsManager.create((IProject)module);
                            if (!facetProject.hasProjectFacet(FACET_JST_WEB)) break block8;
                            return ".war";
                        }
                        catch (CoreException ce) {
                            CorePlugin.getLevelLog().log(ce.getStatus());
                            return ".jar";
                        }
                    }
                    if (!facetProject.hasProjectFacet(FACET_JST_EJB)) break block9;
                    return ".jar";
                }
                if (!facetProject.hasProjectFacet(FACET_JST_RAR)) break block10;
                return ".rar";
            }
            if (!facetProject.hasProjectFacet(WlsGarFacet.FACET)) break block11;
            return ".gar";
        }
        if (facetProject.hasProjectFacet(FACET_JST_EAR)) {
            return ".ear";
        }
        return ".jar";
    }
}

