/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.internal.ServerConfiguration;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.server.internal.util.DomainInfo;
import oracle.eclipse.tools.weblogic.server.internal.util.TemplateInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomainTemplateUtil {
    public static final String OWSM_PM_TEMPLATE = "Oracle WSM Policy Manager";
    public static final String OWSM_PM_FILE_TEMPLATE = "Oracle WSM Policy Manager - File";
    private static Map<IRuntime, Map<String, TemplateInfo>> templateInfoCache = new HashMap<IRuntime, Map<String, TemplateInfo>>();
    private static Map<String, TreeSet<String>> compRefMap = new HashMap<String, TreeSet<String>>();
    public static final String EXTENSION_TEMPLATE_TYPE = "Extension Template";
    public static final String CERATION_TEMPLATE_TYPE = "Domain Template";

    public static Map<String, TemplateInfo> findAllDomainExtensionTemplates(IRuntime rt) {
        Map<String, TemplateInfo> maps = templateInfoCache.get(rt);
        if (maps == null) {
            maps = new HashMap<String, TemplateInfo>();
            File wlHome = rt.getLocation().toFile();
            List<TemplateInfo> list = DomainTemplateUtil.findAllDomainExtensionTemplates(wlHome);
            for (TemplateInfo t : list) {
                if (maps.get(t.getFullName()) != null) continue;
                maps.put(t.getFullName(), t);
                String compRef = t.getCompRef();
                if (compRef == null) continue;
                TreeSet<String> comp = compRefMap.get(compRef);
                if (comp == null) {
                    comp = new TreeSet();
                    compRefMap.put(compRef, comp);
                }
                comp.add(t.getFullName());
            }
            DomainTemplateUtil.buildDependency(maps, list);
            templateInfoCache.put(rt, maps);
        }
        return maps;
    }

    public static void addDependencies(IRuntime rt, TemplateInfo template, Set<TemplateInfo> dependencies) {
        Map<String, TemplateInfo> allTemplates = DomainTemplateUtil.findAllDomainExtensionTemplates(rt);
        for (String s : template.getDependencyNames()) {
            TemplateInfo t2;
            boolean existing = false;
            for (TemplateInfo t2 : dependencies) {
                if (!t2.getFullName().equals(s)) continue;
                existing = true;
                break;
            }
            if (existing || (t2 = allTemplates.get(s)) == null) continue;
            if (t2.selectable.equals("true")) {
                dependencies.add(t2);
            }
            DomainTemplateUtil.addDependencies(rt, t2, dependencies);
        }
        WebLogicServerVersion wlsVersion = WebLogicServerVersion.detect(rt);
        if (wlsVersion.compareTo(WebLogicServerVersion.VERSION_12_1_2) >= 0) {
            return;
        }
        String compRef = template.getCompRef();
        if (compRef != null) {
            for (String s : compRefMap.get(compRef)) {
                TemplateInfo dt = allTemplates.get(s);
                if (dt == null || dt == template) continue;
                dependencies.add(dt);
            }
        }
    }

    private static List<TemplateInfo> findAllDomainExtensionTemplates(File wlHome) {
        ArrayList<TemplateInfo> templates = new ArrayList<TemplateInfo>();
        File wlsDomainTemplatesDir = new File(wlHome, "/common/templates/domains");
        DomainTemplateUtil.addTemplates(wlHome, templates, wlsDomainTemplatesDir);
        File wls1212DomainTemplatesDir = new File(wlHome, "common/templates/wls");
        DomainTemplateUtil.addTemplates(wlHome, templates, wls1212DomainTemplatesDir);
        File wlsAppTemplatesDir = new File(wlHome, "/common/templates/applications");
        DomainTemplateUtil.addTemplates(wlHome, templates, wlsAppTemplatesDir);
        File mwHome = WlsRuntimeUtil.getMwHome(wlHome);
        File fmwTemplatesDir = new File(mwHome, "/oracle_common/common/templates/applications");
        DomainTemplateUtil.addTemplates(wlHome, templates, fmwTemplatesDir);
        File fmwWlsTemplatesDir = new File(mwHome, "/oracle_common/common/templates/wls");
        DomainTemplateUtil.addTemplates(wlHome, templates, fmwWlsTemplatesDir);
        Properties properties = WeblogicServerRuntime.getProductProperties(wlHome);
        if (properties != null) {
            for (Object propName : properties.keySet()) {
                if (!propName.toString().endsWith("_INSTALL_DIR") && !propName.toString().endsWith("JDEV_HOME")) continue;
                String prodInstallDir = properties.getProperty(propName.toString());
                if (propName.equals("WLS_INSTALL_DIR")) continue;
                File prodDir = new File(prodInstallDir);
                File prodDomainTemplatesDir = new File(prodDir, "/common/templates/domains");
                DomainTemplateUtil.addTemplates(wlHome, templates, prodDomainTemplatesDir);
                File prodDomainTemplatesDir2 = new File(prodDir, "/common/templates/wls");
                DomainTemplateUtil.addTemplates(wlHome, templates, prodDomainTemplatesDir2);
                File prodAppTemplatesDir = new File(prodDir, "/common/templates/applications");
                DomainTemplateUtil.addTemplates(wlHome, templates, prodAppTemplatesDir);
                File prodGroupsTemplatesDir = new File(prodDir, "/common/templates/groups");
                DomainTemplateUtil.addTemplates(wlHome, templates, prodGroupsTemplatesDir);
            }
        }
        return templates;
    }

    private static void buildDependency(Map<String, TemplateInfo> maps, List<TemplateInfo> templates) {
        for (TemplateInfo template : templates) {
            for (String name : template.getDependencyNames()) {
                TemplateInfo dt = maps.get(name);
                if (dt == null) continue;
                template.addDependency(dt);
            }
            String compRef = template.getCompRef();
            if (compRef == null) continue;
            for (String s : compRefMap.get(compRef)) {
                TemplateInfo dt = maps.get(s);
                if (dt == null || dt == template) continue;
                template.addDependency(dt);
            }
        }
    }

    private static void addTemplates(File wlHome, ArrayList<TemplateInfo> templates, File folder) {
        if (folder.exists()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().endsWith(".jar")) {
                    TemplateInfo tempInfo = DomainTemplateUtil.parseTemplateInfo(wlHome, f);
                    templates.add(tempInfo);
                }
                ++n2;
            }
        }
    }

    private static TemplateInfo parseTemplateInfo(File wlHome, File f) {
        TemplateInfo info;
        block25: {
            info = new TemplateInfo();
            info.location = f.getAbsolutePath().replace('\\', '/');
            WebLogicServerVersion wlsVer = WebLogicServerVersion.detect(wlHome);
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(f);
                    Element root = ServerConfiguration.parse(zip, "template-info.xml");
                    if (root != null) {
                        String version;
                        String depTemplateName;
                        info.name = root.getAttribute("name");
                        info.type = root.getAttribute("type");
                        info.version = root.getAttribute("version");
                        info.description = root.getAttribute("description");
                        String selectable = root.getAttribute("selectable");
                        info.selectable = wlsVer.compareTo(WebLogicServerVersion.VERSION_12_1_2) < 0 ? (info.name.equals(OWSM_PM_TEMPLATE) ? "false" : (info.name.equals(OWSM_PM_FILE_TEMPLATE) ? "true" : (selectable == null ? "false" : selectable))) : (selectable == null ? "false" : selectable);
                        Document xmlDocument = root.getOwnerDocument();
                        XPath xPath = XPathFactory.newInstance().newXPath();
                        XPathExpression xPathExpression = xPath.compile("//dependency/and/requires");
                        NodeList nodes = (NodeList)xPathExpression.evaluate(xmlDocument, XPathConstants.NODESET);
                        int j = nodes.getLength();
                        int i = 0;
                        while (i < j) {
                            depTemplateName = nodes.item(i).getAttributes().getNamedItem("name").getTextContent();
                            version = DomainTemplateUtil.getVersion(nodes.item(i));
                            if (version != null) {
                                info.addDependencyName(String.valueOf(depTemplateName) + " - " + version);
                            }
                            ++i;
                        }
                        xPathExpression = xPath.compile("//dependency/requires");
                        nodes = (NodeList)xPathExpression.evaluate(xmlDocument, XPathConstants.NODESET);
                        j = nodes.getLength();
                        i = 0;
                        while (i < j) {
                            depTemplateName = nodes.item(i).getAttributes().getNamedItem("name").getTextContent();
                            version = DomainTemplateUtil.getVersion(nodes.item(i));
                            if (version != null) {
                                info.addDependencyName(String.valueOf(depTemplateName) + " - " + version);
                            }
                            ++i;
                        }
                        xPathExpression = xPath.compile("//dependency/and/or/requires");
                        nodes = (NodeList)xPathExpression.evaluate(xmlDocument, XPathConstants.NODESET);
                        j = nodes.getLength();
                        if (j > 0) {
                            String depTemplateName2 = nodes.item(0).getAttributes().getNamedItem("name").getTextContent();
                            String depTemplateVresion = DomainTemplateUtil.getVersion(nodes.item(0));
                            if (depTemplateVresion != null) {
                                info.addDependencyName(String.valueOf(depTemplateName2) + " - " + depTemplateVresion);
                            }
                        }
                        xPathExpression = xPath.compile("//dependency/and/conflicts");
                        nodes = (NodeList)xPathExpression.evaluate(xmlDocument, XPathConstants.NODESET);
                        j = nodes.getLength();
                        i = 0;
                        while (i < j) {
                            String conflictTemplateName = nodes.item(i).getAttributes().getNamedItem("name").getTextContent();
                            version = DomainTemplateUtil.getVersion(nodes.item(i));
                            if (version != null) {
                                info.addConflict(String.valueOf(conflictTemplateName) + " - " + version);
                            }
                            ++i;
                        }
                        xPathExpression = xPath.compile("//comp-ref");
                        nodes = (NodeList)xPathExpression.evaluate(xmlDocument, XPathConstants.NODESET);
                        j = nodes.getLength();
                        i = 0;
                        while (i < j) {
                            String refName = nodes.item(i).getAttributes().getNamedItem("name").getTextContent();
                            info.setCompRef(refName);
                            ++i;
                        }
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    LoggingService.logDebug((String)"oracle.eclipse.tools.weblogic", (String)(String.valueOf(e.getMessage()) + " " + f.getAbsolutePath()));
                    try {
                        if (zip != null) {
                            zip.close();
                        }
                        break block25;
                    }
                    catch (IOException iOException) {}
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException iOException) {}
        }
        return info;
    }

    private static String getVersion(Node node) {
        Node attr = node.getAttributes().getNamedItem("version");
        if (attr != null) {
            return attr.getTextContent();
        }
        return null;
    }

    public static DomainInfo parseDomainInfo(WeblogicServer weblogicServer) throws CoreException {
        File domainDir = weblogicServer.getDomainPath().toFile();
        File domainInfoXml = new File(String.valueOf(domainDir.getAbsolutePath()) + "/init-info/domain-info.xml");
        if (domainInfoXml.exists()) {
            Element root = ServerConfiguration.parse(domainInfoXml);
            NodeList dnodes = root.getChildNodes();
            DomainInfo domainInfo = new DomainInfo(weblogicServer);
            int i = 0;
            while (i < dnodes.getLength()) {
                Node dnode = dnodes.item(i);
                if (dnode.getNodeType() == 1) {
                    Element elm = (Element)dnode;
                    TemplateInfo templateInfo = new TemplateInfo();
                    String dname = dnode.getNodeName();
                    if ("domain-template-ref".equals(dname)) {
                        templateInfo.name = elm.getAttribute("name");
                        templateInfo.version = elm.getAttribute("version");
                        templateInfo.location = elm.getAttribute("location").replace('\\', '/');
                        domainInfo.domainTemplate = templateInfo;
                    } else if ("extention-template-ref".equals(dname)) {
                        templateInfo.name = elm.getAttribute("name");
                        templateInfo.version = elm.getAttribute("version");
                        templateInfo.location = elm.getAttribute("location").replace('\\', '/');
                        domainInfo.extensionTemplates.add(templateInfo);
                    }
                }
                ++i;
            }
            return domainInfo;
        }
        return null;
    }

    public static Set<String> getAvailableExtensionTemplates(IServer server) {
        HashSet<String> values = new HashSet<String>();
        WeblogicServer weblogicServer = (WeblogicServer)server.loadAdapter(WeblogicServer.class, null);
        IRuntime runtime = server.getRuntime();
        try {
            DomainInfo domainInfo = DomainTemplateUtil.parseDomainInfo(weblogicServer);
            if (domainInfo == null) {
                throw new CoreException(WlsCorePlugin.createErrorStatus("Error parsing configuration for domain " + weblogicServer.getDomainPath()));
            }
            HashSet<String> templateNames = new HashSet<String>();
            for (TemplateInfo ref : domainInfo.extensionTemplates) {
                templateNames.add(ref.getFullName());
            }
            for (TemplateInfo info : DomainTemplateUtil.findAllDomainExtensionTemplates(runtime).values()) {
                if (info.getName() == null || !info.type.equals(EXTENSION_TEMPLATE_TYPE) || templateNames.contains(info.getFullName()) || !info.selectable.equals("true")) continue;
                values.add(info.getFullName());
            }
        }
        catch (CoreException e) {
            LoggingService.logError((String)"oracle.eclipse.tools.weblogic", (String)e.getMessage());
        }
        return values;
    }
}

