/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal.util;

import java.io.IOException;
import oracle.eclipse.tools.weblogic.server.CorePlugin;

public class BrowserLauncher {
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    public static void displayURL(String url) throws IOException {
        boolean windows = BrowserLauncher.isWindowsPlatform();
        String cmd = null;
        if (windows) {
            if (cmd == null) {
                cmd = "rundll32 url.dll,FileProtocolHandler " + url;
            }
        } else {
            if (CorePlugin.IS_MACOSX) {
                String[] cmdarray = new String[]{"open", url};
                Runtime.getRuntime().exec(cmdarray);
                return;
            }
            if (cmd != null && BrowserLauncher.tryLinuxBrowser(cmd, false)) {
                return;
            }
            cmd = "netscape -remote openURL(" + url + ")";
            if (BrowserLauncher.tryLinuxBrowser(cmd, true)) {
                return;
            }
            cmd = "netscape " + url;
            if (BrowserLauncher.tryLinuxBrowser(cmd, false)) {
                return;
            }
            cmd = "htmlview " + url;
            if (BrowserLauncher.tryLinuxBrowser(cmd, false)) {
                return;
            }
            throw new IOException("Could not locate a web browser.");
        }
        Runtime.getRuntime().exec(cmd);
    }

    private static boolean tryLinuxBrowser(String cmd, boolean waitFor) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            if (waitFor) {
                int exitCode = p.waitFor();
                return exitCode == 0;
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }
}

