/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicJspSourceContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class WeblogicServerSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        ArrayList<WeblogicJspSourceContainer> result = new ArrayList<WeblogicJspSourceContainer>();
        HashSet classpaths = new HashSet();
        Collections.addAll(classpaths, JavaRuntime.computeUnresolvedSourceLookupPath((ILaunchConfiguration)configuration));
        Set<IModule> modules = WeblogicServerSourcePathComputerDelegate.getAllServerModules(configuration, monitor);
        if (modules.size() > 0) {
            for (IModule module : modules) {
                IProject project = module.getProject();
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                if (component != null && component.exists()) {
                    result.add(new WeblogicJspSourceContainer(component));
                }
                if (project == null || !project.hasNature("org.eclipse.jdt.core.javanature")) continue;
                IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                Collections.addAll(classpaths, JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)javaProject));
            }
        } else {
            IResource[] iResourceArray = ResourcesPlugin.getWorkspace().getRoot().members();
            int project = iResourceArray.length;
            int n = 0;
            while (n < project) {
                IProject p;
                IResource res = iResourceArray[n];
                if (res instanceof IProject && (p = (IProject)res).isAccessible()) {
                    IVirtualComponent component = ComponentCore.createComponent((IProject)p);
                    if (component != null && component.exists()) {
                        result.add(new WeblogicJspSourceContainer(component));
                    }
                    if (p.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject javaProject = (IJavaProject)p.getNature("org.eclipse.jdt.core.javanature");
                        Collections.addAll(classpaths, JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)javaProject));
                    }
                }
                ++n;
            }
        }
        try {
            IRuntimeClasspathEntry[] entries = new IRuntimeClasspathEntry[classpaths.size()];
            classpaths.toArray(entries);
            IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveSourceLookupPath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
            ISourceContainer[] source = JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved);
            Collections.addAll(result, source);
        }
        catch (CoreException ce) {
            CorePlugin.getLevelLog().log(ce.getStatus());
        }
        return result.toArray(new ISourceContainer[result.size()]);
    }

    private static Set<IModule> getAllServerModules(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        HashSet<IModule> modules = new HashSet<IModule>();
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            return Collections.EMPTY_SET;
        }
        WeblogicServerSourcePathComputerDelegate.addAllModulesTo(modules, server, server.getModules(), monitor);
        return modules;
    }

    private static void addAllModulesTo(Collection<IModule> result, IServer server, IModule[] modules, IProgressMonitor monitor) {
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            result.add(module);
            WeblogicServerSourcePathComputerDelegate.addAllModulesTo(result, server, server.getChildModules(new IModule[]{module}, monitor), monitor);
            ++n2;
        }
    }
}

