/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerLaunchConfiguration;
import oracle.eclipse.tools.weblogic.server.IWlsAdapterListener;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.server.internal.util.ServerLaunchUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;

public class WeblogicServerLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate
implements IWeblogicServerLaunchConfiguration {
    private static final IServer[] EMPTY_SERVERS = new IServer[0];
    private static final boolean DEFAULT_DEBUG_PORT_OPEN = true;
    private static final String LOCAL_HOST = "localhost";
    private static final String DEBUG_MODE = "debug";
    public static final String ATTR_SEMI_RESTART = "attr-semi-restart";
    private static final String ATTR_WEBLOGIC_INIT_FLAG = "attr-weblogic-initialized";
    public static final String ID_WEBLOGIC_SOCKET_ATTACH_CONNECTOR = "oracle.eclipse.tools.weblogic.server.debugger.socketAttachConnector";

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = this.getServer(config);
        ILaunchConfigurationWorkingCopy workingCopy = config.getWorkingCopy();
        IWeblogicServer weblogic = (IWeblogicServer)server.loadAdapter(IWeblogicServer.class, null);
        if (weblogic.isRemote() && mode.equals(DEBUG_MODE)) {
            String hostname = weblogic.getServerInfo().getHostName();
            this.setDebugArgument(workingCopy, "hostname", hostname);
            this.attachToRemoteServer((ILaunchConfiguration)workingCopy, mode, launch, monitor);
            return;
        }
        monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
        WeblogicServerBehaviour behaviour = (WeblogicServerBehaviour)this.getServer(config).loadAdapter(WeblogicServerBehaviour.class, null);
        behaviour.setupLaunchConfiguration(workingCopy, monitor);
        if (weblogic.isRemote()) {
            int MAX_RETRY = 10;
            int i = 0;
            while (i < MAX_RETRY) {
                if (server.getServerState() == 2) break;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
            monitor.setCanceled(true);
            return;
        }
        IStatus status = this.validateConfiguration(config);
        if (!status.isOK()) {
            monitor.setCanceled(true);
            throw new CoreException(status);
        }
        boolean debugging = DEBUG_MODE.equals(mode);
        behaviour.setSurpassNoWebModuleWarning(true);
        if (server.getServerState() == 4 || server.getServerState() == 0 || server.getServerState() == 1) {
            try {
                monitor.beginTask("", 60000 + (debugging ? 10000 : 0));
                monitor.subTask(CorePlugin.getString("msgJobServerLaunch", new Object[0]));
                if (debugging) {
                    this.setRunWithDebug(workingCopy, true);
                }
                this.launch(workingCopy, launch, mode, monitor);
                if (monitor.isCanceled()) {
                    return;
                }
                if (!debugging) {
                    this.attach(workingCopy, mode, launch, monitor);
                    return;
                }
                monitor.subTask(CorePlugin.getString("msgJobServerAttach", new Object[0]));
                this.attach(workingCopy, mode, launch, monitor);
                behaviour.setLaunchMode(DEBUG_MODE);
            }
            finally {
                monitor.done();
            }
        }
        if (server.getServerState() == 2) {
            if (!debugging) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                return;
            }
            if (!this.isHotAttachAllowed(config)) {
                String msg = CorePlugin.getString("errorServerStartHotAttachDisabled", new Object[0]);
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
            try {
                try {
                    if (behaviour.getLaunchMode() == DEBUG_MODE) {
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                    } else {
                        monitor.beginTask(CorePlugin.getString("msgJobServerAttach", new Object[0]), 10000);
                        this.attach(workingCopy, mode, launch, monitor);
                        behaviour.setLaunchMode(DEBUG_MODE);
                    }
                }
                catch (CoreException ce) {
                    if (this.isRunWithDebug(config)) {
                        throw ce;
                    }
                    String msg = CorePlugin.getString("errorServerStartDebugPortNotOpened", new Object[0]);
                    throw new CoreException(CorePlugin.createErrorStatus(msg, ce));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void attachToRemoteServer(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = config.getWorkingCopy();
        WeblogicServerBehaviour behaviour = (WeblogicServerBehaviour)this.getServer(config).loadAdapter(WeblogicServerBehaviour.class, null);
        try {
            int debugPort = behaviour.getWeblogicServer().getDebugPort();
            this.setDebugPort(workingCopy, "" + debugPort);
            behaviour.attach(workingCopy, mode, launch, monitor);
            this.addServerListener(config, launch);
            IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
            if (adapter != null) {
                adapter.publishFinished(behaviour, true);
            }
        }
        catch (CoreException ce) {
            StringBuffer msg = new StringBuffer();
            msg.append(CorePlugin.getString("errorServerStartConnectionRefused", new Object[0]));
            Map connectMap = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, null);
            if (connectMap != null) {
                String hostName = "" + connectMap.get("hostname");
                String portNum = "" + connectMap.get("port");
                msg.append("\nPlease make sure the server " + hostName + " is running and listening " + "for transport dt_socket at address: " + portNum);
            }
            throw new CoreException(WlsCorePlugin.createErrorStatus(msg.toString(), (Exception)((Object)ce)));
        }
        catch (Exception e) {
            CorePlugin.getLevelLog().logInfo(CorePlugin.createWarnStatus("Failed to attach to Weblogic server", e));
            behaviour.stop(true);
            e.printStackTrace();
        }
    }

    private void launch(ILaunchConfigurationWorkingCopy config, ILaunch launch, String mode, IProgressMonitor monitor) throws CoreException {
        boolean startAsWlx;
        if (!CorePlugin.IS_WINDOWS && !CorePlugin.IS_UNIX) {
            String msg = CorePlugin.getString("errorWizardUnsupportedOS", Platform.getOS());
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        IWeblogicServer weblogic = (IWeblogicServer)this.getServer((ILaunchConfiguration)config).loadAdapter(IWeblogicServer.class, null);
        WeblogicServerBehaviour behaviour = (WeblogicServerBehaviour)this.getServer((ILaunchConfiguration)config).loadAdapter(WeblogicServerBehaviour.class, null);
        if (behaviour == null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            String msg = CorePlugin.getString("errorServerStartGeneral", new Object[0]);
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        ServerInfo info = weblogic.getServerInfo();
        String termName = "WebLogic Server - " + info.getConfigVersion() + " [" + info.getDomainName() + "]";
        String command = this.getStartScript((ILaunchConfiguration)config);
        if (command == null || command.length() == 0) {
            String msg = CorePlugin.getString("errorServerStartScriptNotSpecified", new Object[0]);
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        IServer server = this.getServer((ILaunchConfiguration)config);
        ServerWorkingCopy swc = (ServerWorkingCopy)server.createWorkingCopy();
        boolean startWithDebug = swc.getAttribute("start_with_debug", false);
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        String[] env = manager.getEnvironment((ILaunchConfiguration)config);
        if (DEBUG_MODE.equals(mode) || startWithDebug) {
            env = WeblogicServerLaunchConfigurationDelegate.setEnv(env, "debugFlag", "true");
            int debugPort = ((WeblogicServer)weblogic).getDebugPort();
            if (debugPort != 8453) {
                env = WeblogicServerLaunchConfigurationDelegate.setEnv(env, "DEBUG_PORT", "" + debugPort);
            }
            this.setDebugPort(config, "" + debugPort);
        } else {
            env = WeblogicServerLaunchConfigurationDelegate.setEnv(env, "debugFlag", "false");
            if (CorePlugin.IS_WINDOWS) {
                command = String.valueOf(command) + " nodebug ";
            }
        }
        String mwHome = WeblogicServerRuntime.getProperty(server.getRuntime(), "MW_HOME");
        if (mwHome != null) {
            env = WeblogicServerLaunchConfigurationDelegate.setEnv(env, "MW_HOME", mwHome);
        }
        if (CorePlugin.IS_MACOSX) {
            CorePlugin.getLevelLog().logDebug("Setting USER_MEM_ARGS=-Xms256m -Xmx512m -XX:MaxPermSize=256m to launch WebLogic server on Mac OS X");
            env = WeblogicServerLaunchConfigurationDelegate.setEnv(env, "USER_MEM_ARGS", "-Xms256m -Xmx512m -XX:MaxPermSize=256m");
            env = WeblogicServerLaunchConfigurationDelegate.setEnv(env, "JAVA_VENDOR", "Unknown");
        }
        if (startAsWlx = swc.getAttribute("start_as_wlx", false)) {
            StringBuffer msg = new StringBuffer();
            if (ServerLaunchUtils.hasEjbModules((Server)server)) {
                msg.append("WebLogic Server is configured to start in Express Mode but EJB modules are found on server.");
                throw new CoreException(CorePlugin.createErrorStatus(msg.toString()));
            }
            env = WeblogicServerLaunchConfigurationDelegate.setEnv(env, "JAVA_OPTIONS", "-DserverType=wlx");
        }
        boolean launchInConsole = swc.getAttribute("START_SERVER_IN_CONSOLE", true);
        String[] cmd = null;
        if (CorePlugin.IS_WINDOWS) {
            String pathWithArgs = String.valueOf(command) + " doExit";
            cmd = launchInConsole ? new String[]{"cmd.exe", "/C", pathWithArgs} : new String[]{"cmd.exe", "/C", "START", "\"" + termName + "\"", "/MIN", "cmd.exe", "/C", pathWithArgs};
        } else if (CorePlugin.IS_UNIX) {
            cmd = launchInConsole ? (DEBUG_MODE.equals(mode) || startWithDebug ? new String[]{"sh", command} : new String[]{"sh", command, "nodebug"}) : (DEBUG_MODE.equals(mode) || startWithDebug ? new String[]{"xterm", "-T", termName, "-e", "sh", command} : new String[]{"xterm", "-T", termName, "-e", "sh", command, "nodebug"});
        }
        try {
            behaviour.launch(cmd, env, config, launch, monitor);
        }
        catch (CoreException ce) {
            CorePlugin.getLevelLog().logDebug(ce.getStatus());
            monitor.done();
        }
    }

    public void attach(ILaunchConfigurationWorkingCopy config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server;
        this.setDebugArgument(config, "hostname", LOCAL_HOST);
        String port = this.getDebugPort((ILaunchConfiguration)config);
        if (port == null || port.length() == 0) {
            this.setDebugPort(config, "8453");
        }
        if ((server = this.getServer((ILaunchConfiguration)config)) == null) {
            return;
        }
        if (WebLogicServerUtil.isRequireFastSwapFix(server.getRuntime())) {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, ID_WEBLOGIC_SOCKET_ATTACH_CONNECTOR);
        }
        WeblogicServerBehaviour behaviour = (WeblogicServerBehaviour)server.loadAdapter(WeblogicServerBehaviour.class, null);
        behaviour.attach(config, mode, launch, monitor);
        this.addServerListener((ILaunchConfiguration)config, launch);
        this.installWeblogicBreakpoints(launch);
    }

    private void installWeblogicBreakpoints(ILaunch launch) {
        IDebugTarget debugTarget = launch.getDebugTarget();
        if (debugTarget != null) {
            IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] bps = manager.getBreakpoints("oracle.eclipse.tools.weblogic.debugger");
            int i = 0;
            while (i < bps.length) {
                if (bps[i] instanceof IJavaBreakpoint) {
                    debugTarget.breakpointAdded(bps[i]);
                }
                ++i;
            }
        }
    }

    private void addServerListener(final ILaunchConfiguration config, final ILaunch launch) {
        final IServer server = this.getServer(config);
        server.addServerListener(new IServerListener(){

            public void serverChanged(ServerEvent event) {
                if ((event.getKind() & 0x20) > 0) {
                    try {
                        ISourceLocator locator = launch.getSourceLocator();
                        if (locator instanceof JavaSourceLookupDirector) {
                            ((JavaSourceLookupDirector)locator).initializeDefaults(config);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                if ((event.getKind() & 0x10) > 0 && server.getServerState() == 4) {
                    server.removeServerListener((IServerListener)this);
                }
            }
        });
    }

    private static String[] setEnv(String[] env, String key, String value) {
        if (env == null) {
            env = new String[]{};
        }
        int i = 0;
        int len = env.length;
        while (i < len) {
            if (env[i].startsWith(String.valueOf(key) + "=")) {
                env[i] = String.valueOf(key) + "=" + value;
                return env;
            }
            ++i;
        }
        String[] result = new String[env.length + 1];
        System.arraycopy(env, 0, result, 0, env.length);
        result[result.length - 1] = String.valueOf(key) + "=" + value;
        return result;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException(CorePlugin.createErrorStatus(message, exception, code));
    }

    @Override
    public IServer getServer(ILaunchConfiguration config) {
        try {
            String serverId = config.getAttribute("server-id", "");
            if (serverId != null && serverId.length() != 0) {
                return ServerCore.findServer((String)serverId);
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        try {
            if (config.getAttribute(ATTR_WEBLOGIC_INIT_FLAG, false)) {
                return;
            }
            IServer[] servers = this.getSupportedServers((ILaunchConfiguration)config);
            if (servers != null && servers.length > 0) {
                this.setServer(config, servers[0]);
            } else {
                this.setServer(config, null);
            }
            this.setDebugPort(config, "8453");
            this.setDebugArgument(config, "hostname", LOCAL_HOST);
            this.setRunWithDebug(config, true);
            this.setHotAttachAllowed(config, true);
            this.setStartScript(config, "startWebLogic." + CorePlugin.getScriptExtension());
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
            config.setAttribute(ATTR_WEBLOGIC_INIT_FLAG, true);
        }
        catch (CoreException ce) {
            CorePlugin.getLevelLog().log(ce.getStatus());
        }
    }

    @Override
    public String getDebugPort(ILaunchConfiguration config) {
        return this.getDebugArgument(config, "port");
    }

    private String getDebugArgument(ILaunchConfiguration config, String key) {
        Map args;
        block5: {
            block4: {
                try {
                    args = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, null);
                    if (args != null && args.size() != 0) break block4;
                    return "";
                }
                catch (CoreException ce) {
                    CorePlugin.getLevelLog().log(ce.getStatus());
                    return "";
                }
            }
            if (args.containsKey(key)) break block5;
            return "";
        }
        return args.get(key).toString();
    }

    @Override
    public String getStartScript(ILaunchConfiguration config) {
        try {
            return config.getAttribute("attr-start-script", null);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public void setStartScript(ILaunchConfigurationWorkingCopy config, String start) {
        config.setAttribute("attr-start-script", start);
    }

    @Override
    public boolean isHotAttachAllowed(ILaunchConfiguration config) {
        try {
            return config.getAttribute("attr-allow-hot-attach", false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @Override
    public boolean isRunWithDebug(ILaunchConfiguration config) {
        Map map;
        block3: {
            try {
                map = config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                if (map != null) break block3;
                return false;
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        String value = (String)map.get("debugFlag");
        return value != null && value.equals("true");
    }

    @Override
    public void setServer(ILaunchConfigurationWorkingCopy config, IServer server) {
        if (server != null) {
            config.setAttribute("server-id", server.getId());
        } else {
            config.setAttribute("server-id", null);
        }
    }

    @Override
    public void setDebugPort(ILaunchConfigurationWorkingCopy config, String port) {
        this.setDebugArgument(config, "port", port);
    }

    private void setDebugArgument(ILaunchConfigurationWorkingCopy config, String key, String arg) {
        try {
            HashMap<String, String> args = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, null);
            args = args != null ? new HashMap(args) : new HashMap<String, String>();
            args.put(key, String.valueOf(arg));
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, args);
        }
        catch (CoreException ce) {
            CorePlugin.getLevelLog().log(ce.getStatus());
        }
    }

    @Override
    public void setHotAttachAllowed(ILaunchConfigurationWorkingCopy config, boolean allow) {
        config.setAttribute("attr-allow-hot-attach", allow);
    }

    @Override
    public void setRunWithDebug(ILaunchConfigurationWorkingCopy config, boolean debug) {
        try {
            HashMap<String, String> map = config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            if (debug) {
                if (!"true".equals((map = map == null ? new HashMap<String, String>() : new HashMap(map)).put("debugFlag", "true"))) {
                    config.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, map);
                }
            } else {
                if (map == null) {
                    return;
                }
                if (!map.containsKey("debugFlag")) {
                    return;
                }
                map = new HashMap(map);
                map.remove("debugFlag");
                config.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, map);
            }
        }
        catch (CoreException ce) {
            CorePlugin.getLevelLog().log(ce.getStatus());
        }
    }

    @Override
    public IStatus validateStartable(ILaunchConfiguration config) {
        IStatus status = this.validateConfiguration(config);
        if (!status.isOK()) {
            return status;
        }
        try {
            String serverId = config.getAttribute("server-id", null);
            if (serverId == null || serverId.length() == 0) {
                String msg = CorePlugin.getString("errorServerNotSet", new Object[0]);
                return CorePlugin.createErrorStatus(msg);
            }
            IServer server = ServerCore.findServer((String)serverId);
            if (server == null) {
                String msg = CorePlugin.getString("errorServerInvalid", new Object[0]);
                return CorePlugin.createErrorStatus(msg);
            }
            boolean restart = config.getAttribute(ATTR_SEMI_RESTART, false);
            if (!restart && server.getServerState() != 4 && server.getServerState() != 0) {
                String msg = CorePlugin.getString("errorServerAlreadyStarted", new Object[0]);
                return CorePlugin.createErrorStatus(msg);
            }
            return CorePlugin.STATUS_OK;
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
    }

    public IStatus validateConfiguration(ILaunchConfiguration config) {
        try {
            String serverId = config.getAttribute("server-id", null);
            if (serverId == null || serverId.length() == 0) {
                String msg = CorePlugin.getString("errorServerNotSet", new Object[0]);
                return CorePlugin.createErrorStatus(msg);
            }
            IServer server = ServerCore.findServer((String)serverId);
            if (server == null) {
                String msg = CorePlugin.getString("errorServerInvalid", new Object[0]);
                return CorePlugin.createErrorStatus(msg);
            }
            IWeblogicServer weblogic = (IWeblogicServer)server.loadAdapter(IWeblogicServer.class, null);
            IStatus weblogicStatus = weblogic.validate();
            if (!weblogicStatus.isOK()) {
                return weblogicStatus;
            }
            if (!weblogic.isRemote()) {
                String scriptString = this.getStartScript(config);
                if (scriptString == null || scriptString.trim().length() == 0) {
                    String msg = CorePlugin.getString("errorServerStartScriptNotSpecified", new Object[0]);
                    return CorePlugin.createErrorStatus(msg);
                }
                File domain = new File(weblogic.getDomainPath().toOSString());
                File script = new File(domain, scriptString);
                if (!script.exists()) {
                    String msg = CorePlugin.getString("errorServerStartScriptMissing", new Object[0]);
                    return CorePlugin.createErrorStatus(msg);
                }
            }
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        return CorePlugin.STATUS_OK;
    }

    @Override
    public IServer[] getSupportedServers(ILaunchConfiguration config) {
        ArrayList<IServer> list = new ArrayList<IServer>();
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (server.getServerType() != null && this.isSupportedServer(server.getServerType().getId())) {
                list.add(server);
            }
            ++n2;
        }
        if (list.size() <= 0) {
            return EMPTY_SERVERS;
        }
        return list.toArray(new IServer[list.size()]);
    }

    protected boolean isSupportedServer(String id) {
        if (WeblogicServerLaunchConfigurationDelegate.matches("com.bea.wlw.server", id)) {
            return true;
        }
        return WeblogicServerLaunchConfigurationDelegate.matches("com.bea.weblogic", id);
    }

    protected static boolean matches(String a, String b) {
        return a == null || b == null || "*".equals(a) || "*".equals(b) || a.startsWith(b) || b.startsWith(a);
    }
}

