/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public class WeblogicJspSourceContainer
extends AbstractSourceContainer {
    private static final String PREFIX_SERVLET = "jsp_servlet";
    private static final String EXT_JSP = ".jsp";
    private IVirtualComponent component;

    public WeblogicJspSourceContainer(IVirtualComponent component) {
        this.component = component;
    }

    public Object[] findSourceElements(String name) throws CoreException {
        if (name.indexOf(EXT_JSP) < 0) {
            return EMPTY;
        }
        Path sourcePath = new Path(name);
        Path resultPath = Path.EMPTY;
        int i = 1;
        int len = sourcePath.segmentCount();
        while (i < len) {
            String seg = sourcePath.segment(i);
            resultPath = seg.startsWith("_") ? resultPath.append(seg.substring(1)) : resultPath.append(seg);
            ++i;
        }
        IVirtualFolder root = this.component.getRootFolder();
        IVirtualResource res = root.findMember((IPath)resultPath);
        if (res != null) {
            return res.getUnderlyingResources();
        }
        IResource member = this.findMemberIgnoreCases(root.getUnderlyingResource(), (IPath)resultPath);
        if (member != null) {
            return new Object[]{member};
        }
        return EMPTY;
    }

    private IResource findMemberIgnoreCases(IResource res, IPath path) throws CoreException {
        if (!res.exists()) {
            return null;
        }
        if (path.isEmpty()) {
            return res;
        }
        if (!(res instanceof IFolder)) {
            return null;
        }
        String seg = path.segment(0);
        IResource[] iResourceArray = ((IFolder)res).members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member.getName().toLowerCase().equals(seg.toLowerCase())) {
                return this.findMemberIgnoreCases(member, path.removeFirstSegments(1));
            }
            ++n2;
        }
        return null;
    }

    public String getName() {
        return this.component.getName();
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType("com.bea.wlw.server.jspContainerType");
    }
}

