/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerDeployment;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicStandaloneWARModule;
import oracle.eclipse.tools.weblogic.server.internal.util.ModuleUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.PublishUtil;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;

public final class WebProjectContentUpdater {
    private final WeblogicServerBehaviour _serverBehaviour;

    public WebProjectContentUpdater(WeblogicServerBehaviour serverBehaviour) {
        this._serverBehaviour = serverBehaviour;
    }

    private WeblogicServer getWeblogicServer(IServer server) {
        return (WeblogicServer)server.loadAdapter(WeblogicServer.class, null);
    }

    public boolean processModuleChange(final IModule[] modules) {
        WeblogicServer _weblogicServer = this.getWeblogicServer(this._serverBehaviour.getServer());
        WeblogicStandaloneWARModule webModule = null;
        if (modules.length == 1 && ModuleUtil.isWebModule(modules[0])) {
            String deployName = _weblogicServer.getModuleRootPath(modules[0]).substring(0);
            IPath deployRoot = this._serverBehaviour.getDeploymentPath(modules[0]);
            webModule = new WeblogicStandaloneWARModule(deployRoot, modules[0], deployName);
        } else if (ModuleUtil.isWebModule(modules[modules.length - 1])) {
            try {
                IModule childModule = modules[modules.length - 1];
                IEnterpriseApplication earApp = (IEnterpriseApplication)modules[0].loadAdapter(IEnterpriseApplication.class, (IProgressMonitor)new NullProgressMonitor());
                String uri = earApp.getURI(childModule);
                IPath deployPath = this.getEarDeploymentPath(modules[0]).append(uri);
                String deployName = uri;
                webModule = new WeblogicStandaloneWARModule(deployPath, childModule, deployName);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        IModuleResourceDelta[] deltas = this._serverBehaviour.getUnfilteredResourceDelta(modules);
        if (deltas == null || deltas.length == 0) {
            return true;
        }
        boolean onlyStaticChanges = this.processResourceDeltas(webModule, deltas);
        if (onlyStaticChanges) {
            Job job = new Job(""){

                protected IStatus run(IProgressMonitor arg0) {
                    Server server = (Server)WebProjectContentUpdater.this._serverBehaviour.getServer();
                    server.setModulePublishState(modules, 1);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return onlyStaticChanges;
    }

    protected IPath getEarDeploymentPath(IModule module) throws CoreException {
        IWeblogicServerDeployment wsDeployment = (IWeblogicServerDeployment)this._serverBehaviour.getServer().loadAdapter(IWeblogicServerDeployment.class, null);
        if (wsDeployment == null) {
            String msg = CorePlugin.getString("errorPublishTaskDelegate", new Object[0]);
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        return wsDeployment.getDeploymentPath(module);
    }

    private boolean processResourceDeltas(WeblogicStandaloneWARModule webModule, IModuleResourceDelta[] deltas) {
        if (deltas == null) {
            return true;
        }
        boolean onlyStaticChanges = true;
        IModuleResourceDelta[] iModuleResourceDeltaArray = deltas;
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleResourceDelta delta = iModuleResourceDeltaArray[n2];
            IModuleResource resource = delta.getModuleResource();
            if (resource instanceof IModuleFolder) {
                if (!this.processResourceDeltas(webModule, delta.getAffectedChildren())) {
                    onlyStaticChanges = false;
                }
            } else if (resource instanceof IModuleFile) {
                int kind = delta.getKind();
                if (kind == 2 || kind == 1) {
                    String[] autoDeployPatterns = this._serverBehaviour.getAutoDeployPatterns();
                    if (autoDeployPatterns.length == 0) {
                        return true;
                    }
                    if (WeblogicServerBehaviour.matchesPattern(resource.getName(), autoDeployPatterns)) {
                        PublishUtil.publishFull((IModuleResource[])new IModuleResource[]{resource}, (IPath)webModule.getDeploymentPath(), (IProgressMonitor)new NullProgressMonitor());
                    } else {
                        onlyStaticChanges = false;
                        System.out.println("Resource changed: " + resource.getName());
                    }
                } else if (kind == 3) {
                    onlyStaticChanges = false;
                }
            } else {
                onlyStaticChanges = false;
            }
            ++n2;
        }
        return onlyStaticChanges;
    }
}

