/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import oracle.eclipse.tools.common.util.logging.LoggingService;

public final class UrlPathEncoder {
    private URL _url = null;

    public UrlPathEncoder(URL theUrl) throws MalformedURLException {
        this(theUrl.toString());
    }

    public UrlPathEncoder(String urlString) throws MalformedURLException {
        try {
            String urlStringDecoded = URLDecoder.decode(urlString, "UTF-8");
            URL tmpUrl = new URL(urlStringDecoded);
            String query = tmpUrl.getQuery();
            StringBuilder path = new StringBuilder();
            path.append(URLEncoder.encode(tmpUrl.getPath(), "UTF-8").replaceAll("%2[fF]", "/"));
            if (query != null) {
                path.append("?").append(URLEncoder.encode(query, "UTF-8"));
            }
            this._url = new URL(tmpUrl.getProtocol(), tmpUrl.getHost(), tmpUrl.getPort(), path.toString());
        }
        catch (UnsupportedEncodingException uee) {
            LoggingService.logFatal((String)"oracle.eclipse.tools.weblogic", (Throwable)uee, (String)("Internal Error parsing URL: " + urlString));
        }
    }

    public String asString() {
        return this._url.toString();
    }

    public URL asURL() {
        return this._url;
    }
}

