/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.File;
import java.io.IOException;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicDomainUpgrade;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IRuntime;

public class UpgradeDomainConfigurator
implements IWeblogicDomainUpgrade {
    private static final String SEPARATOR = System.getProperties().getProperty("file.separator", "/");
    private static final String BIN_PATH = "common" + SEPARATOR + "bin";
    private static final String BIN_COMMAND = "upgrade";
    private IRuntime runtime;
    private IWeblogicServerRuntime weblogic;
    private IPath domainPath = Path.EMPTY;

    @Override
    public void setDomainPath(IPath domainPath) {
        domainPath.hashCode();
        this.domainPath = domainPath;
    }

    @Override
    public IPath getDomainPath() {
        return this.domainPath;
    }

    public void initialize(IRuntime runtime, IProgressMonitor monitor) {
        runtime.hashCode();
        this.runtime = runtime;
        this.weblogic = (IWeblogicServerRuntime)runtime.loadAdapter(IWeblogicServerRuntime.class, monitor);
        this.weblogic.hashCode();
    }

    @Override
    public void apply(IProgressMonitor monitor) throws CoreException {
        try {
            try {
                monitor.beginTask(CorePlugin.getString("msgWizardUpgradeDomain", new Object[0]), 100);
                monitor.beginTask("Upgrading a new domain... ", 100);
                monitor.subTask(CorePlugin.getString("msgWizardExecScript", new Object[0]));
                this.execute(monitor);
                monitor.worked(85);
                monitor.done();
            }
            catch (RuntimeException re) {
                re.hashCode();
                re.printStackTrace();
                throw new CoreException(CorePlugin.createErrorStatus("Exception!", re));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void execute(IProgressMonitor monitor) throws CoreException {
        String[] cmd = null;
        String wlHome = this.runtime.getLocation().toOSString();
        String termName = CorePlugin.getString("msgTerminalUpgradeDomain", new Object[0]);
        String ext = CorePlugin.getScriptExtension();
        String dir = String.valueOf(wlHome) + SEPARATOR + BIN_PATH;
        String command = String.valueOf(dir) + SEPARATOR + BIN_COMMAND + "." + ext;
        if (CorePlugin.IS_WINDOWS) {
            cmd = new String[]{"cmd.exe", "/C", "START", "\"" + termName + "\"", "/MIN", "/WAIT", "cmd.exe", "/C", "\"" + command + "\""};
        } else if (CorePlugin.IS_UNIX) {
            cmd = new String[]{"xterm", "-T", termName, "-e", "sh", command};
        } else {
            String msg = CorePlugin.getString("errorWizardUnsupportedOS", Platform.getOS());
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        try {
            File execDir = this.domainPath.isEmpty() ? new File(String.valueOf(wlHome) + SEPARATOR + BIN_PATH) : this.domainPath.toFile();
            final Process proc = Runtime.getRuntime().exec(cmd, null, execDir);
            final boolean[] upgradeRuning = new boolean[]{true};
            Thread upgradeThread = new Thread(){

                @Override
                public void run() {
                    try {
                        proc.waitFor();
                    }
                    catch (InterruptedException interruptedException) {}
                    upgradeRuning[0] = false;
                }
            };
            upgradeThread.start();
            while (upgradeRuning[0]) {
                Thread.sleep(1000L);
                monitor.worked(1);
            }
        }
        catch (IOException ioe) {
            throw new CoreException(CorePlugin.createErrorStatus("Exception!", ioe));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

