/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.File;
import java.util.List;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.weblogic.descriptors.IJspDescriptorSection;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicWebModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicPublishTask;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicDeployableModule;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import oracle.eclipse.tools.weblogic.server.model.WeblogicPublishOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.PublishTaskDelegate;

public class UpdateWebAppDescriptorPublishTask
extends PublishTaskDelegate {
    private static final PublishOperation[] EMPTY_OP_TASK = new PublishOperation[0];
    public static final String FILENAME_WEBLOGICXML = "weblogic.xml";
    public static final String FILENAME_META_INF = "META-INF";
    public static final String FILENAME_WEB_INF = "WEB-INF";

    public PublishOperation[] getTasks(IServer server, List modules) {
        IWeblogicServer ws = (IWeblogicServer)server.loadAdapter(IWeblogicServer.class, null);
        if (ws == null) {
            return EMPTY_OP_TASK;
        }
        if (ws.isRemote()) {
            return EMPTY_OP_TASK;
        }
        if (modules == null || modules.isEmpty()) {
            return EMPTY_OP_TASK;
        }
        return new PublishOperation[]{new UpdateWeblogicXmlOperation(server)};
    }

    private static class UpdateWeblogicXmlOperation
    extends WeblogicPublishOperation {
        public UpdateWeblogicXmlOperation(IServer server) {
            super("Update WeblogicXml", "Update weblogic.xml for debugging", server);
        }

        public int getOrder() {
            return 101;
        }

        @Override
        protected void processRootModule(IWeblogicModule mod, IProgressMonitor monitor) throws CoreException {
            if (mod.getKind() == 3) {
                return;
            }
            IModule module = mod.getModule();
            if (module instanceof DeletedModule) {
                return;
            }
            if (FacetUtil.hasWebFacet(module)) {
                this.updateStandAloneWebApp(mod, monitor);
            }
            if (FacetUtil.hasEarFacet(module)) {
                IFacetedProject facetProject = ProjectFacetsManager.create((IProject)module.getProject());
                IProject project = facetProject.getProject();
                IVirtualComponent earComp = ComponentCore.createComponent((IProject)project);
                IVirtualReference[] refs = earComp.getReferences();
                int i = 0;
                while (i < refs.length) {
                    IVirtualComponent c = refs[i].getReferencedComponent();
                    IProject p = c.getProject();
                    String projectType = JavaEEProjectUtilities.getJ2EEProjectType((IProject)p);
                    if ("jst.web".equals(projectType)) {
                        this.updateJspDescriptor(p, monitor);
                    }
                    ++i;
                }
            }
        }

        private void updateStandAloneWebApp(IWeblogicModule mod, IProgressMonitor monitor) throws CoreException {
            IModule module = mod.getModule();
            IProject project = module.getProject();
            WeblogicServerBehaviour behavior = (WeblogicServerBehaviour)this._server.loadAdapter(WeblogicServerBehaviour.class, monitor);
            if (behavior != null && behavior.isDeployInSplitSrcMode()) {
                this.updateJspDescriptor(module.getProject(), monitor);
            } else {
                IFacetedProject facetProject = ProjectFacetsManager.create((IProject)project);
                IPath deployPath = ((IWeblogicDeployableModule)mod).getDeploymentPath();
                File weboutputFolder = deployPath.toFile();
                File weblogicXmlCopy = new File(new File(weboutputFolder, UpdateWebAppDescriptorPublishTask.FILENAME_WEB_INF), UpdateWebAppDescriptorPublishTask.FILENAME_WEBLOGICXML);
                if (weblogicXmlCopy.exists()) {
                    IWebLogicWebModuleDescriptor desc = WebLogicDescriptorFactory.getWebDescriptor(weblogicXmlCopy);
                    this.updateWeblogicWebAppDescriptor(desc, facetProject, monitor);
                    desc.dispose();
                } else {
                    IWebLogicWebModuleDescriptor desc = WebLogicDescriptorFactory.getWebDescriptor(weblogicXmlCopy);
                    this.updateWeblogicWebAppDescriptor(desc, facetProject, monitor);
                    desc.setServerVersion("9.2");
                    try {
                        desc.resource().save();
                    }
                    catch (ResourceStoreException e) {
                        e.printStackTrace();
                    }
                    desc.dispose();
                }
            }
        }

        private void updateJspDescriptor(IProject project, IProgressMonitor monitor) throws CoreException {
            IFacetedProject facetProject = ProjectFacetsManager.create((IProject)project);
            Path genWebRoot = new Path(WeblogicPublishTask.getGeneratedWebRoot(project));
            File weboutputFolder = new File(genWebRoot.toOSString());
            File weblogicXmlCopy = new File(new File(weboutputFolder, UpdateWebAppDescriptorPublishTask.FILENAME_WEB_INF), UpdateWebAppDescriptorPublishTask.FILENAME_WEBLOGICXML);
            IVirtualComponent webComp = ComponentCore.createComponent((IProject)project);
            IContainer fodler = webComp.getRootFolder().getUnderlyingFolder();
            IFolder f = fodler.getFolder((IPath)new Path(UpdateWebAppDescriptorPublishTask.FILENAME_WEB_INF));
            IFile webXml = f.getFile(UpdateWebAppDescriptorPublishTask.FILENAME_WEBLOGICXML);
            File wlsXml = webXml.getLocation().toFile();
            if (weblogicXmlCopy.exists() && weblogicXmlCopy.lastModified() < wlsXml.lastModified()) {
                weblogicXmlCopy.delete();
            }
            try {
                if (wlsXml.exists()) {
                    if (!weblogicXmlCopy.exists()) {
                        FileUtil.copy((File)wlsXml, (File)weblogicXmlCopy);
                        IFile ifile = EclipseFileUtil.getWorkspaceFile((File)weblogicXmlCopy);
                        if (ifile != null) {
                            ifile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    IWebLogicWebModuleDescriptor desc = WebLogicDescriptorFactory.getWebDescriptor(weblogicXmlCopy);
                    this.updateWeblogicWebAppDescriptor(desc, facetProject, monitor);
                    desc.dispose();
                } else {
                    IWebLogicWebModuleDescriptor desc = WebLogicDescriptorFactory.getWebDescriptor(weblogicXmlCopy);
                    this.updateWeblogicWebAppDescriptor(desc, facetProject, monitor);
                    desc.setServerVersion("9.2");
                    desc.resource().save();
                    desc.dispose();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void updateWeblogicWebAppDescriptor(IWebLogicWebModuleDescriptor desc, IFacetedProject facetProject, IProgressMonitor monitor) throws CoreException {
            if (desc != null) {
                try {
                    String projContextRoot;
                    boolean needUpdate = false;
                    IJspDescriptorSection jspDesc = desc.getJspDescriptorSection();
                    if (!((Boolean)jspDesc.isGenerateAllDebuggingInformation().content()).booleanValue()) {
                        jspDesc.setGenerateAllDebuggingInformation(true);
                        needUpdate = true;
                    }
                    if (!((Boolean)jspDesc.isKeepGenerated().content()).booleanValue()) {
                        needUpdate = true;
                        jspDesc.setKeepGenerated(true);
                    }
                    IPath path = ((Server)this._server).getTempDirectory();
                    WeblogicServerBehaviour weblogicServer = (WeblogicServerBehaviour)this._server.loadAdapter(WeblogicServerBehaviour.class, monitor);
                    ServerInfo serverInfo = weblogicServer.getServerInfo();
                    IPath dirPath = path.append(serverInfo.getDomainName()).append("work").append(facetProject.getProject().getName());
                    File workingDir = dirPath.toFile();
                    if (jspDesc.getWorkingDir() == null || !workingDir.getAbsolutePath().equals(jspDesc.getWorkingDir().text())) {
                        needUpdate = true;
                        jspDesc.setWorkingDir(workingDir.getAbsolutePath());
                    }
                    if ((projContextRoot = J2EEProjectUtilities.getServerContextRoot((IProject)facetProject.getProject())) == null) {
                        projContextRoot = "";
                    }
                    if (projContextRoot.length() > 1 && projContextRoot.charAt(0) == '/') {
                        projContextRoot = projContextRoot.substring(1);
                    }
                    if (!projContextRoot.equals(desc.getContextRoot().content())) {
                        needUpdate = true;
                        desc.setContextRoot(projContextRoot);
                    }
                    if (needUpdate) {
                        desc.resource().save();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

