/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import oracle.eclipse.tools.common.util.system.ExecHelper;
import oracle.eclipse.tools.common.util.system.RuntimeResponse;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicDomainUpgrade;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.internal.ServerConfiguration;
import oracle.eclipse.tools.weblogic.server.internal.util.FileUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IRuntime;

public class SilentUpgradeDomainConfigurator
implements IWeblogicDomainUpgrade {
    private static final String SEPARATOR = System.getProperties().getProperty("file.separator", "/");
    private static final String BIN_PATH = "common" + SEPARATOR + "bin";
    private static final String BIN_COMMAND = "upgrade";
    private static final String LOG_FILENAME = "upgrade_domain.log";
    private static final String RESPONSE_FILENAME = "response";
    private static final String RESPONSE_EXT = "xml";
    private static final String FILENAME_RESPONSES_XML = "oracle/eclipse/tools/weblogic/server/internal/responses.xml";
    private IRuntime runtime;
    private IWeblogicServerRuntime weblogic;
    private IPath domainPath = Path.EMPTY;

    public void initialize(IRuntime runtime, IProgressMonitor monitor) {
        runtime.hashCode();
        this.runtime = runtime;
        this.weblogic = (IWeblogicServerRuntime)runtime.loadAdapter(IWeblogicServerRuntime.class, monitor);
        this.weblogic.hashCode();
        this.domainPath = Path.EMPTY;
    }

    @Override
    public void setDomainPath(IPath domainPath) {
        domainPath.hashCode();
        this.domainPath = domainPath;
    }

    @Override
    public IPath getDomainPath() {
        return this.domainPath;
    }

    @Override
    public void apply(IProgressMonitor monitor) throws CoreException {
        try {
            try {
                monitor.beginTask(CorePlugin.getString("msgWizardUpgradeDomain", new Object[0]), 100);
                monitor.subTask(CorePlugin.getString("msgWizardGenScript", new Object[0]));
                File response = this.configResponseFile(monitor);
                monitor.worked(20);
                monitor.subTask(CorePlugin.getString("msgWizardExecScript", new Object[0]));
                this.execute(monitor, response);
                monitor.worked(85);
                monitor.done();
            }
            catch (RuntimeException re) {
                re.hashCode();
                re.printStackTrace();
                throw new CoreException(CorePlugin.createErrorStatus("Exception!", re));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void execute(IProgressMonitor monitor, File response) throws CoreException {
        String[] cmd = null;
        String domainRoot = this.domainPath.toOSString();
        String responsePath = response.getAbsolutePath();
        String logPath = String.valueOf(domainRoot) + SEPARATOR + LOG_FILENAME;
        String wlHome = this.runtime.getLocation().toOSString();
        String termName = CorePlugin.getString("msgTerminalUpgradeDomain", new Object[0]);
        String ext = CorePlugin.getScriptExtension();
        String command = String.valueOf(wlHome) + SEPARATOR + BIN_PATH + SEPARATOR + BIN_COMMAND + "." + ext;
        if (CorePlugin.IS_WINDOWS) {
            cmd = new String[]{"cmd.exe", "/C", "START", "\"" + termName + "\"", "/MIN", "/WAIT", "cmd.exe", "/C", "\"" + command + "\"", "-mode=silent", "-type=domain", "-responses=" + responsePath, "-log=" + logPath};
        } else if (CorePlugin.IS_UNIX) {
            cmd = new String[]{"xterm", "-T", termName, "-e", "sh", command, "-mode=silent", "-type=domain", "-responses=" + responsePath, "-log=" + logPath};
        } else {
            String msg = CorePlugin.getString("errorWizardUnsupportedOS", Platform.getOS());
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        try {
            File execDir = new File(domainRoot);
            Thread.yield();
            RuntimeResponse res = ExecHelper.async((String[])cmd, (File)execDir, (String)"Domain upgrade configurator");
            boolean done = res.isDone();
            while (!done) {
                try {
                    res.join();
                    done = res.isDone();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException ioe) {
            throw new CoreException(CorePlugin.createErrorStatus("Exception!", ioe));
        }
    }

    private static File getUniqueFile(File dir, String name, String ext) throws CoreException {
        File file = null;
        int i = 0;
        while (i < 1000) {
            String filePath = String.valueOf(name) + i + "." + ext;
            file = new File(dir, filePath);
            if (!file.exists()) {
                return file;
            }
            ++i;
        }
        String msg = CorePlugin.getString("errorFileCreation", String.valueOf(name) + "x." + ext);
        throw new CoreException(CorePlugin.createErrorStatus(msg));
    }

    private static StringBuffer read(InputStream is) throws IOException {
        int count;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        StringBuffer buffer = new StringBuffer();
        char[] buf = new char[1024];
        while ((count = reader.read(buf)) > 0) {
            buffer.append(buf, 0, count);
        }
        return buffer;
    }

    private static void replace(StringBuffer buffer, String token, String value) {
        int start = buffer.indexOf(token);
        int end = token.length() + start;
        buffer.replace(start, end, value);
    }

    private File configResponseFile(IProgressMonitor monitor) throws CoreException {
        File file;
        InputStream is = null;
        PrintStream ps = null;
        try {
            ServerConfiguration config = new ServerConfiguration(this.domainPath);
            if (config.isDiablo()) {
                String msg = CorePlugin.getString("errorServerConfigUnknownVersion", new Object[0]);
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
            ServerInfo info = config.getServerInfo();
            File backup = SilentUpgradeDomainConfigurator.getUniqueFile(this.domainPath.toFile(), "weblogic-domain-backup-", "zip");
            ClassLoader cl = SilentUpgradeDomainConfigurator.class.getClassLoader();
            is = cl.getResourceAsStream(FILENAME_RESPONSES_XML);
            StringBuffer buffer = SilentUpgradeDomainConfigurator.read(is);
            SilentUpgradeDomainConfigurator.replace(buffer, "__WEBLOGIC_VERSION__", "8.1");
            SilentUpgradeDomainConfigurator.replace(buffer, "__ADMIN_SERVER_NAME__", info.getServerName());
            SilentUpgradeDomainConfigurator.replace(buffer, "__DOMAIN_DIR__", this.domainPath.toOSString());
            SilentUpgradeDomainConfigurator.replace(buffer, "__BACKUP_DIR__", this.domainPath.toOSString());
            SilentUpgradeDomainConfigurator.replace(buffer, "___BACKUP_FILE_NAME__", backup.getName());
            File responseFile = SilentUpgradeDomainConfigurator.getUniqueFile(this.domainPath.toFile(), RESPONSE_FILENAME, RESPONSE_EXT);
            ps = new PrintStream(responseFile, "UTF-8");
            ps.print(buffer.toString());
            file = responseFile;
        }
        catch (IOException iOException) {
            try {
                String msg = CorePlugin.getString("errorFileCreation", this.domainPath.toOSString());
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
            catch (Throwable throwable) {
                FileUtil.close(is);
                FileUtil.close(ps);
                throw throwable;
            }
        }
        FileUtil.close(is);
        FileUtil.close(ps);
        return file;
    }
}

