/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.internal.IServerStateListener;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.wst.server.core.internal.Server;

class ServerWatcher
implements Runnable,
IDebugEventSetListener {
    public static final int SERVER_STATE_UNKNOWN = 0;
    public static final int SERVER_STATE_INVALID = 1;
    public static final int SERVER_STATE_STOPPED = 2;
    public static final int SERVER_STATE_DRIVER_ERR = 3;
    public static final int SERVER_STATE_AUTH_ERR = 4;
    public static final int SERVER_STATE_NOT_CONNECTED = 5;
    public static final int SERVER_STATE_MATCHED = 6;
    public static final int SERVER_STATE_MISMATCHED = 7;
    public static final int SERVER_STATE_STARTING = 8;
    public static final int SERVER_STATE_STOPPING = 9;
    private static final int DELAY = 5000;
    private static final int PROCESS_DELAY = 150000;
    private static final IStatus STATUS_WATCHER_STOPPED = CorePlugin.createErrorStatus(CorePlugin.getString("errorServerWatcherStopped", new Object[0]));
    private ILaunch _launch;
    private int _updateCount;
    private int _state;
    private boolean _debugging;
    private Thread _thread;
    private long _nextPoll;
    private final List _listeners;
    private WeblogicServerBehaviour _behaviour;
    private boolean _serviceStarted;
    private IStatus _status;
    private boolean _starting;
    private boolean _stopping;

    public ServerWatcher(WeblogicServerBehaviour behaviour) {
        this._behaviour = behaviour;
        this._listeners = new ArrayList();
    }

    public synchronized void startWatcher() {
        String name;
        if (this._thread != null) {
            return;
        }
        ServerInfo info = this._behaviour.getServerInfo();
        this._thread = new Thread(this);
        String domainName = "";
        if (info != null && info.getDomainName() != null) {
            domainName = info.getDomainName();
        }
        String string = name = info != null ? String.valueOf(domainName) + "@" + info.getHostName() + ":" + info.getPortNumber() + ", Version:" + info.getConfigVersion() : "unknown";
        if (this._behaviour.getWeblogicServer().isRemote()) {
            name = "Remote WebLogic " + name;
        }
        this._thread.setName("WebLogic Server Monitor [" + name + "]");
        this._thread.setDaemon(true);
        this._thread.start();
        this._serviceStarted = true;
        CorePlugin.getLevelLog().logInfo("Started " + this._thread.getName());
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        this.updateState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatcher() {
        Thread thread = null;
        ServerWatcher serverWatcher = this;
        synchronized (serverWatcher) {
            if (this._thread == null) {
                return;
            }
            this._status = STATUS_WATCHER_STOPPED;
            this._serviceStarted = false;
            thread = this._thread;
            CorePlugin.getLevelLog().logInfo("Stopped " + this._thread.getName());
            this._thread = null;
            thread.interrupt();
        }
        try {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                this._status = STATUS_WATCHER_STOPPED;
            }
        }
        finally {
            this._status = STATUS_WATCHER_STOPPED;
        }
    }

    public synchronized boolean isWatcherStopped() {
        if (!this._serviceStarted) {
            return true;
        }
        return this._serviceStarted && this._thread == null;
    }

    public synchronized boolean isWatcherStarted() {
        return this._serviceStarted;
    }

    protected synchronized void updateState() {
        int start = this._updateCount;
        this.notifyAll();
        while (start == this._updateCount && this._thread != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected synchronized void changeState(int newState, IStatus status) {
        this._state = newState;
        this._status = status;
        this.notifyAll();
        this.dispatchListeners();
    }

    public synchronized void addServerStateListeners(IServerStateListener listener) {
        listener.hashCode();
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
        listener.serverStateChanged();
    }

    public synchronized void removeServerStateListeners(IServerStateListener listener) {
        listener.hashCode();
        this._listeners.remove(listener);
    }

    protected synchronized void dispatchListeners() {
        for (IServerStateListener listener : this._listeners) {
            listener.serverStateChanged();
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (this._launch == null) {
            return;
        }
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            if (event.getKind() == 8 && event.getSource() instanceof IDebugTarget) {
                IDebugTarget[] iDebugTargetArray = this._launch.getDebugTargets();
                int n3 = iDebugTargetArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IDebugTarget target = iDebugTargetArray[n4];
                    if (target == event.getSource()) {
                        this._launch.removeDebugTarget(target);
                        return;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void disconnectDebugTargets() {
        if (this._launch == null) {
            return;
        }
        IDebugTarget[] iDebugTargetArray = this._launch.getDebugTargets();
        int n = iDebugTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget target = iDebugTargetArray[n2];
            try {
                target.disconnect();
            }
            catch (DebugException debugException) {}
            ++n2;
        }
    }

    public synchronized int getServerState() {
        return this._state;
    }

    public IStatus getServerStatus() {
        return this._status;
    }

    public synchronized boolean isServerStarting() {
        return this._starting;
    }

    public synchronized boolean isServerStopping() {
        return this._stopping;
    }

    public synchronized void setServerStarting(boolean starting) {
        this._starting = starting;
    }

    public synchronized void setServerStopping(boolean stopping) {
        this._stopping = stopping;
        this._starting = false;
        this.notifyAll();
    }

    public synchronized void setLaunch(ILaunch launch) {
        this._launch = launch;
    }

    public boolean isDebuggingOnServer() {
        if (this._launch == null) {
            return false;
        }
        IDebugTarget[] targets = this._launch.getDebugTargets();
        if (targets == null || targets.length == 0) {
            return false;
        }
        IDebugTarget[] iDebugTargetArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugTarget target = iDebugTargetArray[n2];
            if (!target.isTerminated() && !target.isDisconnected()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized void reset() {
        this._state = 0;
        this.runOnce();
    }

    public synchronized boolean isServerStarted() {
        return this._state == 6;
    }

    public synchronized boolean isServerStopped() {
        return this._state == 2 || this._state == 5 || this._state == 4 || this._state == 7;
    }

    public synchronized boolean isServerConflict() {
        return this._state == 7 || this._state == 4;
    }

    public synchronized IStatus validateServerStartable() {
        if (!this.isWatcherStarted() || this.isWatcherStopped()) {
            String msg = CorePlugin.getString("errorServerWatcherTerminated", new Object[0]);
            return CorePlugin.createErrorStatus(msg);
        }
        if (this._state == 0) {
            this.updateState();
        }
        switch (this._state) {
            case 1: {
                String msg = CorePlugin.getString("errorServerStartGeneral", new Object[0]);
                return CorePlugin.createMultiStatus(msg, this._status);
            }
            case 9: {
                String msg = "server is stopping... please wait";
                return CorePlugin.createMultiStatus(msg, this._status);
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                String msg = CorePlugin.getString("errorServerStartConflictGeneral", new Object[0]);
                return CorePlugin.createMultiStatus(msg, this._status);
            }
            case 6: {
                String msg = CorePlugin.getString("errorServerAlreadyStarted", new Object[0]);
                return CorePlugin.createWarnStatus(msg);
            }
            case 8: {
                String msg = CorePlugin.getString("errorServerAlreadyStarting", new Object[0]);
                return CorePlugin.createWarnStatus(msg);
            }
            case 2: {
                return CorePlugin.STATUS_OK;
            }
        }
        if (this._status == null || this._status.isOK()) {
            String msg = CorePlugin.getString("errorServerWatcherStateNotRecognized", new Object[0]);
            return CorePlugin.createErrorStatus(msg);
        }
        String msg = CorePlugin.getString("errorServerWatcherStateNotRecognized", new Object[0]);
        return CorePlugin.createMultiStatus(msg, this._status);
    }

    public synchronized IStatus validateServerStoppable() {
        if (!this.isWatcherStarted() || this.isWatcherStopped()) {
            String msg = CorePlugin.getString("errorServerWatcherTerminated", new Object[0]);
            return CorePlugin.createErrorStatus(msg);
        }
        if (this._state == 0) {
            this.updateState();
        }
        switch (this._state) {
            case 1: {
                String msg = CorePlugin.getString("errorServerStopGeneral", new Object[0]);
                return CorePlugin.createMultiStatus(msg, this._status);
            }
            case 9: {
                String msg = CorePlugin.getString("errorServerAlreadyStopping", new Object[0]);
                return CorePlugin.createMultiStatus(msg, this._status);
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                String msg = CorePlugin.getString("errorServerStopConflictGeneral", new Object[0]);
                return CorePlugin.createMultiStatus(msg, this._status);
            }
            case 6: {
                return CorePlugin.STATUS_OK;
            }
            case 8: {
                String msg = CorePlugin.getString("errorServerAlreadyStarting", new Object[0]);
                return CorePlugin.STATUS_OK;
            }
            case 2: {
                String msg = CorePlugin.getString("errorServerAlreadyStopped", new Object[0]);
                return CorePlugin.createWarnStatus(msg);
            }
        }
        if (this._status == null || this._status.isOK()) {
            String msg = CorePlugin.getString("errorServerWatcherStateNotRecognized", new Object[0]);
            return CorePlugin.createErrorStatus(msg);
        }
        String msg = CorePlugin.getString("errorServerWatcherStateNotRecognized", new Object[0]);
        return CorePlugin.createMultiStatus(msg, this._status);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void waitPoll(long delay) {
        try {
            long now = System.currentTimeMillis();
            if (this._nextPoll > now) {
                long timeOut = this._nextPoll - now;
                if (timeOut < 100L) {
                    System.out.println("tight wait:" + timeOut);
                }
                this.wait(timeOut);
            }
            now = System.currentTimeMillis();
            this._nextPoll = now + delay;
        }
        catch (InterruptedException interruptedException) {}
    }

    private void runOnce() {
        int newState = this._state;
        IStatus newStatus = this._status;
        try {
            IStatus validateStatus;
            if (this._starting && !(validateStatus = this._behaviour.validateConfiguration()).isOK()) {
                newState = 1;
                newStatus = validateStatus;
                return;
            }
            if (this._stopping) {
                this._behaviour.getPublisher().disconnect();
            }
            if (!(validateStatus = this._behaviour.validatePingable()).isOK()) {
                validateStatus = this._behaviour.validateConfiguration();
                if (!validateStatus.isOK()) {
                    newState = 1;
                    newStatus = validateStatus;
                    return;
                }
                if (this._stopping) {
                    this.waitLaunchTerminate();
                }
                newState = 2;
                newStatus = validateStatus;
                return;
            }
            if (this._state == 1 || this._state == 0 || this._state == 2 || this._state == 5 || this._state == 8) {
                Server server = (Server)this._behaviour.getWeblogicServer().getServer();
                server.setServerStatus((IStatus)new Status(1, "oracle.eclipse.tools.weblogic", "Validating server..."));
                validateStatus = this._behaviour.validateRemote();
                if (!validateStatus.isOK()) {
                    newStatus = validateStatus;
                    int code = validateStatus.getCode();
                    newState = code == 5002 ? 4 : (code == 5003 ? 7 : (code == 5004 ? 7 : (code == 5001 ? 3 : 5)));
                    server.setServerStatus(validateStatus);
                } else {
                    server.setServerStatus(Status.OK_STATUS);
                    newStatus = CorePlugin.STATUS_OK;
                    newState = 6;
                }
            } else {
                if (this._state == 9) {
                    return;
                }
                if (this._state == 4) {
                    return;
                }
                if (this._state == 3) {
                    return;
                }
                if (this._state == 6 || this._state == 7) {
                    return;
                }
            }
        }
        finally {
            if (newState == 2) {
                if (this._starting) {
                    newState = 8;
                }
            } else if (newState == 5) {
                if (this._starting) {
                    newState = 8;
                } else if (this._stopping) {
                    newState = 9;
                }
            } else if (newState == 6 && this._stopping) {
                newState = 9;
            }
            if (this._state == newState && this._status == newStatus && this.isDebuggingOnServer() == this._debugging) {
                return;
            }
            this._debugging = this.isDebuggingOnServer();
            this.changeState(newState, newStatus);
        }
    }

    private void waitLaunchTerminate() {
        if (this._launch == null || this._launch.getProcesses() == null || this._launch.getProcesses().length == 0) {
            this.waitPoll(10000L);
            return;
        }
        int i = 0;
        int len = 150;
        while (i < len) {
            boolean running = false;
            IProcess[] iProcessArray = this._launch.getProcesses();
            int n = iProcessArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess process = iProcessArray[n2];
                if (!process.isTerminated()) {
                    running = true;
                    break;
                }
                ++n2;
            }
            if (!running) {
                return;
            }
            this.waitPoll(1000L);
            ++i;
        }
    }

    private void cleanup() {
        this._thread = null;
    }
}

