/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IWlsDeployRuntime;
import oracle.eclipse.tools.weblogic.server.WlsDeployRuntimeFactory;
import oracle.eclipse.tools.weblogic.server.internal.JDBCSystemModulePublishTask;
import oracle.eclipse.tools.weblogic.server.internal.JMSSystemModulePublishTask;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.FileUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.ServerLaunchUtils;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicDeployableModule;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import oracle.eclipse.tools.weblogic.server.model.WeblogicPublishOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.Server;

class PreparationOperation
extends WeblogicPublishOperation {
    private static final String AUTO_GENERATED_EAR_APP_XML_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><application id=\"Application_ID\" version=\"1.4\" xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd\">%n   <display-name>_auto_generated_ear_</display-name>%n   %s%n</application>";
    private static final String EAR_50_MISSING_APP_XML_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>%n<application id=\"Application_ID\" version=\"5\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_5.xsd\">%n   %s%n</application> ";
    private static final String WEB_MODULE_TEMPLATE = "<module>%n   <web>%n       <web-uri>%s</web-uri>%n       <context-root>%s</context-root>%n   </web>%n</module>%n";
    private static final String WELCOME1_WAR = "welcome1.war";
    private static final String EJB_MODULE_TEMPLATE = "<module>%n   <ejb>%s</ejb>%n</module>%n";
    private static final String CONNECTOR_MODULE_TEMPLATE = "<module>%n   <connector>%s</connector>%n</module>%n";
    private static final String APP_CLIENT_MODULE_TEMPLATE = "<module>%n   <java>%s</java>%n</module>%n";

    public PreparationOperation(IServer server) {
        super(CorePlugin.getString("msgPublishPrepareTaskTitle", new Object[0]), CorePlugin.getString("msgPublishPrepareTaskDesc", new Object[0]), server);
    }

    public int getOrder() {
        return 0;
    }

    @Override
    public void execute(IProgressMonitor monitor, IAdaptable shell) throws CoreException {
        WeblogicServerBehaviour weblogicServer = (WeblogicServerBehaviour)this._server.loadAdapter(WeblogicServerBehaviour.class, monitor);
        if (weblogicServer.getWeblogicServer().isRemote()) {
            return;
        }
        if (!weblogicServer.isDeployInSplitSrcMode()) {
            return;
        }
        if (WebLogicServerUtil.needWorkAroundForJSF20(this._server)) {
            return;
        }
        this.prepareAutoGeneratedEARSplitSourceFolder(monitor);
        super.execute(monitor, shell);
    }

    private void prepareAutoGeneratedEARSplitSourceFolder(IProgressMonitor monitor) throws CoreException {
        if (this._server instanceof Server) {
            Server server = (Server)this._server;
            IPath dirPath = ServerLaunchUtils.getAutoGeneratedEarPath(server);
            if (dirPath == null) {
                return;
            }
            File dir = dirPath.toFile();
            if (!dir.exists() || !dir.isDirectory()) {
                FileUtil.thrust(dir);
            }
            IPath metaPath = dirPath.append("META-INF");
            File metaFile = metaPath.toFile();
            this.createMetaFile(metaFile);
            IPath ssPath = dirPath.append(".beabuild.txt");
            File ssFile = ssPath.toFile();
            if (ssFile.exists() && !ssFile.delete()) {
                String msg = CorePlugin.getString("errorPublishTaskCleanSplitSource", ssPath.toOSString());
                CorePlugin.getLevelLog().log(CorePlugin.createWarnStatus(msg));
            }
            PreparationOperation.createWelcomeWebApp(dirPath);
        }
    }

    private static void createWelcomeWebApp(IPath earRoot) {
        IPath welcomeWarPath = earRoot.append(WELCOME1_WAR);
        File f = welcomeWarPath.toFile();
        if (!f.exists()) {
            f.mkdirs();
            IPath welcomeWarWebInfPath = welcomeWarPath.append("WEB-INF");
            welcomeWarWebInfPath.toFile().mkdirs();
        }
    }

    private void createMetaFile(File metaFolder) throws CoreException {
        IModule[] modules = this._server.getModules();
        StringBuffer buf = new StringBuffer();
        buf.append(String.format(WEB_MODULE_TEMPLATE, WELCOME1_WAR, "welcome1"));
        HashMap<String, String> contextRootList = new HashMap<String, String>();
        if (modules.length == 0) {
            return;
        }
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            if (module.getModuleType().getId().equals("oracle.coherence.gar")) {
                String msg = "WebLogic server does not support deployment of standalone Coherence module '%s' in virtual application mode.Please change publishing mode to exploded archive in server properties page.";
                msg = String.format(msg, module.getName());
                IStatus sts = WlsCorePlugin.createErrorStatus(msg);
                ((Server)this._server).setModuleStatus(new IModule[]{module}, sts);
                throw new CoreException(sts);
            }
            ++n2;
        }
        int i = 0;
        while (i < modules.length) {
            IModule module = modules[i];
            IProject project = module.getProject();
            if (FacetUtil.hasWebFacet(module)) {
                String contextRoot = J2EEProjectUtilities.getServerContextRoot((IProject)project);
                if (contextRootList.get(contextRoot) == null) {
                    contextRootList.put(contextRoot, module.getName());
                    buf.append(String.format(WEB_MODULE_TEMPLATE, String.valueOf(module.getName()) + ".war", contextRoot));
                } else {
                    String existingModule = (String)contextRootList.get(contextRoot);
                    String message = "Context root of web module " + module.getName() + " is conflicting with " + existingModule + "%n";
                    message = String.valueOf(message) + module.getName() + " will not be published. ";
                    message = String.valueOf(message) + "Please fix the conflict and republish.";
                    LoggingService.logWarning((String)"oracle.eclipse.tools.weblogic", (String)message);
                }
            }
            ++i;
        }
        String strXml = String.format(AUTO_GENERATED_EAR_APP_XML_TEMPLATE, buf.toString());
        PreparationOperation.writeApplicationXml(metaFolder, strXml);
    }

    static void writeApplicationXml(File metaFolder, String applicationXmlText) throws CoreException {
        if (!metaFolder.exists() || !metaFolder.isDirectory()) {
            FileUtil.thrust(metaFolder);
        }
        File applicationXml = new File(metaFolder, "application.xml");
        try {
            FileOutputStream fos = new FileOutputStream(applicationXml);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF8");
            out.write(applicationXmlText);
            ((Writer)out).close();
        }
        catch (IOException e) {
            String msg = CorePlugin.getString("errorWritingApplicationXml", applicationXml.toString());
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.weblogic", 0, msg, (Throwable)e));
        }
    }

    @Override
    public void processRootModule(IWeblogicModule mod, IProgressMonitor monitor) throws CoreException {
        if (mod == null || mod.getKind() == 3) {
            return;
        }
        IModule module = mod.getModule();
        if (module instanceof DeletedModule) {
            return;
        }
        if (!FacetUtil.hasEarFacet(module)) {
            return;
        }
        this.prepareSplitSourceFolder(mod, monitor);
    }

    private void prepareSplitSourceFolder(IWeblogicModule mod, IProgressMonitor monitor) throws CoreException {
        IModule module = mod.getModule();
        IPath dirPath = ((IWeblogicDeployableModule)mod).getDeploymentPath();
        File dir = dirPath.toFile();
        IPath metaPath = dirPath.append("META-INF");
        File metaFile = metaPath.toFile();
        boolean newMetaDir = false;
        if (!dir.exists() || !dir.isDirectory()) {
            FileUtil.thrust(dir);
            newMetaDir = true;
        } else {
            IPath ssPath;
            File ssFile;
            if (!metaFile.exists() || !metaFile.isDirectory()) {
                FileUtil.thrust(metaFile);
                newMetaDir = true;
            }
            if ((ssFile = (ssPath = dirPath.append(".beabuild.txt")).toFile()).exists() && !ssFile.delete()) {
                String msg = CorePlugin.getString("errorPublishTaskCleanSplitSource", ssPath.toOSString());
                throw new CoreException(CorePlugin.createErrorStatus(msg));
            }
        }
        IProject proj = module.getProject();
        IVirtualComponent comp = ComponentCore.createComponent((IProject)proj);
        if (newMetaDir || PreparationOperation.hasModuleChanges(mod)) {
            HashSet<IResource> filesToCopy = new HashSet<IResource>();
            StructureEdit earStruct = StructureEdit.getStructureEditForRead((IProject)proj);
            EList resources = earStruct.getComponent().getResources();
            for (ComponentResource res1 : resources) {
                IPath rtPath = res1.getRuntimePath();
                if (!rtPath.isRoot()) continue;
                IPath srcPath = res1.getSourcePath().makeRelative();
                IFolder folder = proj.getFolder(srcPath);
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res2 = iResourceArray[n2];
                    String name = res2.getName();
                    if (!name.endsWith("APP-INF") && !name.endsWith(".war")) {
                        filesToCopy.add(res2);
                    }
                    ++n2;
                }
            }
            IResource[] listResourceToCopy = new IResource[filesToCopy.size()];
            filesToCopy.toArray(listResourceToCopy);
            IResource[] iResourceArray = listResourceToCopy;
            int n = listResourceToCopy.length;
            int rtPath = 0;
            while (rtPath < n) {
                IResource resToCopy = iResourceArray[rtPath];
                if (resToCopy instanceof IFolder) {
                    File destFolder = new File(dirPath.toFile(), resToCopy.getName());
                    FileUtil.copy((IContainer)((IFolder)resToCopy), destFolder);
                } else {
                    File destFile = new File(dirPath.toFile(), resToCopy.getName());
                    FileUtil.copy((IFile)resToCopy, destFile);
                }
                ++rtPath;
            }
            WeblogicServer server = (WeblogicServer)this._server.loadAdapter(WeblogicServer.class, null);
            File domainDir = server.getDomainPath().toFile();
            this.convertEncryptedPassword(proj, dirPath, domainDir);
        }
        PreparationOperation.createDefault50ApplicationXml(module, comp, metaFile);
    }

    public static void createDefault50ApplicationXml(IModule module, IVirtualComponent comp, File metaFile) throws CoreException {
        IVirtualFile appXmlFile;
        IProject earProject = module.getProject();
        if (J2EEProjectUtilities.isJEEProject((IProject)earProject) && !(appXmlFile = ComponentCore.createFile((IProject)earProject, (IPath)new Path("META-INF").append("application.xml"))).exists()) {
            IVirtualReference[] refs;
            HashSet<String> binaryModules = new HashSet<String>();
            StringBuffer modulesBuff = new StringBuffer();
            IVirtualReference[] iVirtualReferenceArray = refs = comp.getReferences();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualReference ref = iVirtualReferenceArray[n2];
                IVirtualComponent childComp = ref.getReferencedComponent();
                if (childComp != null) {
                    J2EEModuleVirtualArchiveComponent archive;
                    String deployPath;
                    String archiveName = ref.getArchiveName();
                    IProject project = childComp.getProject();
                    String projName = project.getName().replace(' ', '_');
                    if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
                        String contextRoot = J2EEProjectUtilities.getServerContextRoot((IProject)project);
                        modulesBuff.append(String.format(WEB_MODULE_TEMPLATE, archiveName, contextRoot));
                    } else if (JavaEEProjectUtilities.isJCAProject((IProject)project)) {
                        modulesBuff.append(String.format(CONNECTOR_MODULE_TEMPLATE, String.valueOf(projName) + ".rar"));
                    } else if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
                        modulesBuff.append(String.format(EJB_MODULE_TEMPLATE, archiveName));
                    } else if (JavaEEProjectUtilities.isApplicationClientProject((IProject)project)) {
                        modulesBuff.append(String.format(APP_CLIENT_MODULE_TEMPLATE, String.valueOf(projName) + ".jar"));
                    }
                    if (childComp.isBinary() && childComp instanceof J2EEModuleVirtualArchiveComponent && !(deployPath = (archive = (J2EEModuleVirtualArchiveComponent)childComp).getRuntimePath().toPortableString()).startsWith("/lib") && !deployPath.startsWith("/APP-INF/lib/")) {
                        String deployName = archive.getDeployedName();
                        if (!binaryModules.contains(deployName = deployName.substring(deployName.lastIndexOf(47) + 1))) {
                            binaryModules.add(deployName);
                            if (deployName.endsWith(".jar")) {
                                if (WtpProjectUtil.isEjbModule((IProject)module.getProject(), (String)deployName) || WtpProjectUtil.isEjbComponent((IVirtualComponent)childComp)) {
                                    modulesBuff.append(String.format(EJB_MODULE_TEMPLATE, deployName));
                                }
                            } else if (deployName.endsWith(".war")) {
                                String contextRoot = deployName.substring(0, deployName.indexOf(".war"));
                                modulesBuff.append(String.format(WEB_MODULE_TEMPLATE, deployName, contextRoot));
                            } else if (deployName.endsWith(".rar")) {
                                modulesBuff.append(String.format(CONNECTOR_MODULE_TEMPLATE, deployName));
                            }
                        }
                    }
                }
                ++n2;
            }
            if (modulesBuff.length() == 0) {
                modulesBuff.append(String.format(WEB_MODULE_TEMPLATE, WELCOME1_WAR, module.getName()));
                PreparationOperation.createWelcomeWebApp((IPath)new Path(metaFile.getParentFile().getAbsolutePath()));
            }
            String appXmlText = String.format(EAR_50_MISSING_APP_XML_TEMPLATE, modulesBuff.toString());
            PreparationOperation.writeApplicationXml(metaFile, appXmlText);
        }
    }

    private void convertEncryptedPassword(IProject proj, IPath path, File domainDir) throws CoreException {
        File[] toFiles;
        File toDir = path.toFile();
        File[] fileArray = toFiles = toDir.listFiles();
        int n = toFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                IWlsDeployRuntime wlsDeployRuntime;
                IJ2EEDeploymentHelper helper;
                if (file.getName().endsWith("-jms.xml")) {
                    helper = null;
                    wlsDeployRuntime = WlsDeployRuntimeFactory.create(proj);
                    if (wlsDeployRuntime != null && (helper = wlsDeployRuntime.getJ2EEDeploymentHelper()) != null && domainDir != null) {
                        JMSSystemModulePublishTask.convertJmsPassword(this._server, domainDir, helper, file);
                    }
                } else if (file.getName().endsWith("-jdbc.xml")) {
                    helper = null;
                    wlsDeployRuntime = WlsDeployRuntimeFactory.create(proj);
                    if (wlsDeployRuntime != null && (helper = wlsDeployRuntime.getJ2EEDeploymentHelper()) != null && domainDir != null) {
                        JDBCSystemModulePublishTask.convertJdbcPassword(this._server, domainDir, helper, file);
                    }
                }
            } else if (file.isDirectory()) {
                this.convertEncryptedPassword(proj, path.append(file.getName()), domainDir);
            }
            ++n2;
        }
    }
}

