/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.File;
import java.util.Properties;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;

public class Paths {
    public static final int STATUS_CODE_PATH_ERROR = 4001;
    public static final int STATUS_CODE_WRONG_VERSION = 4002;
    private static final int DISPLAY_STRINGS_SIZE = 55;

    private Paths() {
    }

    public static IStatus validateDirectory(IPath root) {
        if (root == null || root.isEmpty()) {
            return CorePlugin.createErrorStatus(Paths.getString("errorDirNotSet", new Object[0]));
        }
        File file = root.toFile();
        String display = root.toOSString();
        if (!file.exists()) {
            return CorePlugin.createErrorStatus(Paths.getString("errorDirNotExist", display), null, 4001);
        }
        if (!file.isDirectory()) {
            return CorePlugin.createErrorStatus(Paths.getString("errorPathNotDir", display), null, 4001);
        }
        return CorePlugin.STATUS_OK;
    }

    public static IStatus verifyExists(IPath base, Properties prop, String key) {
        String s;
        int i = 0;
        while ((s = prop.getProperty(String.valueOf(key) + "." + i)) != null && s.length() != 0) {
            IStatus status = Paths.validateRequiredFile(base, s);
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        return CorePlugin.STATUS_OK;
    }

    public static IStatus validateShellScript(IPath base, String command) {
        String script = String.valueOf(command) + "." + CorePlugin.getScriptExtension();
        return Paths.validateRequiredFile(base, script);
    }

    public static IStatus validateNonEmptyDirectory(IPath root) {
        IStatus status = Paths.validateDirectory(root);
        if (!status.isOK()) {
            return status;
        }
        File file = root.toFile();
        String display = Paths.getDisplayString(root);
        if (file.list() == null || file.list().length == 0) {
            return CorePlugin.createErrorStatus(Paths.getString("errorPathEmptyDir", display), null, 4001);
        }
        return CorePlugin.STATUS_OK;
    }

    public static IStatus validateRequiredFile(IPath base, String path) {
        File file = new File(base.toFile(), path);
        if (!file.exists()) {
            String msg = CorePlugin.getString("errorRequiredFile", path);
            return CorePlugin.createErrorStatus(msg);
        }
        return CorePlugin.STATUS_OK;
    }

    public static String getDisplayString(IPath path) {
        String display = path.toOSString();
        if (display.length() > 55) {
            int cutOffset = 11;
            int cutEnd = display.length() / 3 * 2;
            String omitted = "... " + System.getProperty("file.separator") + System.getProperty("file.separator") + "...";
            display = String.valueOf(display.substring(0, cutOffset)) + omitted + display.substring(cutEnd);
        }
        return display;
    }

    private static String getString(String key, Object ... args) {
        return CorePlugin.getString(key, args);
    }
}

