/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WLSTRunnerUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.appmodel.IModuleDependency;
import oracle.eclipse.tools.weblogic.appmodel.IWebLogicJmsConfigRef;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.descriptors.jms.IForeignConnectionFactory;
import oracle.eclipse.tools.weblogic.descriptors.jms.IForeignServer;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueueBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFLoginContext;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFRemoteContext;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopic;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopicBase;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.IWlsDeployRuntime;
import oracle.eclipse.tools.weblogic.server.WlsDeployRuntimeFactory;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicSystemModulePublishTask;
import oracle.eclipse.tools.weblogic.server.internal.util.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.osgi.framework.Bundle;

public class JMSSystemModulePublishTask
extends WeblogicSystemModulePublishTask {
    private static final String DEPLOY_JMS_SYS_MODULE_SCRIPT = "wlst.scripts/deploy_jms_sys_module.py";
    private static final String UNDEPLOY_JMS_SYS_MODULE_SCRIPT = "wlst.scripts/undeploy_jms_sys_module.py";
    public static final int ID_WARNING_REMOTE_JMS_NOT_SUPPORTED = 5001;
    public static final int ID_WARNING_FOUND_JMS_SUBDEPLOYMENT = 5002;

    public static void undeployJMSSystemModule(WeblogicServer ws, IProject project, IFile file) {
        try {
            InputStream scriptFileInputStream = FileLocator.openStream((Bundle)WlsCorePlugin.getPluginBundle(), (IPath)new Path(UNDEPLOY_JMS_SYS_MODULE_SCRIPT), (boolean)false);
            HashMap<String, String> extraProps = new HashMap<String, String>();
            String name = file.getName();
            name = name.substring(0, name.indexOf("-jms.xml"));
            extraProps.put("%JMS_MODULE_NAME%", name);
            CorePlugin.getLevelLog().logInfo(String.valueOf(Resources.undeployJmsSysModule) + name);
            WLSTRunnerUtil.runWLSTScript(ws, scriptFileInputStream, extraProps, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CorePlugin.getLevelLog().logInfo(e.getStatus());
        }
        catch (IOException iOException) {
            CorePlugin.getLevelLog().logInfo(CorePlugin.createErrorStatus("WLST script file not found wlst.scripts/undeploy_jms_sys_module.py"));
        }
    }

    private boolean hasConfigChanged(File f1, File f2) {
        long timestamp2;
        long timestamp1;
        return !f1.exists() || !f2.exists() || (timestamp1 = f1.lastModified()) > (timestamp2 = f2.lastModified());
    }

    private String findSubDeployment(String path) {
        StringBuffer ret = new StringBuffer();
        try {
            String subdeployment;
            IFile newFileHandle = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
            IWebLogicJmsModuleDescriptor jmsDescriptor = WebLogicDescriptorFactory.getJmsModuleDescriptor(newFileHandle);
            ArrayList<String> list = new ArrayList<String>();
            for (IQueueBase queue : jmsDescriptor.getQueues()) {
                if (queue.type() != IQueue.TYPE || (subdeployment = ((IQueue)queue).getSubDeploymentName().text()) == null) continue;
                list.add(subdeployment);
            }
            for (ITopicBase topic : jmsDescriptor.getTopics()) {
                if (topic.type() != ITopic.TYPE || (subdeployment = ((ITopic)topic).getSubDeploymentName().text()) == null) continue;
                list.add(subdeployment);
            }
            int i = 0;
            while (i < list.size()) {
                ret.append("'" + (String)list.get(i) + "'");
                if (i < list.size() - 1) {
                    ret.append(",");
                }
                ++i;
            }
            jmsDescriptor.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret.toString();
    }

    @Override
    protected void deploySystemModule(IServer server, IModuleDependency dep, IProgressMonitor monitor) throws CoreException {
        super.deploySystemModule(server, dep, monitor);
        if (!(dep instanceof IWebLogicJmsConfigRef)) {
            return;
        }
        try {
            WeblogicServerBehaviour behaviour = (WeblogicServerBehaviour)server.loadAdapter(WeblogicServerBehaviour.class, null);
            WeblogicServer ws = (WeblogicServer)server.loadAdapter(IWeblogicServer.class, null);
            IWebLogicJmsConfigRef jmsConfig = (IWebLogicJmsConfigRef)dep;
            String jmsPath = jmsConfig.getName().text();
            monitor.setTaskName(String.valueOf(Resources.deployingJmsModule) + jmsPath);
            String name = jmsConfig.getName().text();
            name = name.substring(0, name.indexOf("-jms.xml"));
            String p = ((org.eclipse.sapphire.modeling.Path)jmsConfig.getLocation().content()).toPortableString();
            IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(p));
            IPath path = ((Server)server).getTempDirectory();
            File moduleFolder = new File(path.toPortableString(), "system-modules");
            if (!moduleFolder.exists()) {
                moduleFolder.mkdirs();
            }
            File deployFile = new File(moduleFolder, jmsConfig.getName().text());
            if (!this.hasConfigChanged(workspaceFile.getLocation().toFile(), deployFile)) {
                return;
            }
            FileUtil.copy(workspaceFile, deployFile);
            if (!deployFile.exists()) {
                throw new CoreException(CorePlugin.createErrorStatus(String.valueOf(Resources.jmsDescriptorMissing) + jmsConfig.getName()));
            }
            File targetFile = new File(String.valueOf(ws.getDomainPath().toPortableString()) + "/config/jms/" + jmsConfig.getName());
            if (!this.hasConfigChanged(deployFile, targetFile)) {
                return;
            }
            WeblogicServer wlsServer = (WeblogicServer)server.loadAdapter(WeblogicServer.class, null);
            File domainDir = wlsServer.getDomainPath().toFile();
            IJ2EEDeploymentHelper helper = null;
            IWlsDeployRuntime wlsDeployRuntime = WlsDeployRuntimeFactory.create(server.getRuntime());
            if (wlsDeployRuntime != null && (helper = wlsDeployRuntime.getJ2EEDeploymentHelper()) != null && domainDir != null) {
                JMSSystemModulePublishTask.convertJmsPassword(server, domainDir, helper, deployFile);
            }
            CorePlugin.getLevelLog().logInfo(String.valueOf(Resources.foundJmsSysModule) + ":" + jmsPath);
            InputStream ios = FileLocator.openStream((Bundle)WlsCorePlugin.getPluginBundle(), (IPath)new Path(DEPLOY_JMS_SYS_MODULE_SCRIPT), (boolean)false);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("%JMS_MODULE_NAME%", name);
            props.put("%JMS_DESCRIPTOR_FILE%", deployFile.getAbsolutePath().replace('\\', '/'));
            String subdeployments = this.findSubDeployment("/" + jmsConfig.getLocation().text());
            props.put("%SUB_DEPLOYMENT_NAME%", subdeployments);
            if (subdeployments.length() > 0) {
                String msg = String.valueOf(Resources.foundSubdeployment) + subdeployments + "\n";
                msg = String.valueOf(msg) + Resources.defineSubDeploymentInConsole;
                behaviour.addPublishWarnings(5002, msg);
            }
            WLSTRunnerUtil.runWLSTScript(ws, ios, props, monitor);
            targetFile.setLastModified(deployFile.lastModified());
        }
        catch (IOException ioe) {
            IStatus status = CorePlugin.createErrorStatus("WLST Script not found", ioe);
            CorePlugin.getLevelLog().log(status);
            throw new CoreException(status);
        }
        catch (CoreException ce) {
            CorePlugin.getLevelLog().log(ce.getStatus());
            throw ce;
        }
    }

    static void convertJmsPassword(IServer server, File domainDir, IJ2EEDeploymentHelper helper, File file) {
        try {
            boolean modif = false;
            IWebLogicJmsModuleDescriptor jms = WebLogicDescriptorFactory.getJmsModuleDescriptor(file);
            for (ISAFRemoteContext context : jms.getSafRemoteContexts()) {
                String password;
                ISAFLoginContext loginContext = (ISAFLoginContext)context.getSafLoginContext().content();
                if (loginContext == null || (password = loginContext.getPassword().text()) == null || password.length() <= 0) continue;
                String encryptedPassword = WebLogicServerUtil.encrypt(server, helper, domainDir, password);
                loginContext.setPasswordEncrypted(encryptedPassword);
                modif = true;
            }
            for (IForeignServer foreignServer : jms.getForeignServers()) {
                String credential = foreignServer.getJndiPropertiesCredential().text();
                if (credential != null && credential.length() > 0) {
                    String encryptedCredential = WebLogicServerUtil.encrypt(server, helper, domainDir, credential);
                    foreignServer.setJndiPropertiesCredentialEncrypted(encryptedCredential);
                    modif = true;
                }
                for (IForeignConnectionFactory factory : foreignServer.getForeignConnectionFactories()) {
                    String password = factory.getPassword().text();
                    if (password == null || password.length() <= 0) continue;
                    String encryptedPassword = WebLogicServerUtil.encrypt(server, helper, domainDir, password);
                    factory.setPasswordEncrypted(encryptedPassword);
                    modif = true;
                }
            }
            if (modif) {
                jms.resource().save();
            }
            jms.dispose();
        }
        catch (ResourceStoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)e);
        }
    }

    private static final class Resources
    extends NLS {
        public static String undeployJmsSysModule;
        public static String foundJmsSysModule;
        public static String defineSubDeploymentInConsole;
        public static String foundSubdeployment;
        public static String deployingJmsModule;
        public static String jmsDescriptorMissing;

        static {
            Resources.initializeMessages((String)JMSSystemModulePublishTask.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

