/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WLSTRunnerUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.appmodel.IModuleDependency;
import oracle.eclipse.tools.weblogic.appmodel.IWebLogicJdbcConfigRef;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJdbcConfig;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDriverParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcOracleParameters;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.IWlsDeployRuntime;
import oracle.eclipse.tools.weblogic.server.WlsDeployRuntimeFactory;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicSystemModulePublishTask;
import oracle.eclipse.tools.weblogic.server.internal.util.FileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;
import org.osgi.framework.Bundle;

public class JDBCSystemModulePublishTask
extends WeblogicSystemModulePublishTask {
    private static final String DEPLOY_JDBC_SYS_MODULE_SCRIPT = "wlst.scripts/deploy_jdbc_sys_module.py";
    private static final String UNDEPLOY_JDBC_SYS_MODULE_SCRIPT = "wlst.scripts/undeploy_jdbc_sys_module.py";
    public static final int ID_WARNING_REMOTE_JDBC_NOT_SUPPORTED = 5001;

    public static void undeployJDBCSystemModule(WeblogicServer ws, IProject project, IFile file) {
        try {
            InputStream scriptFileInputStream = FileLocator.openStream((Bundle)WlsCorePlugin.getPluginBundle(), (IPath)new Path(UNDEPLOY_JDBC_SYS_MODULE_SCRIPT), (boolean)false);
            HashMap<String, String> extraProps = new HashMap<String, String>();
            String name = file.getName();
            name = name.substring(0, name.indexOf("-jdbc.xml"));
            extraProps.put("%JDBC_MODULE_NAME%", name);
            CorePlugin.getLevelLog().logInfo(String.valueOf(Resources.undeployJdbcSysModule) + name);
            WLSTRunnerUtil.runWLSTScript(ws, scriptFileInputStream, extraProps, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CorePlugin.getLevelLog().logInfo(e.getStatus());
        }
        catch (IOException iOException) {
            CorePlugin.getLevelLog().logInfo(CorePlugin.createErrorStatus("WLST script file not found wlst.scripts/undeploy_jdbc_sys_module.py"));
        }
    }

    private boolean hasConfigChanged(File f1, File f2) {
        long timestamp2;
        long timestamp1;
        return !f1.exists() || !f2.exists() || (timestamp1 = f1.lastModified()) > (timestamp2 = f2.lastModified());
    }

    @Override
    protected String getTaskName() {
        return Resources.taskName;
    }

    @Override
    protected String getTaskDescription() {
        return Resources.taskDescription;
    }

    @Override
    protected void deploySystemModule(IServer server, IModuleDependency dep, IProgressMonitor monitor) throws CoreException {
        super.deploySystemModule(server, dep, monitor);
        if (!(dep instanceof IWebLogicJdbcConfigRef)) {
            return;
        }
        try {
            WeblogicServer ws = (WeblogicServer)server.loadAdapter(IWeblogicServer.class, null);
            IWebLogicJdbcConfigRef jdbcConfig = (IWebLogicJdbcConfigRef)dep;
            String jdbcPath = jdbcConfig.getName().text();
            monitor.setTaskName(String.valueOf(Resources.deployingJdbcModule) + jdbcPath);
            String name = jdbcConfig.getName().text();
            name = name.substring(0, name.indexOf("-jdbc.xml"));
            String p = ((org.eclipse.sapphire.modeling.Path)jdbcConfig.getLocation().content()).toPortableString();
            IFile workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(p));
            IPath path = ((Server)server).getTempDirectory();
            File moduleFolder = new File(path.toPortableString(), "system-modules");
            if (!moduleFolder.exists()) {
                moduleFolder.mkdirs();
            }
            File deployFile = new File(moduleFolder, jdbcConfig.getName().text());
            if (!this.hasConfigChanged(workspaceFile.getLocation().toFile(), deployFile)) {
                return;
            }
            FileUtil.copy(workspaceFile, deployFile);
            if (!deployFile.exists()) {
                throw new CoreException(CorePlugin.createErrorStatus(String.valueOf(Resources.jdbcDescriptorMissing) + jdbcConfig.getName()));
            }
            File targetFile = new File(String.valueOf(ws.getDomainPath().toPortableString()) + "/config/jdbc/" + jdbcConfig.getName());
            if (!this.hasConfigChanged(deployFile, targetFile)) {
                return;
            }
            String jdbcConfigFile = deployFile.getAbsolutePath().replace('\\', '/');
            WeblogicServer wlsServer = (WeblogicServer)server.loadAdapter(WeblogicServer.class, null);
            File domainDir = wlsServer.getDomainPath().toFile();
            IJ2EEDeploymentHelper helper = null;
            IWlsDeployRuntime wlsDeployRuntime = WlsDeployRuntimeFactory.create(server.getRuntime());
            if (wlsDeployRuntime != null && (helper = wlsDeployRuntime.getJ2EEDeploymentHelper()) != null && domainDir != null) {
                JDBCSystemModulePublishTask.convertJdbcPassword(server, domainDir, helper, deployFile);
            }
            CorePlugin.getLevelLog().logInfo(String.valueOf(Resources.foundJdbcSysModule) + ":" + jdbcPath);
            InputStream ios = FileLocator.openStream((Bundle)WlsCorePlugin.getPluginBundle(), (IPath)new Path(DEPLOY_JDBC_SYS_MODULE_SCRIPT), (boolean)false);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("%JDBC_MODULE_NAME%", name);
            props.put("%JDBC_DESCRIPTOR_FILE%", jdbcConfigFile);
            String output = WLSTRunnerUtil.runWLSTScript(ws, ios, props, monitor);
            if (output.indexOf("[ERROR]") > 0) {
                throw new CoreException(WlsCorePlugin.createErrorStatus("JDBC system module publishing failed:\n" + output));
            }
            targetFile.setLastModified(deployFile.lastModified());
        }
        catch (IOException ioe) {
            IStatus status = CorePlugin.createErrorStatus("WLST Script not found", ioe);
            CorePlugin.getLevelLog().log(status);
            throw new CoreException(status);
        }
        catch (CoreException ce) {
            CorePlugin.getLevelLog().log(ce.getStatus());
            throw ce;
        }
    }

    static void convertJdbcPassword(IServer server, File domainDir, IJ2EEDeploymentHelper helper, File file) throws CoreException {
        try {
            IJdbcOracleParameters oracleParam;
            String existingPasswrd;
            String encryptedPassword;
            String password;
            IJdbcDriverParameters drvParam;
            boolean modif = false;
            IWebLogicJdbcConfig jdbc = WebLogicDescriptorFactory.getJdbcConfig(file);
            if (jdbc == null) {
                throw new CoreException(WlsCorePlugin.createErrorStatus("Error reading JDBC config from " + file.getAbsolutePath()));
            }
            if (jdbc.property((ElementProperty)IWebLogicJdbcConfig.PROP_DRIVER_PARAMETERS).enabled() && (drvParam = jdbc.getDriverParameters()).getPassword() != null && (password = (String)drvParam.getPassword().content()) != null) {
                encryptedPassword = WebLogicServerUtil.encrypt(server, helper, domainDir, password);
                if (!encryptedPassword.equals(existingPasswrd = (String)drvParam.getPasswordEncrypted().content())) {
                    drvParam.setPasswordEncrypted(encryptedPassword);
                }
                modif = true;
            }
            if (jdbc.property((ElementProperty)IWebLogicJdbcConfig.PROP_ORACLE_PARAMETERS).enabled() && (oracleParam = jdbc.getOracleParameters()).getOnsWalletPassword().content() != null) {
                String onsPassword = (String)oracleParam.getOnsWalletPassword().content();
                encryptedPassword = WebLogicServerUtil.encrypt(server, helper, domainDir, onsPassword);
                if (!encryptedPassword.equals(existingPasswrd = (String)oracleParam.getOnsWalletPasswordEncrypted().content())) {
                    oracleParam.setOnsWalletPasswordEncrypted(encryptedPassword);
                }
                modif = true;
            }
            if (modif) {
                jdbc.resource().save();
            }
            jdbc.dispose();
        }
        catch (ResourceStoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)e);
        }
    }

    private static final class Resources
    extends NLS {
        public static String taskName;
        public static String taskDescription;
        public static String undeployJdbcSysModule;
        public static String foundJdbcSysModule;
        public static String deployingJdbcModule;
        public static String jdbcDescriptorMissing;

        static {
            Resources.initializeMessages((String)JDBCSystemModulePublishTask.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

