/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.util.fileio.virtualfs.ConflictingPathsException;
import oracle.eclipse.tools.common.util.fileio.virtualfs.VirtualFileSystem;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.descriptors.IModuleDefinition;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.VirtualEarManager;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicPublishTask;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicStandaloneGARModule;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.FileUtil;
import oracle.eclipse.tools.weblogic.server.internal.util.ServerLaunchUtils;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicDeployableModule;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import oracle.eclipse.tools.weblogic.server.model.WeblogicPublishOperation;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.internal.modulecore.ClasspathContainerVirtualComponent;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.Server;

class GenerationOperation
extends WeblogicPublishOperation {
    public GenerationOperation(IServer server) {
        super(CorePlugin.getString("msgPublishArtifactTaskTitle", new Object[0]), CorePlugin.getString("msgPublishArtifactTaskDesc", new Object[0]), server);
    }

    public int getOrder() {
        return 10;
    }

    @Override
    public void processRootModule(IWeblogicModule mod, IProgressMonitor monitor) throws CoreException {
        if (mod.getKind() == 3) {
            return;
        }
        IModule module = mod.getModule();
        if (module instanceof DeletedModule) {
            return;
        }
        WeblogicServerBehaviour weblogicServer = (WeblogicServerBehaviour)this._server.loadAdapter(WeblogicServerBehaviour.class, monitor);
        if (weblogicServer.getWeblogicServer().isRemote()) {
            return;
        }
        if (!weblogicServer.isDeployInSplitSrcMode()) {
            return;
        }
        if (WebLogicServerUtil.needWorkAroundForJSF20(this._server)) {
            return;
        }
        if (FacetUtil.hasWebFacet(module) || mod instanceof WeblogicStandaloneGARModule) {
            this.addModuleToAutoGeneratedEarApplication(module, monitor);
            return;
        }
        if (!FacetUtil.hasEarFacet(module)) {
            return;
        }
        IPath deployPath = ((IWeblogicDeployableModule)mod).getDeploymentPath();
        File file = deployPath.toFile();
        try {
            VirtualFileSystem vfs = VirtualEarManager.readDescriptor(file);
            this.generateApplicationEntries(module, vfs, monitor);
            IModule[] iModuleArray = this._server.getChildModules(new IModule[]{module}, monitor);
            int n = iModuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                String filePath;
                File dir;
                IModule child = iModuleArray[n2];
                ArrayList<Entry> links = new ArrayList<Entry>();
                this.generateDependentEntries(mod, child.getProject(), links, monitor);
                this.patchDependentEntries(links, monitor);
                for (Entry entry : links) {
                    vfs.link(entry.source.toString(), entry.base.append(entry.destin).toString());
                }
                IFacetedProject facetProject = ProjectFacetsManager.create((IProject)child.getProject());
                if (facetProject.hasProjectFacet(FacetUtil.FACET_JST_WEB) && !(dir = new File(filePath = String.valueOf(WeblogicPublishTask.getGeneratedWebRoot(child.getProject())) + "/" + "WEB-INF")).exists()) {
                    dir.mkdirs();
                }
                ++n2;
            }
            this.addEarContentArchiveEntries(module, vfs, monitor);
            this.addJavaEEDependencyEntries(module, vfs);
            VirtualEarManager.writeDescriptor(file, vfs);
        }
        catch (ConflictingPathsException cpe) {
            String msg = CorePlugin.getString("errorPublishTaskSplitSourceException", new Object[0]);
            throw new CoreException(CorePlugin.createErrorStatus(msg, cpe));
        }
        catch (IOException ioe) {
            String msg = CorePlugin.getString("errorPublishTaskSplitSourceException", new Object[0]);
            throw new CoreException(CorePlugin.createErrorStatus(msg, ioe));
        }
    }

    private void addJavaEEDependencyEntries(IModule module, VirtualFileSystem vfs) throws ConflictingPathsException, CoreException {
        IVirtualReference[] refs;
        IVirtualComponent comp = ComponentCore.createComponent((IProject)module.getProject());
        IVirtualReference[] iVirtualReferenceArray = refs = comp.getReferences();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            IVirtualComponent vcomp = ref.getReferencedComponent();
            if (vcomp instanceof VirtualArchiveComponent) {
                J2EEModuleVirtualArchiveComponent arch = (J2EEModuleVirtualArchiveComponent)vcomp;
                File libFile = arch.getUnderlyingDiskFile().getAbsoluteFile();
                if (libFile.exists()) {
                    Path rtPath = new Path(libFile.getName());
                    Path base = new Path("APP-INF/lib/");
                    String rtPathString = rtPath.toPortableString();
                    if (rtPathString.endsWith(".war") || rtPathString.endsWith(".rar") || rtPathString.endsWith(".gar")) {
                        base = new Path("");
                    } else {
                        IProject earProj = module.getProject();
                        if (WtpProjectUtil.isEjbModule((IProject)earProj, (String)libFile.getName())) {
                            base = new Path("");
                        } else if (WtpProjectUtil.isEjbComponent((IVirtualComponent)vcomp)) {
                            base = new Path("");
                        }
                    }
                    Entry entry = new Entry((IPath)new Path(libFile.getAbsolutePath()), (IPath)base, (IPath)rtPath);
                    vfs.link(entry.source.toString(), entry.base.append(entry.destin).toString());
                }
            } else if (vcomp instanceof ClasspathContainerVirtualComponent) {
                Path base = new Path("APP-INF/lib/");
                ClasspathContainerVirtualComponent classPathComp = (ClasspathContainerVirtualComponent)vcomp;
                IClasspathContainer cpc = classPathComp.getClasspathContainer();
                IClasspathEntry[] iClasspathEntryArray = cpc.getClasspathEntries();
                int n3 = iClasspathEntryArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IClasspathEntry cpe = iClasspathEntryArray[n4];
                    String libName = cpe.getPath().lastSegment();
                    Path rtPath = new Path(libName);
                    IPath path = cpe.getPath();
                    Entry entry = new Entry(path, (IPath)base, (IPath)rtPath);
                    vfs.link(entry.source.toString(), entry.base.append(entry.destin).toString());
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void addModuleToAutoGeneratedEarApplication(IModule module, IProgressMonitor monitor) throws CoreException {
        if (this._server instanceof Server) {
            Server server = (Server)this._server;
            IWeblogicServer ws = (IWeblogicServer)server.loadAdapter(IWeblogicServer.class, null);
            if (ws.isRemote()) {
                return;
            }
            IPath path = server.getTempDirectory();
            WeblogicServerBehaviour weblogicServer = (WeblogicServerBehaviour)server.loadAdapter(WeblogicServerBehaviour.class, monitor);
            ServerInfo serverInfo = weblogicServer.getServerInfo();
            IPath dirPath = path.append(serverInfo.getDomainName()).append("_auto_generated_ear_");
            File earRoot = dirPath.toFile();
            try {
                String extension;
                VirtualFileSystem vfs = VirtualEarManager.readDescriptor(earRoot);
                ArrayList<Entry> links = new ArrayList<Entry>();
                String string = extension = FacetUtil.hasWebLogicGarFacet(module) ? ".gar" : ".war";
                if (".gar".equals(extension)) {
                    this.addGarModuleToWeblogicDD(earRoot, module.getName());
                }
                this.generateChildModuleEntries(module.getProject(), links, monitor, earRoot, (IPath)new Path(String.valueOf(module.getName()) + extension), null);
                this.patchDependentEntries(links, monitor);
                for (Entry entry : links) {
                    vfs.link(entry.source.toString(), entry.base.append(entry.destin).toString());
                }
                vfs.link(WeblogicPublishTask.getGeneratedWebRoot(module.getProject()), new Path(String.valueOf(module.getName()) + extension).toString());
                VirtualEarManager.writeDescriptor(earRoot, vfs);
            }
            catch (ConflictingPathsException cpe) {
                String msg = CorePlugin.getString("errorPublishTaskSplitSourceException", new Object[0]);
                throw new CoreException(CorePlugin.createErrorStatus(msg, cpe));
            }
            catch (IOException ioe) {
                String msg = CorePlugin.getString("errorPublishTaskSplitSourceException", new Object[0]);
                throw new CoreException(CorePlugin.createErrorStatus(msg, ioe));
            }
        }
    }

    private void addGarModuleToWeblogicDD(File earRoot, String name) {
        File wlsAppDescription = new File(earRoot, "/META-INF/weblogic-application.xml");
        wlsAppDescription.delete();
        IWebLogicAppDescriptor wlsAppDd = WebLogicDescriptorFactory.getAppDescriptor(wlsAppDescription);
        IModuleDefinition module = (IModuleDefinition)wlsAppDd.getModules().insert();
        module.setType("GAR");
        module.setName(name);
        module.setGarPath(String.valueOf(name) + ".gar");
        try {
            try {
                wlsAppDd.resource().save();
            }
            catch (ResourceStoreException e) {
                WlsCorePlugin.logException((Exception)((Object)e));
                wlsAppDd.dispose();
            }
        }
        finally {
            wlsAppDd.dispose();
        }
    }

    private void addEarContentArchiveEntries(IModule mod, VirtualFileSystem vfs, IProgressMonitor monitor) throws ConflictingPathsException, CoreException {
        StructureEdit earStruct = StructureEdit.getStructureEditForRead((IProject)mod.getProject());
        try {
            EList resources = earStruct.getComponent().getResources();
            for (ComponentResource res : resources) {
                IPath rtPath = res.getRuntimePath();
                if (!rtPath.isRoot()) continue;
                IPath srcPath = res.getSourcePath().makeRelative();
                IFolder src = mod.getProject().getFolder(srcPath);
                IFolder srcFolder = (IFolder)src.getAdapter(IFolder.class);
                IResource[] iResourceArray = srcFolder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    if (!child.getName().equals("META-INF")) {
                        this.resolveArchive(child, rtPath.append(child.getName()), vfs, monitor);
                    }
                    ++n2;
                }
            }
        }
        finally {
            earStruct.dispose();
        }
    }

    private void resolveArchive(IResource src, IPath rtPath, VirtualFileSystem vfs, IProgressMonitor monitor) throws ConflictingPathsException, CoreException {
        try {
            if (src.getType() == 2) {
                IFolder srcFolder = (IFolder)src.getAdapter(IFolder.class);
                IResource[] iResourceArray = srcFolder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    this.resolveArchive(child, rtPath.append(child.getName()), vfs, monitor);
                    ++n2;
                }
            } else if (src.getType() == 1 && (src.getName().endsWith(".jar") || src.getName().endsWith(".war") || src.getName().endsWith(".gar") || src.getName().endsWith(".rar"))) {
                vfs.link(src.getLocation().toString(), rtPath.makeRelative().toString());
            }
        }
        catch (CoreException ce) {
            String msg = CorePlugin.getString("errorPublishTaskArchive", new Object[0]);
            throw new CoreException(CorePlugin.createErrorStatus(msg, ce));
        }
    }

    private void generateApplicationEntries(IModule mod, VirtualFileSystem vfs, IProgressMonitor monitor) throws CoreException {
        StructureEdit earStruct = StructureEdit.getStructureEditForRead((IProject)mod.getProject());
        if (earStruct.getComponent() == null) {
            return;
        }
        try {
            try {
                EList resources = earStruct.getComponent().getResources();
                for (ComponentResource res : resources) {
                    IPath rtPath = res.getRuntimePath();
                    if (rtPath.equals((Object)WeblogicPublishTask.PATH_META_INF)) continue;
                    if (!rtPath.isRoot()) {
                        IPath srcPath = res.getSourcePath().makeRelative();
                        IPath projPath = mod.getProject().getLocation();
                        vfs.link(projPath.append(srcPath).toString(), rtPath.makeRelative().toString());
                        continue;
                    }
                    this.generateSpecialApplicationEntries(mod, res, vfs, monitor);
                }
            }
            catch (ConflictingPathsException cpe) {
                String msg = CorePlugin.getString("errorPublishTaskSplitSourceException", new Object[0]);
                throw new CoreException(CorePlugin.createErrorStatus(msg, cpe));
            }
            catch (RuntimeException re) {
                String msg = CorePlugin.getString("errorPublishProcessModule", new Object[0]);
                WeblogicPublishTask.LOG.log(CorePlugin.createErrorStatus(msg, re));
                earStruct.dispose();
            }
        }
        finally {
            earStruct.dispose();
        }
    }

    private void generateSpecialApplicationEntries(IModule mod, ComponentResource rootRes, VirtualFileSystem vfs, IProgressMonitor monitor) throws CoreException {
        try {
            IPath rtPath = rootRes.getRuntimePath();
            IPath srcPath = rootRes.getSourcePath();
            IPath projPath = mod.getProject().getLocation();
            srcPath = rootRes.getSourcePath().append(WeblogicPublishTask.PATH_APP_INF_CLASSES);
            rtPath = WeblogicPublishTask.PATH_APP_INF_CLASSES;
            vfs.link(projPath.append(srcPath).toString(), rtPath.makeRelative().toString());
        }
        catch (ConflictingPathsException cpe) {
            String msg = CorePlugin.getString("errorPublishTaskSplitSourceException", new Object[0]);
            throw new CoreException(CorePlugin.createErrorStatus(msg, cpe));
        }
    }

    private void generateDependentEntries(IWeblogicModule mod, IProject childProject, List<Entry> links, IProgressMonitor monitor) throws CoreException {
        IModule module = mod.getModule();
        IProject rootProject = module.getProject();
        IVirtualComponent c = ComponentCore.createComponent((IProject)childProject);
        IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider((IProject)rootProject);
        String uri = earModel.getModuleURI(c);
        Path base = null;
        base = childProject.equals((Object)rootProject) ? new Path("") : new Path(uri);
        IPath dirPath = ((IWeblogicDeployableModule)mod).getDeploymentPath();
        File earRoot = dirPath.toFile();
        this.generateChildModuleEntries(childProject, links, monitor, earRoot, (IPath)base, rootProject);
    }

    private void generateChildModuleEntries(IProject childProject, List<Entry> links, IProgressMonitor monitor, File virtualEarRoot, IPath base, IProject rootProject) throws CoreException {
        Map<IPath, IPath> javaBuildPath = JavaProjectUtil.isJavaProject((IProject)childProject) ? this.getJavaSourcePath(childProject) : new HashMap<IPath, IPath>();
        StructureEdit childStruct = StructureEdit.getStructureEditForRead((IProject)childProject);
        if (childStruct.getComponent() == null) {
            return;
        }
        try {
            try {
                IProjectFacet GAR_FACET;
                IFacetedProject facetProject = ProjectFacetsManager.create((IProject)childProject);
                if (facetProject.hasProjectFacet(FacetUtil.FACET_JST_UTE)) {
                    base = new Path("APP-INF/lib/").append(base);
                }
                EList res = childStruct.getComponent().getResources();
                for (ComponentResource childComp : res) {
                    Entry entry2;
                    IPath srcPath = childComp.getSourcePath().makeRelative();
                    IPath rtPath = childComp.getRuntimePath();
                    IPath path = null;
                    if (javaBuildPath.containsKey(srcPath)) {
                        srcPath = javaBuildPath.get(srcPath);
                        path = childProject.getLocation().append(srcPath);
                    } else {
                        String msg;
                        path = childProject.getLocation().append(srcPath);
                        IFolder fodler = childProject.getFolder(srcPath);
                        if (!fodler.isVirtual()) {
                            if (rtPath.toString().equals("/") || rtPath.toString().startsWith("/WEB-INF/classes") || rtPath.toString().equals("/lib")) {
                                path = new Path(fodler.getRawLocation().toPortableString());
                            } else {
                                msg = CorePlugin.getString("errorProcessSplitSrcMapping", fodler.getRawLocation(), rtPath);
                                msg = String.valueOf(msg) + CorePlugin.getString("splitSrcLinkedResourceToRoot", new Object[0]);
                                msg = String.valueOf(msg) + CorePlugin.getString("switchToExplodedArchiveMode", new Object[0]);
                                throw new CoreException(CorePlugin.createErrorStatus(msg));
                            }
                        }
                        if (fodler.isVirtual()) {
                            msg = CorePlugin.getString("errorProcessSplitSrcMapping", srcPath, rtPath);
                            msg = String.valueOf(msg) + CorePlugin.getString("virtualFolderNotSupportedInSplitSrc", new Object[0]);
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(msg));
                            msg = CorePlugin.getString("switchToExplodedArchiveMode", new Object[0]);
                            msg = stringBuilder.append(msg).toString();
                            throw new CoreException(CorePlugin.createErrorStatus(msg));
                        }
                        if (this.hasFilters((Resource)fodler)) {
                            msg = "Error procossing split source deployment mapping:" + srcPath + " = " + rtPath;
                            msg = String.valueOf(msg) + CorePlugin.getString("resourceFilterNotSupportedInSplitSrc", srcPath);
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(msg));
                            msg = CorePlugin.getString("switchToExplodedArchiveMode", new Object[0]);
                            msg = stringBuilder.append(msg).toString();
                            throw new CoreException(CorePlugin.createErrorStatus(msg));
                        }
                    }
                    Entry entry = new Entry(path, base, rtPath);
                    if (links.contains(entry) || rtPath.toString().equals("/WEB-INF/classes") && srcPath.toString().endsWith("/WEB-INF/classes")) continue;
                    links.add(entry);
                    if (!facetProject.hasProjectFacet(FacetUtil.FACET_JST_WEB)) continue;
                    Path weboutputPath = new Path(WeblogicPublishTask.getGeneratedWebRoot(childProject));
                    if (!rtPath.toString().equals("/") || links.contains(entry2 = new Entry((IPath)weboutputPath, base, rtPath))) continue;
                    links.add(entry2);
                }
                if (facetProject.hasProjectFacet(FacetUtil.FACET_JST_WEB)) {
                    this.generateWebInfLibEntries(childProject, virtualEarRoot, base, links, monitor);
                }
                if (facetProject.hasProjectFacet(FacetUtil.FACET_JST_UTE) || facetProject.hasProjectFacet(FacetUtil.FACET_JST_RAR) || facetProject.hasProjectFacet(FacetUtil.FACET_JST_EJB)) {
                    this.generateAppLibEntries(childProject, links);
                }
                if (facetProject.hasProjectFacet(GAR_FACET = ProjectFacetsManager.getProjectFacet((String)"oracle.coherence.gar"))) {
                    this.generateGarLibEntries(childProject, links, virtualEarRoot, base);
                }
            }
            catch (RuntimeException re) {
                String msg = CorePlugin.getString("errorPublishProcessModule", new Object[0]);
                WeblogicPublishTask.LOG.log(CorePlugin.createErrorStatus(msg, re));
                childStruct.dispose();
            }
        }
        finally {
            childStruct.dispose();
        }
    }

    private void generateGarLibEntries(IProject childProject, List<Entry> links, File virtualEarRoot, IPath base) {
        int n;
        Entry entry = null;
        IFolder libFolderPath = childProject.getFolder("/lib");
        File libFolder = libFolderPath.getLocation().toFile();
        if (libFolder.exists()) {
            File[] fileArray = libFolder.listFiles();
            n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                Entry entry2 = new Entry((IPath)new Path(f.getAbsolutePath()), base, (IPath)new Path("/lib/" + f.getName()));
                if (!links.contains(entry2)) {
                    links.add(entry2);
                    File targetPath = new File(String.valueOf(virtualEarRoot.getAbsolutePath()) + "/" + base.toPortableString() + "/lib/" + f.getName());
                    try {
                        oracle.eclipse.tools.common.util.fileio.FileUtil.copy((File)f, (File)targetPath);
                    }
                    catch (IOException ioe) {
                        WeblogicPublishTask.LOG.log(CorePlugin.createErrorStatus("Error copying GAR lib files to split source stage area", ioe));
                    }
                }
                ++n2;
            }
        }
        IVirtualComponent comp = ComponentCore.createComponent((IProject)childProject);
        IVirtualReference[] iVirtualReferenceArray = comp.getReferences();
        int n3 = iVirtualReferenceArray.length;
        n = 0;
        while (n < n3) {
            IVirtualReference ref = iVirtualReferenceArray[n];
            IVirtualComponent refComp = ref.getReferencedComponent();
            if (refComp instanceof VirtualArchiveComponent) {
                VirtualArchiveComponent archComp = (VirtualArchiveComponent)refComp;
                File file = archComp.getUnderlyingDiskFile();
                IPath jarPath = new Path("/lib/").append(file.getName());
                Path path1 = new Path(file.getAbsolutePath());
                entry = new Entry((IPath)path1, base, jarPath);
                if (!links.contains(entry)) {
                    links.add(entry);
                    try {
                        File targetPath = new File(String.valueOf(virtualEarRoot.getAbsolutePath()) + "/" + base.toPortableString() + "/" + jarPath.toPortableString());
                        oracle.eclipse.tools.common.util.fileio.FileUtil.copy((File)file, (File)targetPath);
                    }
                    catch (IOException ioe) {
                        WeblogicPublishTask.LOG.log(CorePlugin.createErrorStatus("Error copying GAR lib files to split source stage area", ioe));
                    }
                }
            }
            ++n;
        }
    }

    private void generateAppLibEntries(IProject childProject, List<Entry> links) throws CoreException {
        IVirtualComponent comp = ComponentCore.createComponent((IProject)childProject);
        IVirtualReference[] iVirtualReferenceArray = comp.getReferences();
        int n = iVirtualReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            IVirtualComponent refComp = ref.getReferencedComponent();
            if (refComp instanceof VirtualArchiveComponent) {
                VirtualArchiveComponent archComp = (VirtualArchiveComponent)refComp;
                File file = archComp.getUnderlyingDiskFile();
                IPath rtPath = new Path("APP-INF/lib/").append(file.getName());
                Path path = new Path(file.getAbsolutePath());
                Entry entry = new Entry((IPath)path, (IPath)new Path("/"), rtPath);
                if (!links.contains(entry)) {
                    links.add(entry);
                }
            } else if (refComp instanceof ClasspathContainerVirtualComponent) {
                ClasspathContainerVirtualComponent classPathComp = (ClasspathContainerVirtualComponent)refComp;
                IClasspathContainer cpc = classPathComp.getClasspathContainer();
                IClasspathEntry[] iClasspathEntryArray = cpc.getClasspathEntries();
                int n3 = iClasspathEntryArray.length;
                int path = 0;
                while (path < n3) {
                    IClasspathEntry cpe = iClasspathEntryArray[path];
                    String libName = cpe.getPath().lastSegment();
                    IPath rtPath = new Path("APP-INF/lib/").append(libName);
                    IPath path2 = cpe.getPath();
                    Entry entry = new Entry(path2, (IPath)new Path("/"), rtPath);
                    if (!links.contains(entry)) {
                        links.add(entry);
                    }
                    ++path;
                }
            } else if (refComp instanceof J2EEModuleVirtualComponent) {
                J2EEModuleVirtualComponent refModule = (J2EEModuleVirtualComponent)refComp;
                IProject refProj = refModule.getProject();
                Map<IPath, IPath> srcPathMap = this.getJavaSourcePath(refProj);
                for (IPath p : srcPathMap.values()) {
                    String libName = String.valueOf(refProj.getName()) + ".jar";
                    IPath rtPath = new Path("APP-INF/lib/").append(libName);
                    Entry entry = new Entry(refProj.getLocation().append(p), (IPath)new Path("/"), rtPath);
                    if (links.contains(entry)) continue;
                    links.add(entry);
                }
            }
            ++n2;
        }
    }

    private void generateWebInfLibEntries(IProject childProject, File virtualEarRoot, IPath base, List<Entry> links, IProgressMonitor monitor) throws CoreException {
        IPath compDeployPath;
        IVirtualComponent comp = ComponentCore.createComponent((IProject)childProject);
        File webInfLib = new File(new File(virtualEarRoot, base.toOSString()), WeblogicPublishTask.PATH_WEB_INF_LIB.toOSString());
        FileUtil.deleteDirectory(webInfLib, monitor);
        IVirtualReference[] iVirtualReferenceArray = comp.getReferences();
        int n = iVirtualReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            if (WtpProjectUtil.isWebInfLibReference((IVirtualReference)ref)) {
                IVirtualComponent refComp = ref.getReferencedComponent();
                if (refComp instanceof VirtualArchiveComponent) {
                    VirtualArchiveComponent archComp = (VirtualArchiveComponent)refComp;
                    File file = archComp.getUnderlyingDiskFile();
                    IPath mapPath = base.append(WeblogicPublishTask.PATH_WEB_INF_LIB).append(file.getName());
                    this.copyExternalLibEntries(virtualEarRoot, mapPath, file, links, monitor);
                } else if (refComp instanceof J2EEModuleVirtualComponent) {
                    J2EEModuleVirtualComponent j2eeComp = (J2EEModuleVirtualComponent)refComp;
                    compDeployPath = base;
                    this.generateWebUtilityEntries(virtualEarRoot, childProject, compDeployPath, j2eeComp.getProject(), links, monitor);
                } else if (refComp instanceof ClasspathContainerVirtualComponent) {
                    ClasspathContainerVirtualComponent classPathComp = (ClasspathContainerVirtualComponent)refComp;
                    IClasspathContainer cpc = classPathComp.getClasspathContainer();
                    IClasspathEntry[] iClasspathEntryArray = cpc.getClasspathEntries();
                    int n3 = iClasspathEntryArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry cpe = iClasspathEntryArray[n4];
                        String libName = cpe.getPath().lastSegment();
                        IPath rtPath = new Path("WEB-INF/lib/").append(libName);
                        IPath path = cpe.getPath();
                        Entry entry = new Entry(path, base, rtPath);
                        if (!links.contains(entry)) {
                            links.add(entry);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        IJavaProject proj = JavaCore.create((IProject)childProject);
        HashMap<String, String> mapClspathCompDep = ServerLaunchUtils.getClasspathComponentDependencies(proj);
        for (Map.Entry entry : mapClspathCompDep.entrySet()) {
            String libPath = (String)entry.getKey();
            String rtPath = (String)entry.getValue();
            compDeployPath = base.append((IPath)new Path(rtPath));
            URI dependentUri = URI.createFileURI((String)libPath);
            this.copyExternalLibEntries(virtualEarRoot, childProject, compDeployPath, dependentUri, links, monitor);
        }
    }

    public boolean hasFilters(Resource folder) {
        IProject project = folder.getProject();
        if (project == null) {
            return false;
        }
        ProjectDescription desc = ((Project)project).internalGetDescription();
        if (desc == null) {
            return false;
        }
        LinkedList filters = desc.getFilter(folder.getProjectRelativePath());
        if (filters != null && filters.size() > 0) {
            return true;
        }
        IContainer p = folder.getParent();
        ResourcesPlugin.getPlugin();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        while (p != root) {
            block7: {
                IResourceFilterDescription[] d = p.getFilters();
                if (d == null || d.length <= 0) break block7;
                return true;
            }
            try {
                p = p.getParent();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private void copyExternalLibEntries(File earRoot, IProject proj, IPath mapRoot, URI dependentUri, List<Entry> links, IProgressMonitor monitor) {
        int segmentCount = dependentUri.segmentCount();
        IPath mapPath = mapRoot.append(dependentUri.segment(segmentCount - 1));
        StringBuffer buf = new StringBuffer();
        if (dependentUri.isFile()) {
            buf.append(dependentUri.toFileString());
        } else {
            int i = 2;
            while (i < segmentCount) {
                buf.append(dependentUri.segment(i)).append("/");
                ++i;
            }
        }
        Path path = new Path(buf.toString());
        Entry entry = new Entry((IPath)path, mapPath, (IPath)Path.EMPTY);
        links.add(entry);
        File targetPath = new File(earRoot, mapPath.toOSString());
        if (!targetPath.exists()) {
            try {
                File jarFile;
                String serverTypeId = this._server.getServerType().getId();
                boolean isWls92Server = serverTypeId.equals("com.bea.wlw.server92");
                if (!isWls92Server && !this.hasTldFiles(jarFile = new File(path.toOSString()))) {
                    return;
                }
                if (!targetPath.getParentFile().exists()) {
                    targetPath.getParentFile().mkdirs();
                }
                oracle.eclipse.tools.common.util.fileio.FileUtil.copy((File)new File(path.toOSString()), (File)targetPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void copyExternalLibEntries(File earRoot, IPath mapPath, File sourcePath, List<Entry> links, IProgressMonitor monitor) {
        Path path = new Path(sourcePath.getAbsolutePath());
        Entry entry = new Entry((IPath)path, mapPath, (IPath)Path.EMPTY);
        links.add(entry);
        File targetPath = new File(earRoot, mapPath.toOSString());
        if (!targetPath.exists()) {
            try {
                File jarFile;
                String serverTypeId = this._server.getServerType().getId();
                boolean isWls92Server = serverTypeId.equals("com.bea.wlw.server92");
                if (!isWls92Server && !this.hasTldFiles(jarFile = new File(path.toOSString()))) {
                    return;
                }
                if (!targetPath.getParentFile().exists()) {
                    targetPath.getParentFile().mkdirs();
                }
                oracle.eclipse.tools.common.util.fileio.FileUtil.copy((File)new File(path.toOSString()), (File)targetPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean hasTldFiles(File jarFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void generateWebUtilityEntries(File virtualEarRoot, IProject proj, IPath mapRoot, IProject uteProj, List<Entry> links, IProgressMonitor monitor) throws CoreException {
        IPath mapPath = null;
        String serverTypeId = this._server.getServerType().getId();
        boolean isWls92Server = serverTypeId.equals("com.bea.wlw.server92");
        if (isWls92Server) {
            mapPath = mapRoot.append(WeblogicPublishTask.PATH_WEB_INF).append("classes");
        } else {
            String uteExt = FacetUtil.getResourceExtension(uteProj);
            mapPath = mapRoot.append(WeblogicPublishTask.PATH_WEB_INF).append("lib").append(String.valueOf(uteProj.getName()) + uteExt);
        }
        StructureEdit childStruct = StructureEdit.getStructureEditForRead((IProject)uteProj);
        if (!JavaProjectUtil.isJavaProject((IProject)uteProj) || childStruct.getComponent() == null) {
            return;
        }
        Map<IPath, IPath> javaBuildPath = this.getJavaSourcePath(uteProj);
        EList res = childStruct.getComponent().getResources();
        for (ComponentResource childComp : res) {
            IPath path;
            Entry entry;
            IPath srcPath = childComp.getSourcePath().makeRelative();
            IPath rtPath = childComp.getRuntimePath();
            if (javaBuildPath.containsKey(srcPath)) {
                srcPath = javaBuildPath.get(srcPath);
            }
            if (links.contains(entry = new Entry(path = uteProj.getLocation().append(srcPath), mapPath, rtPath))) continue;
            links.add(entry);
        }
        IVirtualComponent comp = ComponentCore.createComponent((IProject)uteProj);
        IVirtualReference[] iVirtualReferenceArray = comp.getReferences();
        int n = iVirtualReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                IVirtualComponent refComp;
                block12: {
                    File webAppRoot;
                    File targetPath;
                    IVirtualReference ref = iVirtualReferenceArray[n2];
                    refComp = ref.getReferencedComponent();
                    if (!(refComp instanceof VirtualArchiveComponent)) break block12;
                    VirtualArchiveComponent archComp = (VirtualArchiveComponent)refComp;
                    File file = archComp.getUnderlyingDiskFile();
                    IPath rtPath = WeblogicPublishTask.PATH_WEB_INF.append("lib").append(file.getName());
                    Path path = new Path(file.getAbsolutePath());
                    Entry entry = new Entry((IPath)path, mapRoot, rtPath);
                    if (links.contains(entry)) break block13;
                    links.add(entry);
                    if (!isWls92Server || (targetPath = new File(webAppRoot = new File(virtualEarRoot, mapRoot.toString()), rtPath.toString())).exists()) break block13;
                    try {
                        if (!targetPath.getParentFile().exists()) {
                            targetPath.getParentFile().mkdirs();
                        }
                        oracle.eclipse.tools.common.util.fileio.FileUtil.copy((File)file, (File)targetPath);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break block13;
                }
                if (refComp instanceof ClasspathContainerVirtualComponent) {
                    ClasspathContainerVirtualComponent classPathComp = (ClasspathContainerVirtualComponent)refComp;
                    IClasspathContainer cpc = classPathComp.getClasspathContainer();
                    IClasspathEntry[] iClasspathEntryArray = cpc.getClasspathEntries();
                    int n3 = iClasspathEntryArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry cpe = iClasspathEntryArray[n4];
                        String libName = cpe.getPath().lastSegment();
                        IPath rtPath = new Path("WEB-INF/lib/").append(libName);
                        IPath path = cpe.getPath();
                        Entry entry = new Entry(path, mapRoot, rtPath);
                        if (!links.contains(entry)) {
                            links.add(entry);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private Map<IPath, IPath> getJavaSourcePath(IProject childProject) throws CoreException {
        IJavaProject javaProj = JavaCore.create((IProject)childProject);
        if (javaProj == null) {
            return Collections.emptyMap();
        }
        IClasspathEntry[] entries = javaProj.getRawClasspath();
        HashMap<IPath, IPath> map = new HashMap<IPath, IPath>(entries.length);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 3) {
                IPath moduleSrc = entries[i].getPath().removeFirstSegments(1);
                IPath moduleOut = entries[i].getOutputLocation();
                if (moduleOut == null) {
                    moduleOut = javaProj.getOutputLocation();
                }
                moduleOut = moduleOut.removeFirstSegments(1);
                map.put(moduleSrc.makeRelative(), moduleOut.makeRelative());
            }
            ++i;
        }
        return map;
    }

    private void patchDependentEntries(List<Entry> links, IProgressMonitor monitor) {
        int i = links.size() - 1;
        while (i >= 0) {
            Entry entry = links.get(i);
            if (entry.destin.equals((Object)WeblogicPublishTask.PATH_WEB_INF)) {
                int j = i - 1;
                while (j >= 0) {
                    Entry findRoot = links.get(j);
                    if (findRoot.destin.equals((Object)WeblogicPublishTask.PATH_EMPTY)) {
                        links.remove(entry);
                        links.add(j, entry);
                        break;
                    }
                    --j;
                }
            } else if (entry.destin.equals((Object)Path.EMPTY)) break;
            --i;
        }
        i = 0;
        int end = links.size();
        while (i < end) {
            Entry entry = links.get(i);
            if (entry.destin.equals((Object)WeblogicPublishTask.PATH_WEB_INF)) {
                IPath newSource = entry.source.removeLastSegments(1);
                IPath newDestin = entry.destin.removeLastSegments(1);
                links.set(i, new Entry(newSource, entry.base, newDestin));
            } else if (entry.destin.equals((Object)Path.EMPTY)) break;
            ++i;
        }
    }

    private static final class Entry {
        private final IPath source;
        private final IPath base;
        private final IPath destin;

        public Entry(IPath source, IPath base, IPath destin) {
            this.source = source;
            this.base = base;
            this.destin = destin;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry that = (Entry)object;
            if (this.source != that.source) {
                if (this.source == null || that.source == null) {
                    return false;
                }
                if (!this.source.equals((Object)that.source)) {
                    return false;
                }
            }
            if (this.base != that.base) {
                if (this.base == null || that.base == null) {
                    return false;
                }
                if (!this.base.equals((Object)that.base)) {
                    return false;
                }
            }
            if (this.destin != that.destin) {
                if (this.destin == null || that.destin == null) {
                    return false;
                }
                if (!this.destin.equals((Object)that.destin)) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            return this.source == null ? 0 : this.source.hashCode();
        }

        public String toString() {
            return String.valueOf(this.source.toPortableString()) + "=" + this.base.toPortableString() + "/" + this.destin.toPortableString();
        }
    }
}

