/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IExternalProcess;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.server.internal.Paths;
import oracle.eclipse.tools.weblogic.server.internal.ServerConfiguration;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerRuntime;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.internal.core.StreamsProxy;
import org.eclipse.wst.server.core.IRuntime;

public class DomainConfigurator
implements IExternalProcess {
    protected static final String SEPARATOR = System.getProperties().getProperty("file.separator", "/");
    protected static final String TEMPLATE_PATH = "common" + SEPARATOR + "templates" + SEPARATOR + "domains";
    protected static final String BIN_PATH = "common" + SEPARATOR + "bin";
    protected static final String BIN_COMMAND = "config";
    protected IRuntime runtime;
    protected IWeblogicServerRuntime weblogic;

    public void initialize(IRuntime runtime, IProgressMonitor monitor) {
        runtime.hashCode();
        this.runtime = runtime;
        this.weblogic = (IWeblogicServerRuntime)runtime.loadAdapter(IWeblogicServerRuntime.class, monitor);
        this.weblogic.hashCode();
    }

    public IStatus validate() {
        if (this.runtime == null || this.weblogic == null) {
            String msg = CorePlugin.getString("errorServerConfigGeneral", new Object[0]);
            throw new IllegalStateException(msg);
        }
        IStatus status = this.weblogic.validate();
        if (!status.isOK()) {
            return status;
        }
        IPath path = this.runtime.getLocation();
        IPath binPath = path.append(BIN_PATH);
        status = Paths.validateNonEmptyDirectory(binPath);
        if (!status.isOK()) {
            return status;
        }
        status = Paths.validateShellScript(binPath, BIN_COMMAND);
        if (!status.isOK()) {
            return status;
        }
        String host = ServerConfiguration.getNonLoopbackLocalHost();
        if (host == null || host.trim().length() == 0) {
            String msg = CorePlugin.getString("errorServerConfigHostname", new Object[0]);
            return CorePlugin.createErrorStatus(msg);
        }
        return CorePlugin.STATUS_OK;
    }

    @Override
    public void apply(IProgressMonitor monitor) throws CoreException {
        try {
            IStatus status = this.validate();
            if (!status.isOK()) {
                CorePlugin.getLevelLog().logDebug(status.getMessage());
            }
            this.execute(monitor);
        }
        finally {
            monitor.done();
        }
    }

    private void execute(IProgressMonitor monitor) throws CoreException {
        monitor.subTask(CorePlugin.getString("msgWizardDomainConfig", new Object[0]));
        monitor.worked(5);
        DomainConfigurator.invoke(monitor, this.runtime);
        monitor.worked(65);
        monitor.done();
    }

    private static void invoke(IProgressMonitor monitor, IRuntime runtime) throws CoreException {
        IPath wlPath = runtime.getLocation();
        String wlHome = wlPath.toString();
        Object[] cmd = null;
        String command = String.valueOf(wlHome) + "/common/bin/" + BIN_COMMAND + "." + CorePlugin.getScriptExtension();
        File fmwHome = WlsRuntimeUtil.getMwHome(wlPath.toFile());
        if (new File(fmwHome, "oracle_common/common/bin").exists()) {
            command = String.valueOf(new File(fmwHome, "oracle_common/common/bin").getAbsolutePath()) + "/" + BIN_COMMAND + "." + CorePlugin.getScriptExtension();
        }
        if (CorePlugin.IS_WINDOWS) {
            cmd = new String[]{"cmd.exe", "/C", command, "-log", "config.log"};
        } else if (CorePlugin.IS_MACOSX) {
            cmd = new String[]{"sh", command};
        } else if (CorePlugin.IS_UNIX) {
            cmd = new String[]{"xterm", "-e", "sh", command};
        } else {
            String msg = CorePlugin.getString("errorWizardUnsupportedOS", Platform.getOS());
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        WeblogicServerRuntime rt = (WeblogicServerRuntime)runtime.loadAdapter(WeblogicServerRuntime.class, monitor);
        try {
            File execDir = new File(String.valueOf(wlHome) + SEPARATOR + BIN_PATH);
            String msg = "Launching WebLogic config wizard with command:" + Arrays.toString(cmd);
            msg = String.valueOf(msg) + "\nin directory " + execDir.getAbsolutePath();
            CorePlugin.getLevelLog().logInfo(msg);
            ProcessBuilder processBuilder = new ProcessBuilder((String[])cmd);
            processBuilder.directory(execDir);
            Map<String, String> env = processBuilder.environment();
            if (rt.getDefaultJavaVmLocation() == null) {
                String mwHome = WeblogicServerRuntime.getProperty(runtime, "MW_HOME");
                try {
                    String mwHomePath = new File(mwHome).getCanonicalPath();
                    env.put("MW_HOME", new File(mwHomePath).getCanonicalPath().replace('\\', '/'));
                    env.put("JAVA_HOME", rt.getJavaVmLocation().toPortableString());
                }
                catch (IOException iOException) {}
            }
            Process process = processBuilder.start();
            StreamsProxy proxy = new StreamsProxy(process, "UTF-8");
            IStreamListener startUpListener = new IStreamListener(){

                public void streamAppended(String text, IStreamMonitor monitor) {
                    boolean debug = false;
                    if (debug) {
                        System.out.println(text);
                    }
                }
            };
            proxy.getOutputStreamMonitor().addListener(startUpListener);
        }
        catch (IOException ioe) {
            throw new CoreException(CorePlugin.createErrorStatus(ioe.getMessage(), ioe));
        }
    }
}

