/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.CredentialInfo;
import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IWlsAdapterListener;
import oracle.eclipse.tools.weblogic.server.IWlsDeployRuntime;
import oracle.eclipse.tools.weblogic.server.IWlsRunnableWithProgress;
import oracle.eclipse.tools.weblogic.server.WlsDeployRuntimeFactory;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.ServerDelegate;

public class CredentialHelper {
    private final IPath domainPath;
    private final IPath weblogicPath;
    private final String serverName;
    private final IServer server;
    IJ2EEDeploymentHelper helper = null;
    private boolean existBootProps;
    private long lastModifiedDate;
    private CredentialInfo cred;

    private void initDomainInfoHelper() {
        if (this.server == null) {
            return;
        }
        this.helper = this.createPublisher();
    }

    private IJ2EEDeploymentHelper createPublisher() {
        IJ2EEDeploymentHelper h;
        block7: {
            IWlsDeployRuntime wlsDeployRuntime;
            IRuntime runtime;
            block6: {
                h = null;
                final IRuntime fruntime = runtime = this.server.getRuntime();
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = RuntimeBridgeUtil.bridge((IRuntime)runtime);
                if (facetRuntime == null) {
                    IWlsRunnableWithProgress op = new IWlsRunnableWithProgress(){

                        @Override
                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.setTaskName("Saving Weblogic runtime information");
                            try {
                                if (!(fruntime instanceof IRuntimeWorkingCopy)) {
                                    return;
                                }
                                IRuntimeWorkingCopy rwc = (IRuntimeWorkingCopy)fruntime;
                                rwc.save(true, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException coreException) {}
                            monitor.done();
                        }
                    };
                    IWlsAdapterListener adapter = WlsRuntimeUtil.getWlsAdapter();
                    if (adapter != null) {
                        adapter.run(op);
                    }
                }
                if ((wlsDeployRuntime = WlsDeployRuntimeFactory.create(runtime)) != null) break block6;
                CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("Cannot load DeploymentManager for " + runtime.toString()));
                return null;
            }
            h = wlsDeployRuntime.getJ2EEDeploymentHelper();
            if (h != null) break block7;
            CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus("Cannot load DeploymentManager for " + runtime.toString()));
            return null;
        }
        try {
            WeblogicServer wlsServer = (WeblogicServer)this.server.loadAdapter(ServerDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            h.initialize(wlsServer);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return h;
    }

    public CredentialHelper(IServer server, IPath weblogicPath, IPath domainPath, String serverName) throws CoreException {
        this.server = server;
        this.weblogicPath = weblogicPath;
        this.domainPath = domainPath;
        this.serverName = serverName;
        this.initDomainInfoHelper();
        this.parse();
    }

    public CredentialHelper(IServer server, IPath weblogicPath, String serverName, CredentialInfo cred) {
        this.domainPath = null;
        this.server = server;
        this.weblogicPath = weblogicPath;
        this.serverName = serverName;
        this.cred = cred;
    }

    public boolean isBootPropsFileExist() {
        return this.existBootProps;
    }

    public boolean isDetectionEnabled() {
        return this.helper != null;
    }

    public CredentialHelper refresh(IPath domain, String sname) throws CoreException {
        if (domain == null) {
            return this;
        }
        domain.hashCode();
        sname.hashCode();
        if (this.domainPath.equals((Object)domain) && this.serverName.equals(sname)) {
            return this.refresh();
        }
        return new CredentialHelper(this.server, this.weblogicPath, domain, sname);
    }

    public CredentialHelper refresh() throws CoreException {
        IPath securityDir = this.domainPath.append("servers").append(this.serverName).append("security");
        File bootPropFile = new File(securityDir.toFile(), "boot.properties");
        if (bootPropFile.exists() && this.lastModifiedDate == bootPropFile.lastModified()) {
            return this;
        }
        CredentialHelper result = new CredentialHelper(this.server, this.weblogicPath, this.domainPath, this.serverName);
        return result;
    }

    public CredentialInfo getCredential() {
        return this.cred;
    }

    private void parse() throws CoreException {
        if (!this.isDetectionEnabled()) {
            String msg = CorePlugin.getString("errorCredentialDetectCodeNotFound", new Object[0]);
            throw new CoreException(CorePlugin.createErrorStatus(msg));
        }
        IPath securityDir = this.domainPath.append("servers").append(this.serverName).append("security");
        File bootPropFile = new File(securityDir.toFile(), "boot.properties");
        if (bootPropFile.exists()) {
            this.existBootProps = true;
            this.lastModifiedDate = bootPropFile.lastModified();
        }
        if (this.existBootProps) {
            String username = this.helper.getAdminUsername(this.domainPath.toString(), this.serverName);
            String password = this.helper.getAdminPassword(this.domainPath.toString(), this.serverName);
            this.cred = new CredentialInfo(username, password);
        }
    }

    public IPath getDomainPath() {
        return this.domainPath;
    }
}

