/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.internal.PreparationOperation;
import oracle.eclipse.tools.weblogic.server.internal.Trace;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicEARModule;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.util.FacetUtil;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicDeployableModule;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import oracle.eclipse.tools.weblogic.server.model.WeblogicPublishOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.PublishUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.util.internal.FileUtil;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

class CopyPublishOperation
extends WeblogicPublishOperation {
    private static final int BUFFER = 65536;
    private static byte[] buf = new byte[65536];

    public CopyPublishOperation(IServer server) {
        super(CorePlugin.getString("msgPublishCopyTaskTitle", new Object[0]), CorePlugin.getString("msgPublishCopyTaskDesc", new Object[0]), server);
    }

    @Override
    public void processRootModule(IWeblogicModule mod, IProgressMonitor monitor) throws CoreException {
        if (mod.getKind() == 3) {
            return;
        }
        IModule rootModule = mod.getModule();
        if (rootModule instanceof DeletedModule) {
            return;
        }
        WeblogicServer weblogicServer = (WeblogicServer)this._server.loadAdapter(WeblogicServer.class, monitor);
        if (weblogicServer.isSplitSourceDeployment() && !WebLogicServerUtil.needWorkAroundForJSF20(this._server) && !FacetUtil.hasEjbFacet(rootModule)) {
            return;
        }
        if (weblogicServer.isRemote()) {
            return;
        }
        this.publishModule(mod, monitor);
    }

    private void publishModule(IWeblogicModule mod, IProgressMonitor monitor) throws CoreException {
        IModule module = mod.getModule();
        if (FacetUtil.hasEarFacet(module)) {
            this.publishEarModule(mod, monitor);
        } else if (FacetUtil.hasWebFacet(module) || FacetUtil.hasEjbFacet(module) || FacetUtil.hasConnectorFacet(module) || FacetUtil.hasWebLogicGarFacet(module)) {
            IPath deployPath = ((IWeblogicDeployableModule)mod).getDeploymentPath();
            this.publishStandAloneModule(mod, deployPath, monitor);
        }
    }

    private void publishEarModule(IWeblogicModule mod, IProgressMonitor monitor) throws CoreException {
        IModule[] modules;
        IModule earModule = mod.getModule();
        IPath earDeployPath = ((WeblogicEARModule)mod).getDeploymentPath();
        ProjectModule earPm = (ProjectModule)earModule.loadAdapter(ProjectModule.class, monitor);
        IModuleResource[] mr = earPm.members();
        PublishUtil.publishSmart((IModuleResource[])mr, (IPath)earDeployPath, (IProgressMonitor)monitor);
        this.handleEarProjectBinaryDependencies(earModule, earDeployPath);
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earModule.getProject());
        File metaInfFolder = new File(String.valueOf(earDeployPath.toPortableString()) + "/META-INF");
        PreparationOperation.createDefault50ApplicationXml(earModule, earComp, metaInfFolder);
        IEnterpriseApplication earApp = (IEnterpriseApplication)earModule.loadAdapter(IEnterpriseApplication.class, monitor);
        IModule[] iModuleArray = modules = earApp.getModules();
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule childModule = iModuleArray[n2];
            String uri = earApp.getURI(childModule);
            if (uri == null) {
                Status status = new Status(4, "oracle.eclipse.tools.weblogic", 0, "unable to assemble module null uri", null);
                throw new CoreException((IStatus)status);
            }
            IJ2EEModule jeeModule = (IJ2EEModule)childModule.loadAdapter(IJ2EEModule.class, monitor);
            if (jeeModule != null && jeeModule.isBinary()) {
                ProjectModule pm = (ProjectModule)childModule.loadAdapter(ProjectModule.class, null);
                IModuleResource[] resources = pm.members();
                if (uri.startsWith("/lib/")) {
                    String earLibPath = this.getEarLibPath();
                    PublishUtil.publishFull((IModuleResource[])resources, (IPath)earDeployPath.append(earLibPath), (IProgressMonitor)monitor);
                } else {
                    PublishUtil.publishFull((IModuleResource[])resources, (IPath)earDeployPath.append(uri).removeLastSegments(1), (IProgressMonitor)monitor);
                }
            } else if (FacetUtil.hasUtilityFacet(childModule)) {
                IPath childPath = earDeployPath.append(uri);
                IRuntime rt = this._server.getRuntime();
                if ("9.2".equals(rt.getRuntimeType().getVersion())) {
                    childPath = earDeployPath.append("APP-INF/classes");
                }
                ProjectModule childPm = (ProjectModule)childModule.loadAdapter(ProjectModule.class, monitor);
                IModuleResource[] memebers = childPm.members();
                PublishUtil.publishFull((IModuleResource[])memebers, (IPath)childPath, (IProgressMonitor)monitor);
                String targetFolder = earDeployPath.append(this.getEarLibPath()).toPortableString();
                ArrayList<File> ret = this.copyJarFilesOnDependencies(childModule, targetFolder);
                for (File file : ret) {
                    File f = new File(String.valueOf(earDeployPath.toOSString()) + "/" + file.getName());
                    if (!f.exists()) continue;
                    f.delete();
                }
            } else {
                IPath childDeployPath = earDeployPath.append(uri);
                ProjectModule childPm = (ProjectModule)childModule.loadAdapter(ProjectModule.class, monitor);
                PublishUtil.publishSmart((IModuleResource[])childPm.members(), (IPath)childDeployPath, (IProgressMonitor)monitor);
                if (FacetUtil.hasWebFacet(childModule)) {
                    IWebModule webModule = (IWebModule)childModule.loadAdapter(IWebModule.class, monitor);
                    IModule[] utilModules = webModule.getModules();
                    IModule[] iModuleArray2 = utilModules;
                    int n3 = utilModules.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModule m = iModuleArray2[n4];
                        if (FacetUtil.hasUtilityFacet(m)) {
                            IPath javaClassesPath = null;
                            if (FacetUtil.hasWebFacet(childModule)) {
                                javaClassesPath = childDeployPath.append("WEB-INF/classes");
                            }
                            ProjectModule pm = (ProjectModule)m.loadAdapter(ProjectModule.class, monitor);
                            PublishUtil.publishFull((IModuleResource[])pm.members(), (IPath)javaClassesPath, (IProgressMonitor)monitor);
                            String targetFolder = childDeployPath.append("WEB-INF/lib/").toPortableString();
                            this.copyJarFilesOnDependencies(m, targetFolder);
                        } else {
                            System.out.println("Module type not yet handled");
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private void handleEarProjectBinaryDependencies(IModule earModule, IPath earDeployPath) {
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earModule.getProject());
        IVirtualReference[] iVirtualReferenceArray = earComp.getReferences();
        int n = iVirtualReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualComponent childComp;
            IVirtualReference ref = iVirtualReferenceArray[n2];
            if (ref.getDependencyType() == 0 && (childComp = ref.getReferencedComponent()).isBinary() && childComp instanceof J2EEModuleVirtualArchiveComponent) {
                File targetFile;
                J2EEModuleVirtualArchiveComponent arch = (J2EEModuleVirtualArchiveComponent)childComp;
                File libFile = arch.getUnderlyingDiskFile().getAbsoluteFile();
                String targetFolder = this.getEarLibPath();
                if (WtpProjectUtil.isEjbModule((IProject)earModule.getProject(), (String)libFile.getName())) {
                    targetFolder = "/";
                }
                if (WtpProjectUtil.isEjbComponent((IVirtualComponent)childComp)) {
                    targetFolder = "/";
                }
                if (!(targetFile = new File(String.valueOf(earDeployPath.toPortableString()) + "/" + targetFolder + "/" + libFile.getName())).exists()) {
                    this.copyFile(libFile, targetFile);
                    File f = new File(String.valueOf(earDeployPath.toOSString()) + "/" + libFile.getName());
                    if (f.exists()) {
                        f.delete();
                    }
                }
            }
            ++n2;
        }
    }

    private String getEarLibPath() {
        IRuntime rt = this._server.getRuntime();
        if ("9.2".equals(rt.getRuntimeType().getVersion())) {
            return "APP-INF/lib";
        }
        return "lib";
    }

    private ArrayList<File> copyJarFilesOnDependencies(IModule childModule, String targetFolder) {
        ArrayList<File> jarFiles = new ArrayList<File>();
        IVirtualComponent comp = ComponentCore.createComponent((IProject)childModule.getProject());
        IVirtualReference[] iVirtualReferenceArray = comp.getReferences();
        int n = iVirtualReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualReference ref = iVirtualReferenceArray[n2];
            IVirtualComponent refComp = ref.getReferencedComponent();
            if (refComp instanceof VirtualArchiveComponent) {
                VirtualArchiveComponent archComp = (VirtualArchiveComponent)refComp;
                File jarFile = archComp.getUnderlyingDiskFile();
                String toFilePath = String.valueOf(targetFolder) + jarFile.getName();
                File toFile = new File(toFilePath);
                this.copyFile(jarFile, toFile);
                jarFiles.add(toFile);
            }
            ++n2;
        }
        return jarFiles;
    }

    private void publishStandAloneModule(IWeblogicModule mod, IPath deployPath, IProgressMonitor monitor) throws CoreException {
        File webXML;
        IModule module = mod.getModule();
        ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, monitor);
        IModuleResource[] mr = pm.members();
        PublishUtil.publishSmart((IModuleResource[])mr, (IPath)deployPath, (IProgressMonitor)monitor);
        if (FacetUtil.hasWebFacet(module) && !(webXML = new File(String.valueOf(deployPath.toPortableString()) + "/WEB-INF/web.xml")).exists()) {
            String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><web-app xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:web=\"http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd\" id=\"WebApp_ID\" version=\"2.5\"></web-app>";
            FileUtil.writeFile((File)webXML, (String)contents);
        }
        for (IWeblogicModule child : mod.getChildModules()) {
            IModule parent;
            IModule[] modulePath = child.getModulePath();
            if (modulePath == null || modulePath.length == 0 || modulePath.length != 2 || !(parent = modulePath[0]).getName().equals(module.getName()) || !FacetUtil.hasWebFacet(parent)) continue;
            IPath libPath = deployPath.append("WEB-INF").append("lib");
            this.publishJar(modulePath, libPath, monitor);
            IModule childModule = modulePath[modulePath.length - 1];
            String targetFolder = deployPath.append("WEB-INF/lib/").toPortableString();
            this.copyJarFilesOnDependencies(childModule, targetFolder);
        }
        mod.setRedeploy(true);
    }

    private void publishJar(IModule[] modulePath, IPath libPath, IProgressMonitor monitor) throws CoreException {
        IModule module = modulePath[1];
        File deployFolder = libPath.toFile();
        IPath jarPath = libPath.append(String.valueOf(module.getName()) + ".jar");
        if (!deployFolder.exists()) {
            deployFolder.mkdirs();
        }
        ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, monitor);
        IModuleResource[] mr = pm.members();
        PublishUtil.createZipFile((IModuleResource[])mr, (IPath)jarPath);
    }

    /*
     * Loose catch block
     */
    private IStatus copyFile(File from, File to) {
        long t2;
        long t1;
        if (to.exists() && (t1 = from.lastModified()) <= (t2 = to.lastModified())) {
            return Status.OK_STATUS;
        }
        to.getParentFile().mkdirs();
        FileInputStream in = null;
        FileOutputStream out = null;
        in = new FileInputStream(from);
        out = new FileOutputStream(to);
        int avail = ((InputStream)in).read(buf);
        while (avail > 0) {
            ((OutputStream)out).write(buf, 0, avail);
            avail = ((InputStream)in).read(buf);
        }
        IStatus iStatus = Status.OK_STATUS;
        try {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        catch (Exception exception) {}
        try {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
        catch (Exception exception) {}
        to.setLastModified(from.lastModified());
        return iStatus;
        catch (Exception e) {
            Status status;
            try {
                Trace.trace("/severe", "Error copying file", e);
                status = new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorCopyingFile, (Object[])new String[]{to.getAbsolutePath(), e.getLocalizedMessage()}), (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                }
                catch (Exception exception) {}
                to.setLastModified(from.lastModified());
                throw throwable;
            }
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (Exception exception) {}
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (Exception exception) {}
            to.setLastModified(from.lastModified());
            return status;
        }
    }

    public int getOrder() {
        return 15;
    }
}

