/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import oracle.eclipse.tools.weblogic.descriptors.IClassLoaderStructure;
import oracle.eclipse.tools.weblogic.descriptors.IModuleRef;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicEARModule;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.ElementList;

public class ClassloaderStructureHelper {
    private WeblogicEARModule earModule = null;
    private WlsClassLoader earAppClassLoader = null;

    public ClassloaderStructureHelper(IWeblogicModule earModule) {
        if (earModule instanceof WeblogicEARModule) {
            this.earModule = (WeblogicEARModule)earModule;
            this.earAppClassLoader = new WlsClassLoader(null);
            try {
                this.buildHierarchy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean hasCustomClassloaderStructure() {
        if (this.earAppClassLoader == null) {
            return false;
        }
        return this.earAppClassLoader.hasChildClassLoader();
    }

    public boolean hasCustomClassloader(String ejbModule) {
        if (this.earAppClassLoader == null) {
            return false;
        }
        WlsClassLoader wcl = this.earAppClassLoader.findModuleCustomClassLoader(ejbModule);
        return wcl != null;
    }

    public List<IWeblogicModule> findAffectedModules(String ejbModule) {
        ArrayList<IWeblogicModule> modules = new ArrayList<IWeblogicModule>();
        if (this.earAppClassLoader == null) {
            return modules;
        }
        ArrayList<String> ret = new ArrayList<String>();
        WlsClassLoader wcl = this.earAppClassLoader.findModuleCustomClassLoader(ejbModule);
        if (wcl != null) {
            wcl.findChildModules(ret);
        }
        for (String s : ret) {
            IWeblogicModule module = this.earModule.findChildModule(s);
            if (module == null) continue;
            modules.add(module);
        }
        return modules;
    }

    public boolean isUsingDefaultClassloader() {
        if (this.earAppClassLoader == null) {
            return true;
        }
        return !this.earAppClassLoader.hasChildClassLoader();
    }

    private void buildHierarchy() throws CoreException {
        IProject earProj = this.earModule.getModule().getProject();
        IWebLogicAppDescriptor desc = WebLogicDescriptorFactory.getAppDescriptor(earProj);
        if (desc == null) {
            return;
        }
        try {
            IClassLoaderStructure rootClassloader = (IClassLoaderStructure)desc.getClassLoaderStructure().content();
            if (rootClassloader == null) {
                return;
            }
            this.buildHierarchy(rootClassloader, this.earAppClassLoader);
            desc.dispose();
        }
        catch (Exception exception) {
            return;
        }
    }

    private void buildHierarchy(IClassLoaderStructure classloaderStructure, WlsClassLoader cl) {
        ElementList<IClassLoaderStructure> childClassLoaders = classloaderStructure.getChildClassLoaderStructures();
        for (IClassLoaderStructure child : childClassLoaders) {
            WlsClassLoader customClassLoader = new WlsClassLoader(cl);
            this.buildHierarchy(child, customClassLoader);
        }
        for (IModuleRef moduleRef : classloaderStructure.getModuleRefs()) {
            cl.addModule((String)moduleRef.getModuleUri().content());
        }
    }

    static class WlsClassLoader {
        private WlsClassLoader parent = null;
        List<WlsClassLoader> childClassLoaders = new ArrayList<WlsClassLoader>();
        LinkedHashMap<String, String> modules = new LinkedHashMap();

        public WlsClassLoader(WlsClassLoader parent) {
            this.parent = parent;
            if (this.parent != null) {
                this.parent.addChildClassLoader(this);
            }
        }

        public void addModule(String uri) {
            if (uri.endsWith(".jar") || uri.endsWith(".war")) {
                uri = uri.substring(0, uri.length() - 4);
            }
            this.modules.put(uri, "");
        }

        public void addChildClassLoader(WlsClassLoader cl) {
            this.childClassLoaders.add(cl);
        }

        public boolean hasChildClassLoader() {
            return this.childClassLoaders.size() > 0;
        }

        public WlsClassLoader findModuleCustomClassLoader(String moduleName) {
            if (this.modules.get(moduleName) != null) {
                return this;
            }
            for (WlsClassLoader cl : this.childClassLoaders) {
                WlsClassLoader c = cl.findModuleCustomClassLoader(moduleName);
                if (c == null) continue;
                return c;
            }
            return null;
        }

        public void findChildModules(ArrayList<String> list) {
            Iterator<String> it = this.modules.keySet().iterator();
            while (it.hasNext()) {
                list.add(it.next());
            }
            for (WlsClassLoader cl : this.childClassLoaders) {
                cl.findChildModules(list);
            }
        }
    }
}

