/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.debugger;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Map;
import oracle.eclipse.tools.weblogic.server.debugger.WeblogicDebugTarget;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdi.TimeoutException;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.SocketAttachConnector;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class WeblogicSocketAttachConnector
extends SocketAttachConnector {
    public String getIdentifier() {
        return "oracle.eclipse.tools.weblogic.server.debugger.socketAttachConnector";
    }

    public void connect(Map arguments, IProgressMonitor monitor, ILaunch launch) throws CoreException {
        String host;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.SocketAttachConnector_Connecting____1, 2);
        subMonitor.subTask(LaunchingMessages.SocketAttachConnector_Configuring_connection____1);
        AttachingConnector connector = WeblogicSocketAttachConnector.getAttachingConnector();
        String portNumberString = (String)arguments.get("port");
        if (portNumberString == null) {
            WeblogicSocketAttachConnector.abort((String)LaunchingMessages.SocketAttachConnector_Port_unspecified_for_remote_connection__2, null, (int)111);
        }
        if ((host = (String)arguments.get("hostname")) == null) {
            WeblogicSocketAttachConnector.abort((String)LaunchingMessages.SocketAttachConnector_Hostname_unspecified_for_remote_connection__4, null, (int)109);
        }
        Map<String, Connector.Argument> map = connector.defaultArguments();
        Connector.Argument param = map.get("hostname");
        param.setValue(host);
        param = map.get("port");
        param.setValue(portNumberString);
        String timeoutString = (String)arguments.get("timeout");
        if (timeoutString != null) {
            param = map.get("timeout");
            param.setValue(timeoutString);
        }
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        boolean allowTerminate = false;
        if (configuration != null) {
            allowTerminate = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        }
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.SocketAttachConnector_Establishing_connection____2);
        try {
            VirtualMachine vm = connector.attach(map);
            String vmLabel = this.constructVMLabel(vm, host, portNumberString, configuration);
            IDebugTarget debugTarget = WeblogicSocketAttachConnector.newDebugTarget(launch, vm, vmLabel, null, allowTerminate, true);
            launch.addDebugTarget(debugTarget);
            subMonitor.worked(1);
            subMonitor.done();
        }
        catch (TimeoutException e) {
            WeblogicSocketAttachConnector.abort((String)LaunchingMessages.SocketAttachConnector_0, (Throwable)e, (int)113);
        }
        catch (UnknownHostException e) {
            WeblogicSocketAttachConnector.abort((String)String.format(LaunchingMessages.SocketAttachConnector_Failed_to_connect_to_remote_VM_because_of_unknown_host____0___1, host), (Throwable)e, (int)113);
        }
        catch (ConnectException e) {
            WeblogicSocketAttachConnector.abort((String)LaunchingMessages.SocketAttachConnector_Failed_to_connect_to_remote_VM_as_connection_was_refused_2, (Throwable)e, (int)113);
        }
        catch (IOException e) {
            WeblogicSocketAttachConnector.abort((String)LaunchingMessages.SocketAttachConnector_Failed_to_connect_to_remote_VM_1, (Throwable)e, (int)113);
        }
        catch (IllegalConnectorArgumentsException e) {
            WeblogicSocketAttachConnector.abort((String)LaunchingMessages.SocketAttachConnector_Failed_to_connect_to_remote_VM_1, (Throwable)e, (int)113);
        }
    }

    public static IDebugTarget newDebugTarget(ILaunch launch, VirtualMachine vm, String name, IProcess process, boolean allowTerminate, boolean allowDisconnect) {
        return WeblogicSocketAttachConnector.newDebugTarget(launch, vm, name, process, allowTerminate, allowDisconnect, true);
    }

    public static IDebugTarget newDebugTarget(final ILaunch launch, final VirtualMachine vm, final String name, final IProcess process, final boolean allowTerminate, final boolean allowDisconnect, final boolean resume) {
        final IJavaDebugTarget[] target = new IJavaDebugTarget[1];
        IWorkspaceRunnable r = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) {
                target[0] = new WeblogicDebugTarget(launch, vm, name, allowTerminate, allowDisconnect, process, resume);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(r, null, 0, null);
        }
        catch (CoreException e) {
            JDIDebugPlugin.log((Throwable)e);
        }
        return target[0];
    }
}

