/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server.debugger;

import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.server.debugger.FastSwapPatternBreakpoint;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaMethodBreakpoint;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaTargetPatternBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;

public class WeblogicDebugTarget
extends JDIDebugTarget {
    private static final String STRING_BEA_VERSION = "_beaVersion";
    private List<JavaLineBreakpoint> fFastswapBreakpoints;

    public WeblogicDebugTarget(ILaunch launch, VirtualMachine jvm, String name, boolean supportTerminate, boolean supportDisconnect, IProcess process, boolean resume) {
        super(launch, jvm, name, supportTerminate, supportDisconnect, process, resume);
    }

    protected void initializeBreakpoints() {
        this.fFastswapBreakpoints = new ArrayList<JavaLineBreakpoint>();
        super.initializeBreakpoints();
    }

    public void reinstallBreakpoints() {
        this.removeAllBreakpoints();
        this.cleanUpFastswapBreakpoints();
        this.initializeBreakpoints();
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!this.isAvailable()) {
            return;
        }
        if (breakpoint instanceof FastSwapPatternBreakpoint) {
            return;
        }
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                JavaBreakpoint javaBreakpoint = (JavaBreakpoint)breakpoint;
                if (!this.getBreakpoints().contains(breakpoint)) {
                    if (!javaBreakpoint.shouldSkipBreakpoint()) {
                        javaBreakpoint.addToTarget((JDIDebugTarget)this);
                        IResource resource = javaBreakpoint.getMarker().getResource();
                        IProject proj = resource.getProject();
                        if (proj != null && WebLogicServerUtil.isFastSwapEnabled(proj)) {
                            this.addFastswapBreakpoint(javaBreakpoint);
                        }
                    }
                    this.getBreakpoints().add(breakpoint);
                }
            }
            catch (CoreException e) {
                this.logError((Exception)((Object)e));
            }
        }
    }

    private void addFastswapBreakpoint(JavaBreakpoint javaBreakpoint) {
        try {
            if (javaBreakpoint instanceof JavaLineBreakpoint) {
                if (javaBreakpoint instanceof JavaTargetPatternBreakpoint) {
                    return;
                }
                if (javaBreakpoint instanceof JavaMethodBreakpoint) {
                    return;
                }
                JavaLineBreakpoint javaLineBreakpoint = (JavaLineBreakpoint)javaBreakpoint;
                IResource resource = javaLineBreakpoint.getMarker().getResource();
                String sourceName = resource.getName();
                String typeName = javaLineBreakpoint.getTypeName();
                String pattern = String.valueOf(typeName) + STRING_BEA_VERSION;
                if (typeName.indexOf(36) > 0) {
                    pattern = String.valueOf(typeName.replace('$', '_')) + STRING_BEA_VERSION;
                }
                int lineNumber = javaLineBreakpoint.getLineNumber();
                int charStart = javaLineBreakpoint.getCharStart();
                int charEnd = javaLineBreakpoint.getCharEnd();
                int hitCount = javaLineBreakpoint.getHitCount();
                Map attributes = javaLineBreakpoint.getMarker().getAttributes();
                FastSwapPatternBreakpoint targetPatternBreakpoint = WeblogicDebugTarget.createFastSwapPatternBreakpoint(resource, sourceName, lineNumber, charStart, charEnd, hitCount, true, attributes);
                targetPatternBreakpoint.setPattern((IJavaDebugTarget)this, pattern);
                targetPatternBreakpoint.setEnabled(javaLineBreakpoint.isEnabled());
                targetPatternBreakpoint.addToTarget(this);
                this.getFastswapBreakpoints().add((JavaLineBreakpoint)targetPatternBreakpoint);
            }
        }
        catch (Exception exception) {}
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        super.breakpointRemoved(breakpoint, delta);
        try {
            if (breakpoint instanceof JavaLineBreakpoint) {
                if (breakpoint instanceof JavaTargetPatternBreakpoint) {
                    return;
                }
                if (breakpoint instanceof JavaMethodBreakpoint) {
                    return;
                }
                JavaLineBreakpoint javaLineBreakpoint = (JavaLineBreakpoint)breakpoint;
                IResource resource = javaLineBreakpoint.getMarker().getResource();
                String sourceName = resource.getName();
                Iterator<JavaLineBreakpoint> it = this.getFastswapBreakpoints().iterator();
                while (it.hasNext()) {
                    JavaLineBreakpoint brkPt = it.next();
                    if (!(brkPt instanceof JavaTargetPatternBreakpoint) || !((JavaTargetPatternBreakpoint)brkPt).getSourceName().equals(sourceName) || brkPt.getLineNumber() != javaLineBreakpoint.getLineNumber()) continue;
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)brkPt, true);
                    it.remove();
                }
            }
        }
        catch (Exception exception) {}
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        super.breakpointChanged(breakpoint, delta);
        try {
            if (breakpoint instanceof JavaLineBreakpoint) {
                if (breakpoint instanceof FastSwapPatternBreakpoint) {
                    return;
                }
                if (breakpoint instanceof JavaMethodBreakpoint) {
                    return;
                }
                JavaLineBreakpoint javaLineBreakpoint = (JavaLineBreakpoint)breakpoint;
                IResource resource = javaLineBreakpoint.getMarker().getResource();
                String sourceName = resource.getName();
                for (JavaLineBreakpoint brkPt : this.getFastswapBreakpoints()) {
                    if (!(brkPt instanceof JavaTargetPatternBreakpoint) || !((JavaTargetPatternBreakpoint)brkPt).getSourceName().equals(sourceName) || brkPt.getLineNumber() != javaLineBreakpoint.getLineNumber() || javaLineBreakpoint.isEnabled() == brkPt.isEnabled()) continue;
                    brkPt.setEnabled(javaLineBreakpoint.isEnabled());
                    DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged((IBreakpoint)brkPt);
                }
            }
        }
        catch (Exception exception) {}
    }

    protected void reinstallAllBreakpoints() {
        this.cleanUpFastswapBreakpoints();
        super.reinstallAllBreakpoints();
    }

    protected void cleanup() {
        super.cleanup();
        this.cleanUpFastswapBreakpoints();
    }

    protected void removeAllBreakpoints() {
        try {
            super.removeAllBreakpoints();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void cleanUpFastswapBreakpoints() {
        JavaTargetPatternBreakpoint[] brkPts = new JavaTargetPatternBreakpoint[this.fFastswapBreakpoints.size()];
        this.fFastswapBreakpoints.toArray(brkPts);
        try {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpoints((IBreakpoint[])brkPts, true);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.fFastswapBreakpoints.clear();
    }

    private List<JavaLineBreakpoint> getFastswapBreakpoints() {
        return this.fFastswapBreakpoints;
    }

    public static FastSwapPatternBreakpoint createFastSwapPatternBreakpoint(IResource resource, String sourceName, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes) throws CoreException {
        if (attributes == null) {
            attributes = new HashMap(10);
        }
        return new FastSwapPatternBreakpoint(resource, sourceName, lineNumber, charStart, charEnd, hitCount, register, attributes);
    }
}

