/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import oracle.eclipse.tools.common.util.fileio.virtualfs.ConflictingPathsException;
import oracle.eclipse.tools.common.util.fileio.virtualfs.VirtualFileSystem;

public final class VirtualEarManager {
    private static final String FILE_NAME = ".beabuild.txt";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String MALFORMED_DESCRIPTOR = "Cannot parse .beabuild.txt file. It appears to be corrupted.";
    private static final String ENCODING = "8859_1";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private VirtualEarManager() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VirtualFileSystem readDescriptor(File earRootDir) throws IOException, ConflictingPathsException {
        VirtualFileSystem vfs = new VirtualFileSystem();
        File f = new File(earRootDir, FILE_NAME);
        if (!f.exists()) return vfs;
        FileInputStream in = new FileInputStream(f);
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)in, ENCODING));
        try {
            int state = 1;
            StringBuffer source = null;
            StringBuffer target = null;
            int ch = ((Reader)r).read();
            while (ch != -1) {
                if (ch == 10 || ch == 13) {
                    if (state == 3) {
                        vfs.link(VirtualEarManager.unescape(source.toString().trim()), VirtualEarManager.unescape(target.toString().trim()));
                        state = 1;
                    } else if (state == 2) {
                        throw new IOException(MALFORMED_DESCRIPTOR);
                    }
                } else if (ch == 61) {
                    if (state != 2) throw new IOException(MALFORMED_DESCRIPTOR);
                    target = new StringBuffer();
                    state = 3;
                } else if (state == 1) {
                    source = new StringBuffer();
                    source.append((char)ch);
                    state = 2;
                } else if (state == 2) {
                    source.append((char)ch);
                } else {
                    target.append((char)ch);
                }
                ch = ((Reader)r).read();
            }
            if (state == 3) {
                vfs.link(VirtualEarManager.unescape(source.toString().trim()), VirtualEarManager.unescape(target.toString().trim()));
            } else if (state == 2) {
                throw new IOException(MALFORMED_DESCRIPTOR);
            }
        }
        catch (Throwable throwable) {
            try {
                ((Reader)r).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Reader)r).close();
            return vfs;
        }
        catch (IOException iOException) {}
        return vfs;
    }

    public static void writeDescriptor(File earRootDir, VirtualFileSystem vfs) throws IOException {
        StringBuffer buf = new StringBuffer();
        VirtualFileSystem.Link[] linkArray = vfs.search(null, null);
        int n = linkArray.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualFileSystem.Link link = linkArray[n2];
            buf.append(VirtualEarManager.escape(link.getSourcePath()));
            buf.append(" = ");
            buf.append(VirtualEarManager.escape(link.getTargetPath()));
            buf.append(LINE_SEPARATOR);
            ++n2;
        }
        File f = new File(earRootDir, FILE_NAME);
        FileOutputStream out = new FileOutputStream(f);
        try {
            ((OutputStream)out).write(buf.toString().getBytes(ENCODING));
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String escape(String str) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int n = str.length();
        while (i < n) {
            char ch = str.charAt(i);
            if (ch > '=' && ch < '\u007f') {
                if (ch == '\\') {
                    buf.append('\\');
                }
                buf.append(ch);
            } else {
                switch (ch) {
                    case '\t': {
                        buf.append("\\t");
                        break;
                    }
                    case '\n': {
                        buf.append("\\n");
                        break;
                    }
                    case '\r': {
                        buf.append("\\r");
                        break;
                    }
                    case '\f': {
                        buf.append("\\f");
                        break;
                    }
                    case ' ': 
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': {
                        buf.append('\\');
                        buf.append(ch);
                        break;
                    }
                    default: {
                        if (ch < ' ' || ch > '~') {
                            buf.append('\\');
                            buf.append('u');
                            buf.append(HEX_DIGITS[ch >> 12 & 0xF]);
                            buf.append(HEX_DIGITS[ch >> 8 & 0xF]);
                            buf.append(HEX_DIGITS[ch >> 4 & 0xF]);
                            buf.append(HEX_DIGITS[ch & 0xF]);
                            break;
                        }
                        buf.append(ch);
                    }
                }
            }
            ++i;
        }
        return buf.toString();
    }

    private static String unescape(String str) {
        StringBuilder buf = new StringBuilder();
        int length = str.length();
        int i = 0;
        while (i < length) {
            int ch;
            if ((ch = str.charAt(i++)) == 92) {
                if ((ch = str.charAt(i++)) == 117) {
                    int value = 0;
                    int j = 0;
                    while (j < 4) {
                        ch = str.charAt(i++);
                        value <<= 4;
                        switch (ch) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value += ch - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value += 10 + ch - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value += 10 + ch - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid \\uxxxx encoding.");
                            }
                        }
                        ++j;
                    }
                    buf.append((char)value);
                    continue;
                }
                if (ch == 116) {
                    ch = 9;
                } else if (ch == 114) {
                    ch = 13;
                } else if (ch == 110) {
                    ch = 10;
                } else if (ch == 102) {
                    ch = 12;
                }
                buf.append((char)ch);
                continue;
            }
            buf.append((char)ch);
        }
        return buf.toString();
    }
}

