/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.migration.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WlsRuntimeComponentType;
import oracle.eclipse.tools.weblogic.migration.internal.FacetMigrationAction;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.server.core.IRuntime;

public final class FacetMigrationActionExtensionReader {
    private static final String EXTENSION_POINT_ID = "runtimeFacetMigration";
    private static final String EL_INSTALL_ACTION = "install";
    private static final String EL_UNINSTALL_ACTION = "uninstall";
    private static final String EL_VERSION_CHANGE_ACTION = "version-change";
    private static final String EL_MIGRATION = "migration";
    private static final String EL_ENABLEMENT = "enablement";
    private static final String ATTR_WLS_RUNTIME_VERSION = "wls-version";
    private static final String ATTR_FACET_ID = "facet";
    private static final String ATTR_FACET_VERSION = "version";
    private final Map<IRuntimeComponentVersion, List<FacetMigrationAction>> runtimeActionMap = new HashMap<IRuntimeComponentVersion, List<FacetMigrationAction>>();

    public FacetMigrationActionExtensionReader() {
        this.readExtensions();
    }

    private void readExtensions() {
        Collection extensions = PluginUtil.findExtensions((String)"oracle.eclipse.tools.weblogic", (String)EXTENSION_POINT_ID);
        Collection cfgels = PluginUtil.getTopLevelElements((Collection)extensions);
        for (IConfigurationElement element : cfgels) {
            if (!element.getName().equals(EL_MIGRATION)) continue;
            try {
                FacetMigrationAction action = new FacetMigrationAction();
                action.setPluginId(element.getContributor().getName());
                String wlsVersionString = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_WLS_RUNTIME_VERSION);
                IRuntimeComponentVersion wlsVersion = null;
                if (!WlsRuntimeComponentType.INSTANCE.hasVersion(wlsVersionString)) {
                    String msg = Resources.bind((String)Resources.invalidWlsVersion, (Object)wlsVersionString, (Object)action.getPluginId());
                    LoggingService.logError((String)"oracle.eclipse.tools.weblogic", (String)msg);
                    throw new PluginUtil.InvalidExtensionException();
                }
                wlsVersion = WlsRuntimeComponentType.INSTANCE.getVersion(wlsVersionString);
                IConfigurationElement[] iConfigurationElementArray = element.getChildren();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement child = iConfigurationElementArray[n2];
                    String childName = child.getName();
                    if (childName.equals(EL_ENABLEMENT)) {
                        Expression expr;
                        try {
                            expr = ExpressionConverter.getDefault().perform(child);
                        }
                        catch (CoreException e) {
                            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)e);
                            throw new PluginUtil.InvalidExtensionException();
                        }
                        action.setEnablementCondition(expr);
                    } else if (childName.equals(EL_INSTALL_ACTION) || childName.equals(EL_UNINSTALL_ACTION) || childName.equals(EL_VERSION_CHANGE_ACTION)) {
                        IFacetedProject.Action.Type actionType;
                        IProjectFacet facet = null;
                        String facetString = PluginUtil.findRequiredAttribute((IConfigurationElement)child, (String)ATTR_FACET_ID);
                        if (!ProjectFacetsManager.isProjectFacetDefined((String)facetString)) {
                            String msg = Resources.bind((String)Resources.invalidFacetId, (Object)facetString, (Object)action.getPluginId());
                            LoggingService.logError((String)"oracle.eclipse.tools.weblogic", (String)msg);
                            throw new PluginUtil.InvalidExtensionException();
                        }
                        facet = ProjectFacetsManager.getProjectFacet((String)facetString);
                        IProjectFacetVersion facetVersion = null;
                        String facetVersionString = child.getAttribute(ATTR_FACET_VERSION);
                        if (facetVersionString != null) {
                            if (!facet.hasVersion(facetVersionString)) {
                                String msg = Resources.bind((String)Resources.invalidFacetVersion, (Object)facetVersionString, (Object)action.getPluginId());
                                LoggingService.logError((String)"oracle.eclipse.tools.weblogic", (String)msg);
                                throw new PluginUtil.InvalidExtensionException();
                            }
                            facetVersion = facet.getVersion(facetVersionString);
                        }
                        try {
                            actionType = IFacetedProject.Action.Type.valueOf((String)childName);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            String msg = Resources.bind((String)Resources.invalidActionType, (Object)childName, (Object)action.getPluginId());
                            LoggingService.logError((String)"oracle.eclipse.tools.weblogic", (String)msg);
                            throw new PluginUtil.InvalidExtensionException();
                        }
                        action.addFacetAction(new FacetMigrationAction.ActionType(facet, facetVersion, actionType));
                    }
                    ++n2;
                }
                List<FacetMigrationAction> actionList = this.runtimeActionMap.get(wlsVersion);
                if (actionList == null) {
                    actionList = new ArrayList<FacetMigrationAction>();
                    this.runtimeActionMap.put(wlsVersion, actionList);
                }
                actionList.add(action);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }

    public List<FacetMigrationAction> getActionsFor(IProject project, IRuntime runtime) {
        List<FacetMigrationAction> actions = this.runtimeActionMap.get(WlsRuntimeComponentType.convert(runtime.getRuntimeType()));
        ArrayList<FacetMigrationAction> enabledActions = new ArrayList<FacetMigrationAction>(actions.size());
        for (FacetMigrationAction action : actions) {
            if (!action.isEnabledFor(project)) continue;
            enabledActions.add(action);
        }
        return enabledActions;
    }

    private static final class Resources
    extends NLS {
        public static String invalidActionType;
        public static String invalidFacetId;
        public static String invalidFacetVersion;
        public static String invalidWlsVersion;

        static {
            Resources.initializeMessages((String)FacetMigrationActionExtensionReader.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

