/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.jdbc;

import java.util.SortedMap;
import java.util.TreeMap;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.jdbc.IJDBCDbInfoFactory;
import oracle.eclipse.tools.weblogic.server.IWlsDeployRuntime;
import oracle.eclipse.tools.weblogic.server.WlsDeployRuntimeFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sapphire.Version;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.server.core.ServerCore;

public class JDBCInfoFactoryUtil {
    public static synchronized IJDBCDbInfoFactory findJDBCDbInfoFactory(IRuntime rt) {
        IJDBCDbInfoFactory factory = null;
        IWlsDeployRuntime runtime = WlsDeployRuntimeFactory.create(rt);
        if (runtime != null) {
            factory = runtime.getJDBCDbInfoFactory();
        }
        return factory;
    }

    public static synchronized IJDBCDbInfoFactory findJDBCDbInfoFactory(IProject project, Version targetServerVersionEx) {
        org.eclipse.wst.server.core.IRuntime targetWlsRuntime = null;
        if (project != null && targetServerVersionEx != null) {
            try {
                WebLogicServerVersion targetServerVersion = WebLogicServerVersion.convert(targetServerVersionEx);
                IFacetedProject facetedProj = ProjectFacetsManager.create((IProject)project);
                if (targetServerVersion == null || facetedProj == null) {
                    targetWlsRuntime = JDBCInfoFactoryUtil.findWorkspaceRuntime(targetServerVersion);
                } else {
                    IRuntime rt = facetedProj.getPrimaryRuntime();
                    if (rt != null) {
                        WebLogicServerVersion wlsVersion = JDBCInfoFactoryUtil.getWlsRuntimeVersion(rt);
                        if (wlsVersion.getVersionString().equals(targetServerVersion.getVersionString())) {
                            return JDBCInfoFactoryUtil.findJDBCDbInfoFactory(rt);
                        }
                        targetWlsRuntime = JDBCInfoFactoryUtil.findWorkspaceRuntime(targetServerVersion);
                    } else {
                        targetWlsRuntime = JDBCInfoFactoryUtil.findWorkspaceRuntime(targetServerVersion);
                    }
                }
            }
            catch (CoreException ce) {
                LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (CoreException)ce);
            }
        }
        if (targetWlsRuntime != null) {
            return JDBCInfoFactoryUtil.findJDBCDbInfoFactory(RuntimeBridgeUtil.bridge(targetWlsRuntime));
        }
        return null;
    }

    public static WebLogicServerVersion getWlsRuntimeVersion(IRuntime rt) {
        IRuntimeComponent wlsRuntimeComponent;
        WebLogicServerVersion wlsVersion = null;
        if (WlsRuntimeUtil.isWlsRuntime(rt) && (wlsRuntimeComponent = WlsRuntimeUtil.getWlsRuntimeComponent(rt)) != null) {
            IRuntimeComponentVersion rcv = wlsRuntimeComponent.getRuntimeComponentVersion();
            wlsVersion = WebLogicServerVersion.convert(rcv.getVersionString());
        }
        return wlsVersion;
    }

    private static org.eclipse.wst.server.core.IRuntime findWorkspaceRuntime(WebLogicServerVersion targetWlsVersion) {
        TreeMap<Version, org.eclipse.wst.server.core.IRuntime> wlsVersions = new TreeMap<Version, org.eclipse.wst.server.core.IRuntime>();
        org.eclipse.wst.server.core.IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.eclipse.wst.server.core.IRuntime r = iRuntimeArray[n2];
            WebLogicServerVersion wlsVersion = JDBCInfoFactoryUtil.getWlsRuntimeVersion(RuntimeBridgeUtil.bridge((org.eclipse.wst.server.core.IRuntime)r));
            if (wlsVersion != null) {
                if (wlsVersion.equals((Object)targetWlsVersion)) {
                    return r;
                }
                wlsVersions.put(new Version(wlsVersion.getVersionString()), r);
            }
            ++n2;
        }
        if (!wlsVersions.isEmpty()) {
            SortedMap tail = wlsVersions.tailMap(new Version(targetWlsVersion.getVersionString()));
            if (!tail.isEmpty()) {
                return (org.eclipse.wst.server.core.IRuntime)tail.get(tail.firstKey());
            }
            return (org.eclipse.wst.server.core.IRuntime)wlsVersions.get(wlsVersions.lastKey());
        }
        return null;
    }
}

