/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib.provider;

import java.lang.ref.WeakReference;
import java.util.Map;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.j2eelib.AmbiguousReferenceException;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRegistry;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.j2eelib.UnresolvableReferenceException;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class SharedLibraryProviderInstallOperationConfig
extends LibraryProviderOperationConfig {
    private static final String CLASS_NAME = SharedLibraryProviderInstallOperationConfig.class.getName();
    public static final String PROP_REGISTRY = String.valueOf(CLASS_NAME) + ".REGISTRY";
    public static final String PROP_LIBRARY_NAME = String.valueOf(CLASS_NAME) + ".LIBRARY_NAME";
    public static final String PROP_SPECIFICATION_VERSION = String.valueOf(CLASS_NAME) + ".SPECIFICATION_VERSION";
    public static final String PROP_IMPLEMENTATION_VERSION = String.valueOf(CLASS_NAME) + ".IMPLEMENTATION_VERSION";
    public static final String PROP_ALLOW_NEWER_VERSIONS = String.valueOf(CLASS_NAME) + ".ALLOW_NEWER_VERSIONS";
    private static final String PARAM_LIBRARY_NAME = "library.name";
    private static final String PARAM_SPEC_VERSION = "library.spec.version";
    private static final String PARAM_IMPL_VERSION = "library.impl.version";
    private static final String PARAM_ALLOW_NEWER = "library.allow.newer";
    private final LibraryModuleRegistry registry = LibraryModulesSvc.getRegistry();
    private final RegistryListener registryListener = new RegistryListener(this);
    private String libraryName = null;
    private Version specVersion = null;
    private Version implVersion = null;
    private boolean allowNewerVersions = false;

    public SharedLibraryProviderInstallOperationConfig() {
        this.registry.addListener(this.registryListener);
    }

    public synchronized void init(IFacetedProjectBase fproj, IProjectFacetVersion fv, ILibraryProvider provider) {
        super.init(fproj, fv, provider);
        Map params = provider.getParams();
        this.libraryName = (String)params.get(PARAM_LIBRARY_NAME);
        this.specVersion = SharedLibraryProviderInstallOperationConfig.parseVersion((String)params.get(PARAM_SPEC_VERSION));
        this.implVersion = SharedLibraryProviderInstallOperationConfig.parseVersion((String)params.get(PARAM_IMPL_VERSION));
        this.allowNewerVersions = SharedLibraryProviderInstallOperationConfig.parseBoolean((String)params.get(PARAM_ALLOW_NEWER));
    }

    public final LibraryModuleRegistry getRegistry() {
        return this.registry;
    }

    public final synchronized String getLibraryName() {
        return this.libraryName;
    }

    protected final synchronized void setLibraryName(String libraryName) {
        String oldLibraryName = this.libraryName;
        this.libraryName = libraryName;
        this.notifyListeners(PROP_LIBRARY_NAME, oldLibraryName, this.libraryName);
    }

    public final synchronized Version getSpecificationVersion() {
        return this.specVersion;
    }

    protected final synchronized void setSpecificationVersion(Version version) {
        Version oldSpecVersion = this.specVersion;
        this.specVersion = version;
        this.notifyListeners(PROP_SPECIFICATION_VERSION, oldSpecVersion, this.specVersion);
    }

    public final synchronized Version getImplementationVersion() {
        return this.implVersion;
    }

    protected final synchronized void setImplementationVersion(Version version) {
        Version oldImplVersion = this.implVersion;
        this.implVersion = version;
        this.notifyListeners(PROP_IMPLEMENTATION_VERSION, oldImplVersion, this.implVersion);
    }

    public final synchronized boolean getAllowNewerVersions() {
        return this.allowNewerVersions;
    }

    protected final synchronized void setAllowNewerVersions(boolean allowNewerVersions) {
        Boolean oldAllowNewerVersions = this.allowNewerVersions;
        Boolean newAllowNewerVersions = allowNewerVersions;
        this.allowNewerVersions = allowNewerVersions;
        this.notifyListeners(PROP_ALLOW_NEWER_VERSIONS, oldAllowNewerVersions, newAllowNewerVersions);
    }

    public synchronized IStatus validate() {
        IStatus st = Status.OK_STATUS;
        if (this.libraryName == null) {
            st = WlsCorePlugin.createErrorStatus(Resources.libraryNameNeedsToBeSet);
        } else {
            LibraryModuleRef ref = new LibraryModuleRef(this.libraryName, this.specVersion, this.implVersion, this.allowNewerVersions);
            try {
                this.registry.resolve(ref);
            }
            catch (UnresolvableReferenceException unresolvableReferenceException) {
                String msg = Resources.bind((String)Resources.libraryNotFound, (Object)this.libraryName);
                st = WlsCorePlugin.createErrorStatus(msg);
            }
            catch (AmbiguousReferenceException ambiguousReferenceException) {
                String msg = Resources.bind((String)Resources.libraryAmbiguous, (Object)this.libraryName);
                st = WlsCorePlugin.createErrorStatus(msg);
            }
        }
        return st;
    }

    protected void finalize() {
        this.registry.removeListener(this.registryListener);
    }

    protected static final Version parseVersion(String version) {
        if (version == null) {
            return null;
        }
        return new Version(version);
    }

    protected static final boolean parseBoolean(String value) {
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    private static final class RegistryListener
    implements LibraryModuleRegistry.IListener {
        private final WeakReference<SharedLibraryProviderInstallOperationConfig> opConfigWeakRef;

        public RegistryListener(SharedLibraryProviderInstallOperationConfig config) {
            this.opConfigWeakRef = new WeakReference<SharedLibraryProviderInstallOperationConfig>(config);
        }

        @Override
        public void registryChanged() {
            SharedLibraryProviderInstallOperationConfig opConfig = (SharedLibraryProviderInstallOperationConfig)((Object)this.opConfigWeakRef.get());
            if (opConfig != null) {
                LibraryModuleRegistry registry = opConfig.getRegistry();
                opConfig.notifyListeners(PROP_REGISTRY, registry, registry);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String libraryNameNeedsToBeSet;
        public static String libraryNotFound;
        public static String libraryAmbiguous;

        static {
            Resources.initializeMessages((String)SharedLibraryProviderInstallOperationConfig.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

