/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib.internal.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.util.MutableReference;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.j2eelib.AmbiguousReferenceException;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.j2eelib.UnresolvableReferenceException;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.AmbiguousReferenceLibraryProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.ClasspathAndDescriptorRefsDoNotMatchProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.IProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.MustBePartOfEarToUseLibProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.MustBePartOfWebAppToUseLibProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.NonWebLibRefInWebDescriptorProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.RefOnClasspathButNotInDescriptorProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.UnableToResolveLibraryProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.WebLibRefInNonWebProjectProblem;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class J2EELibraryFrameworkValidator
extends IncrementalProjectBuilder {
    private static final Set<String> TRIGGER_FILES = new HashSet<String>();

    static {
        TRIGGER_FILES.add(".classpath");
        TRIGGER_FILES.add("weblogic.xml");
        TRIGGER_FILES.add("weblogic-application.xml");
        TRIGGER_FILES.add(".component");
        TRIGGER_FILES.add("org.eclipse.wst.common.component");
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask(Resources.taskDescription, 1);
        }
        try {
            boolean shouldValidate = false;
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                shouldValidate = true;
            } else {
                MutableReference visitorResult = new MutableReference((Object)Boolean.FALSE);
                final class Visitor
                implements IResourceDeltaVisitor {
                    private final /* synthetic */ MutableReference val$visitorResult;

                    Visitor(MutableReference mutableReference) {
                        this.val$visitorResult = mutableReference;
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (this.val$visitorResult.get() == Boolean.TRUE) {
                            return false;
                        }
                        IResource resource = delta.getResource();
                        if (resource.getType() == 1) {
                            if (TRIGGER_FILES.contains(resource.getName())) {
                                this.val$visitorResult.set((Object)Boolean.TRUE);
                            }
                            return false;
                        }
                        return true;
                    }
                }
                delta.accept((IResourceDeltaVisitor)new Visitor(visitorResult));
                shouldValidate = (Boolean)visitorResult.get();
            }
            if (shouldValidate) {
                IProject project = this.getProject();
                J2EELibraryFrameworkValidator.validate(project);
                if (WtpProjectUtil.isEarProject((IProject)project)) {
                    for (IProject refProject : WtpProjectUtil.findProjectsReferencedByEar((IProject)project)) {
                        J2EELibraryFrameworkValidator.validate(refProject);
                    }
                }
            }
            IProject[] iProjectArray = new IProject[]{};
            return iProjectArray;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static void validate(IProject project) throws CoreException {
        IProblem problem;
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        if (fproj == null) {
            return;
        }
        HashSet<IProblem> problems = new HashSet<IProblem>();
        List<LibraryModuleRef> cpRefs = LibraryModulesSvc.getClasspathReferences(project);
        List<LibraryModuleRef> descRefs = LibraryModulesSvc.getDescriptorReferences(project);
        for (LibraryModuleRef libref : cpRefs) {
            problem = J2EELibraryFrameworkValidator.validateLibraryRefOnClasspath(project, libref, descRefs);
            if (problem == null) continue;
            problems.add(problem);
        }
        for (LibraryModuleRef libref : descRefs) {
            problem = J2EELibraryFrameworkValidator.validateLibraryRefInDescriptor(project, libref);
            if (problem == null) continue;
            problems.add(problem);
        }
        J2EELibraryFrameworkValidator.updateProblems(project, null, problems);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IProblem validateLibraryRefOnClasspath(IProject project, LibraryModuleRef libref, List<LibraryModuleRef> descRefs) throws CoreException {
        MutableReference resolvedLibRef = new MutableReference();
        IProblem resolveProblem = J2EELibraryFrameworkValidator.validateResolvable(project, libref, true, (MutableReference<LibraryModule>)resolvedLibRef);
        if (resolveProblem != null) {
            return resolveProblem;
        }
        LibraryModule lib = (LibraryModule)resolvedLibRef.get();
        if (lib.getType() == LibraryModule.Type.WAR) {
            if (WtpProjectUtil.isDynamicWebProject((IProject)project)) {
                LibraryModuleRef refInDescriptor = J2EELibraryFrameworkValidator.findByName(descRefs, libref.getName());
                if (refInDescriptor == null) {
                    return new RefOnClasspathButNotInDescriptorProblem(project, libref, project);
                }
                if (libref.equals(refInDescriptor)) return null;
                return new ClasspathAndDescriptorRefsDoNotMatchProblem(project, libref, refInDescriptor, project);
            }
            if (!WtpProjectUtil.isUtilityProject((IProject)project)) return new WebLibRefInNonWebProjectProblem(project, libref);
            boolean referencedByWebApp = false;
            for (IProject webpj : WtpProjectUtil.findDynamicWebProjects()) {
                if (!WtpProjectUtil.findProjectsReferencedByWebApp((IProject)webpj, (boolean)false, (boolean)true).contains(project)) continue;
                return null;
            }
            if (referencedByWebApp) return null;
            return new MustBePartOfWebAppToUseLibProblem(project, libref);
        }
        if (WtpProjectUtil.isEarProject((IProject)project)) return null;
        Set referencingEarProjects = WtpProjectUtil.findReferencingEarProjects((IProject)project);
        if (referencingEarProjects.isEmpty()) {
            return new MustBePartOfEarToUseLibProblem(project, libref);
        }
        for (IProject earProject : referencingEarProjects) {
            List<LibraryModuleRef> earDescRefs = LibraryModulesSvc.getDescriptorReferences(earProject);
            LibraryModuleRef refInDescriptor = J2EELibraryFrameworkValidator.findByName(earDescRefs, libref.getName());
            if (refInDescriptor == null) {
                return new RefOnClasspathButNotInDescriptorProblem(project, libref, earProject);
            }
            if (libref.equals(refInDescriptor)) continue;
            return new ClasspathAndDescriptorRefsDoNotMatchProblem(project, libref, refInDescriptor, earProject);
        }
        return null;
    }

    private static IProblem validateLibraryRefInDescriptor(IProject project, LibraryModuleRef libref) throws CoreException {
        if (libref.getName() == null) {
            return null;
        }
        MutableReference resolvedLibRef = new MutableReference();
        IProblem resolveProblem = J2EELibraryFrameworkValidator.validateResolvable(project, libref, false, (MutableReference<LibraryModule>)resolvedLibRef);
        if (resolveProblem != null) {
            return resolveProblem;
        }
        LibraryModule lib = (LibraryModule)resolvedLibRef.get();
        if (WtpProjectUtil.isDynamicWebProject((IProject)project) && lib.getType() != LibraryModule.Type.WAR) {
            return new NonWebLibRefInWebDescriptorProblem(project, libref);
        }
        return null;
    }

    private static IProblem validateResolvable(IProject project, LibraryModuleRef libref, boolean isClasspathRef) {
        return J2EELibraryFrameworkValidator.validateResolvable(project, libref, isClasspathRef, null);
    }

    private static IProblem validateResolvable(IProject project, LibraryModuleRef libref, boolean isClasspathRef, MutableReference<LibraryModule> resolved) {
        LibraryModule lib;
        try {
            lib = LibraryModulesSvc.getRegistry().resolve(libref);
        }
        catch (UnresolvableReferenceException unresolvableReferenceException) {
            return new UnableToResolveLibraryProblem(project, libref, isClasspathRef);
        }
        catch (AmbiguousReferenceException ambiguousReferenceException) {
            return new AmbiguousReferenceLibraryProblem(project, libref, isClasspathRef);
        }
        if (resolved != null) {
            resolved.set((Object)lib);
        }
        return null;
    }

    private static LibraryModuleRef findByName(Collection<LibraryModuleRef> references, String name) {
        for (LibraryModuleRef libref : references) {
            if (!libref.getName().equals(name)) continue;
            return libref;
        }
        return null;
    }

    private static void updateProblems(IProject project, Set<String> problemTypes, Set<IProblem> problems) throws CoreException {
        HashMap<String, IProblem> probs = new HashMap<String, IProblem>();
        for (IProblem problem : problems) {
            probs.put(problem.getProblemId(), problem);
        }
        IMarker[] iMarkerArray = project.findMarkers("oracle.eclipse.tools.weblogic.j2eelib.validation.marker", false, 0);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem;
            IMarker existingMarker = iMarkerArray[n2];
            String problemType = existingMarker.getAttribute("problem-type", null);
            String problemId = existingMarker.getAttribute("problem-id", null);
            if (problemType == null || problemId == null) {
                existingMarker.delete();
            }
            if ((problemTypes == null || problemTypes.contains(problemType)) && (problem = (IProblem)probs.remove(problemId)) == null) {
                existingMarker.delete();
            }
            ++n2;
        }
        for (IProblem problem : probs.values()) {
            problem.placeMarker();
        }
    }

    public static void handleRegistryChangedEvent() {
        try {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible()) {
                    IProblem problem;
                    HashSet<IProblem> problems = new HashSet<IProblem>();
                    for (LibraryModuleRef libref : LibraryModulesSvc.getClasspathReferences(project)) {
                        problem = J2EELibraryFrameworkValidator.validateResolvable(project, libref, true);
                        if (problem == null) continue;
                        problems.add(problem);
                    }
                    for (LibraryModuleRef libref : LibraryModulesSvc.getDescriptorReferences(project)) {
                        problem = J2EELibraryFrameworkValidator.validateResolvable(project, libref, false);
                        if (problem == null) continue;
                        problems.add(problem);
                    }
                    J2EELibraryFrameworkValidator.updateProblems(project, UnableToResolveLibraryProblem.getProblemTypes(), problems);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
        }
    }

    private static final class Resources
    extends NLS {
        public static String taskDescription;

        static {
            Resources.initializeMessages((String)J2EELibraryFrameworkValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

