/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib.internal;

import java.util.ArrayList;
import java.util.Collection;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.j2eelib.IAutoRegistrationFilter;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class AutoRegistrationFiltersExtPoint {
    public static final String EXTENSION_POINT_ID = "j2eeLibraryAutoRegistrationFilters";
    private static final String EL_ENABLEMENT = "enablement";
    private static final String EL_FILTER = "filter";
    private static final String ATTR_CLASS = "class";
    private static final String EXPR_VAR_RUNTIME = "runtime";
    private static Collection<FilterDef> extensions = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<IAutoRegistrationFilter> getFilters(IRuntime runtime) {
        Class<AutoRegistrationFiltersExtPoint> clazz = AutoRegistrationFiltersExtPoint.class;
        synchronized (AutoRegistrationFiltersExtPoint.class) {
            if (extensions == null) {
                extensions = AutoRegistrationFiltersExtPoint.readExtensions();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            EvaluationContext evalContext = new EvaluationContext(null, (Object)runtime);
            evalContext.addVariable(EXPR_VAR_RUNTIME, (Object)runtime);
            evalContext.setAllowPluginActivation(true);
            ArrayList<IAutoRegistrationFilter> filters = new ArrayList<IAutoRegistrationFilter>();
            for (FilterDef def : extensions) {
                IAutoRegistrationFilter filter;
                boolean isEnabled;
                if (def.enablementExpression != null) {
                    isEnabled = false;
                    try {
                        EvaluationResult evalResult = def.enablementExpression.evaluate((IEvaluationContext)evalContext);
                        isEnabled = evalResult == EvaluationResult.TRUE;
                    }
                    catch (CoreException e) {
                        WlsCorePlugin.logException((Exception)((Object)e));
                    }
                } else {
                    isEnabled = true;
                }
                if (!isEnabled || (filter = (IAutoRegistrationFilter)PluginUtil.instantiate((String)def.pluginId, (String)def.className, IAutoRegistrationFilter.class)) == null) continue;
                filters.add(filter);
            }
            return filters;
        }
    }

    private static Collection<FilterDef> readExtensions() {
        ArrayList<FilterDef> extensions = new ArrayList<FilterDef>();
        for (IConfigurationElement element : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"oracle.eclipse.tools.weblogic", (String)EXTENSION_POINT_ID))) {
            String pluginId = element.getContributor().getName();
            if (!element.getName().equals(EL_FILTER)) continue;
            try {
                Expression expr;
                String className = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_CLASS);
                IConfigurationElement elEnablement = PluginUtil.findOptionalElement((IConfigurationElement)element, (String)EL_ENABLEMENT);
                try {
                    expr = ExpressionConverter.getDefault().perform(elEnablement);
                }
                catch (CoreException e) {
                    WlsCorePlugin.logException((Exception)((Object)e));
                    throw new PluginUtil.InvalidExtensionException();
                }
                extensions.add(new FilterDef(pluginId, className, expr));
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
        return extensions;
    }

    private static final class FilterDef {
        public final String pluginId;
        public final String className;
        public final Expression enablementExpression;

        public FilterDef(String pluginId, String className, Expression enablementExpression) {
            this.pluginId = pluginId;
            this.className = className;
            this.enablementExpression = enablementExpression;
        }
    }
}

