/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.SharedLibraryAttachment;
import oracle.eclipse.tools.weblogic.j2eelib.SharedLibraryAttachmentProvider;
import org.eclipse.core.runtime.IConfigurationElement;

public final class SharedLibraryAttachmentProviderSystem {
    private static final String EXTENSION_POINT_ID = "sharedLibraryAttachmentProviders";
    private static final String EL_PROVIDER = "provider";
    private static final String ATTR_CLASS = "class";
    private static List<SharedLibraryAttachmentProvider> providers;

    public static SharedLibraryAttachment getAttachment(LibraryModule library, String jarPath) {
        SharedLibraryAttachmentProviderSystem.initialize();
        for (SharedLibraryAttachmentProvider provider : providers) {
            try {
                SharedLibraryAttachment attachment = provider.getAttachment(library, jarPath);
                if (attachment == null) continue;
                return attachment;
            }
            catch (Exception e) {
                WlsCorePlugin.logException(e);
            }
        }
        return null;
    }

    private static synchronized void initialize() {
        if (providers == null) {
            providers = new ArrayList<SharedLibraryAttachmentProvider>();
            for (IConfigurationElement element : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"oracle.eclipse.tools.weblogic", (String)EXTENSION_POINT_ID))) {
                String pluginId = element.getContributor().getName();
                if (!element.getName().equals(EL_PROVIDER)) continue;
                try {
                    String clname = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_CLASS);
                    SharedLibraryAttachmentProvider provider = (SharedLibraryAttachmentProvider)PluginUtil.instantiate((String)pluginId, (String)clname, SharedLibraryAttachmentProvider.class);
                    if (provider == null) continue;
                    providers.add(provider);
                }
                catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
            }
        }
    }
}

