/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.ValidateEditUtil;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.util.fileio.ManifestUtil;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.WlsEarUtil;
import oracle.eclipse.tools.weblogic.descriptors.ILibraryRef;
import oracle.eclipse.tools.weblogic.descriptors.ILibraryRefDescriptorPart;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.facets.WlsEarFacet;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.j2eelib.AmbiguousReferenceException;
import oracle.eclipse.tools.weblogic.j2eelib.IFilter;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRegistry;
import oracle.eclipse.tools.weblogic.j2eelib.SharedLibraryContainer;
import oracle.eclipse.tools.weblogic.j2eelib.UnresolvableReferenceException;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.osgi.service.prefs.BackingStoreException;

public final class LibraryModulesSvc {
    private static final String WS_METADATA_LOCATION = ".metadata/.plugins/oracle.eclipse.tools.weblogic/libraries";
    private static final String WS_METADATA_LOCATION_LEGACY = ".metadata/.plugins/com.bea.workshop.wls.core/libraries";
    private static final String REGISTRY_FILE_NAME = "/registry.xml";
    private static LibraryModuleRegistry registry = null;

    public static synchronized LibraryModuleRegistry getRegistry() {
        if (registry == null) {
            File catfile = new File(LibraryModulesSvc.getWorkspaceMetadataLocation(), REGISTRY_FILE_NAME);
            registry = new LibraryModuleRegistry(catfile);
        }
        return registry;
    }

    public static void registerLibraryModules(File dir) {
        LibraryModulesSvc.registerLibraryModules(dir, null);
    }

    public static void registerLibraryModules(File dir, IFilter filter) {
        if (dir == null) {
            String msg = NLS.bind((String)Resources.paramCannotBeNull, (Object)"dir");
            throw new IllegalArgumentException(msg);
        }
        FileFilter extFilter = FileUtil.getExtensionFilter((String[])new String[]{"ear", "war", "jar"});
        List<File> fileList = LibraryModulesSvc.listFiles(dir, extFilter);
        File[] contents = fileList.toArray(new File[fileList.size()]);
        if (contents != null) {
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                try {
                    LibraryModulesSvc.registerLibraryModule(f, filter, LibraryModuleRegistry.ConflictResolutionStrategyForAdd.REPLACE);
                }
                catch (CoreException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)e);
                }
                ++n2;
            }
        }
    }

    public static void refreshLibraryModules(File dir, IFilter filter) {
        if (dir == null) {
            String msg = NLS.bind((String)Resources.paramCannotBeNull, (Object)"dir");
            throw new IllegalArgumentException(msg);
        }
        FileFilter extFilter = FileUtil.getExtensionFilter((String[])new String[]{"ear", "war", "jar"});
        List<File> fileList = LibraryModulesSvc.listFiles(dir, extFilter);
        File[] contents = fileList.toArray(new File[fileList.size()]);
        if (contents != null) {
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                try {
                    LibraryModulesSvc.registerLibraryModule(f, filter, LibraryModuleRegistry.ConflictResolutionStrategyForAdd.IGNORE);
                }
                catch (CoreException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)e);
                }
                ++n2;
            }
        }
    }

    private static List<File> listFiles(File dir, FileFilter extFilter) {
        ArrayList<File> ret = new ArrayList<File>();
        if (dir == null || !dir.exists()) {
            return ret;
        }
        File[] fileArray = dir.listFiles(extFilter);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            ret.add(f);
            ++n2;
        }
        fileArray = dir.listFiles();
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            File subDir = fileArray[n2];
            if (subDir.isDirectory()) {
                ret.addAll(LibraryModulesSvc.listFiles(subDir, extFilter));
            }
            ++n2;
        }
        return ret;
    }

    public static LibraryModule registerLibraryModule(File location) throws CoreException {
        return LibraryModulesSvc.registerLibraryModule(location, null, LibraryModuleRegistry.ConflictResolutionStrategyForAdd.REPLACE);
    }

    private static LibraryModule registerLibraryModule(File location, IFilter filter, LibraryModuleRegistry.ConflictResolutionStrategyForAdd strategyForAdd) throws CoreException {
        String specVersionStr;
        Map manifest;
        if (location == null) {
            String msg = NLS.bind((String)Resources.paramCannotBeNull, (Object)"location");
            throw new IllegalArgumentException(msg);
        }
        try {
            manifest = ManifestUtil.readManifest((File)location);
        }
        catch (IOException e) {
            throw new CoreException(WlsCorePlugin.createErrorStatus(e));
        }
        String name = (String)manifest.get("Extension-Name");
        if (name == null) {
            name = FileUtil.getNameWithoutExtension((File)location);
        }
        Version specVersion = (specVersionStr = (String)manifest.get("Specification-Version")) == null ? null : new Version(specVersionStr);
        String implVersionStr = (String)manifest.get("Implementation-Version");
        Version implVersion = implVersionStr == null ? null : new Version(implVersionStr);
        LibraryModuleRef ref = new LibraryModuleRef(name, specVersion, implVersion, false);
        return LibraryModulesSvc.registerLibraryModule(ref, location, filter, strategyForAdd);
    }

    public static LibraryModule registerLibraryModule(LibraryModuleRef ref, File location) throws CoreException {
        return LibraryModulesSvc.registerLibraryModule(ref, location, null, LibraryModuleRegistry.ConflictResolutionStrategyForAdd.REPLACE);
    }

    private static LibraryModule registerLibraryModule(LibraryModuleRef ref, File location, IFilter filter, LibraryModuleRegistry.ConflictResolutionStrategyForAdd strategyForAdd) throws CoreException {
        LibraryModule libmod;
        if (ref == null) {
            String msg = NLS.bind((String)Resources.paramCannotBeNull, (Object)"ref");
            throw new IllegalArgumentException(msg);
        }
        if (location == null) {
            String msg = NLS.bind((String)Resources.paramCannotBeNull, (Object)"location");
            throw new IllegalArgumentException(msg);
        }
        LibraryModuleRegistry reg = LibraryModulesSvc.getRegistry();
        try {
            libmod = new LibraryModule(location, ref.getName(), ref.getSpecificationVersion(), ref.getImplementationVersion(), null, null, LibraryModulesSvc.getTempDir());
        }
        catch (IOException ioe) {
            throw new CoreException(WlsCorePlugin.createErrorStatus(ioe));
        }
        if (filter != null) {
            try {
                if (!filter.check(libmod)) {
                    return null;
                }
            }
            catch (Exception ex) {
                WlsCorePlugin.logException(ex);
            }
        }
        if (LibraryModulesSvc.isLibraryExisting(ref, location)) {
            return null;
        }
        reg.add(libmod, strategyForAdd);
        return libmod;
    }

    public static boolean isLibraryExisting(LibraryModuleRef ref, File location) {
        LibraryModule[] libModules;
        LibraryModule[] libraryModuleArray = libModules = registry.list();
        int n = libModules.length;
        int n2 = 0;
        while (n2 < n) {
            LibraryModule lib = libraryModuleArray[n2];
            if (lib.getName().equals(ref.getName()) && (lib.getSpecificationVersion() == null && ref.getSpecificationVersion() == null || lib.getSpecificationVersion().equals(ref.getSpecificationVersion())) && (lib.getImplementationVersion() == null && ref.getImplementationVersion() == null || lib.getImplementationVersion().equals(ref.getImplementationVersion()))) {
                return lib.getLocation().equals(location);
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addLibraryModuleRef(IProject project, LibraryModuleRef libmodref, LibraryModule.Type libmodtype, String ... overrides) throws CoreException {
        LibraryModule.Type type;
        if (project == null) {
            throw new IllegalArgumentException("The project parameter cannot be null!");
        }
        if (libmodref == null) {
            throw new IllegalArgumentException("The libmodref parameter cannot be null!");
        }
        if (libmodtype == null) {
            try {
                type = LibraryModulesSvc.getRegistry().resolve(libmodref).getType();
            }
            catch (AmbiguousReferenceException e) {
                throw new CoreException(WlsCorePlugin.createErrorStatus(e));
            }
            catch (UnresolvableReferenceException e) {
                throw new CoreException(WlsCorePlugin.createErrorStatus(e));
            }
        } else {
            type = libmodtype;
        }
        if (WtpProjectUtil.isEarProject((IProject)project)) {
            LibraryModulesSvc.addToDescriptor(project, libmodref, overrides);
            return;
        } else if (type == LibraryModule.Type.WAR) {
            if (!WtpProjectUtil.isDynamicWebProject((IProject)project)) throw new IllegalArgumentException();
            LibraryModulesSvc.addToClasspath(project, libmodref, overrides);
            LibraryModulesSvc.addToDescriptor(project, libmodref, overrides);
            return;
        } else {
            if (!WtpProjectUtil.isJavaProject((IProject)project)) throw new IllegalArgumentException();
            LibraryModulesSvc.addToClasspath(project, libmodref, overrides);
            for (IProject ear : WlsEarUtil.findReferencingEarProjects(project)) {
                if (!WlsEarFacet.isInstalled(ear)) continue;
                LibraryModulesSvc.addToDescriptor(ear, libmodref, overrides);
            }
        }
    }

    public static void addLibraryModuleRef(IProject project, LibraryModuleRef libmodref, String ... overrides) throws CoreException {
        LibraryModulesSvc.addLibraryModuleRef(project, libmodref, null, overrides);
    }

    public static void addLibraryModuleRef(IProject project, LibraryModuleRef libmodref, File libmodloc, String ... overrides) throws CoreException {
        LibraryModulesSvc.registerLibraryModule(libmodref, libmodloc);
        LibraryModulesSvc.addLibraryModuleRef(project, libmodref, null, overrides);
    }

    public static void addToDescriptor(IProject pj, LibraryModuleRef ref, String ... overrides) throws CoreException {
        ILibraryRefDescriptorPart desc = LibraryModulesSvc.getDescriptor(pj);
        if (desc == null) {
            return;
        }
        try {
            desc.removeLibraryRef(ref.getName());
            ILibraryRef libref = (ILibraryRef)desc.getLibraryRefs().insert();
            LibraryModulesSvc.update(libref, ref);
            if (overrides.length > 0) {
                libref.moveBefore(overrides);
            }
            desc.resource().save();
            desc.dispose();
        }
        catch (ResourceStoreException e) {
            throw new CoreException(WlsCorePlugin.createErrorStatus((Exception)((Object)e)));
        }
    }

    public static void addToClasspath(IProject project, LibraryModuleRef ref, String ... overrides) throws CoreException {
        HashSet<String> overridesSet = new HashSet<String>();
        String[] stringArray = overrides;
        int n = overrides.length;
        int n2 = 0;
        while (n2 < n) {
            String libmodname = stringArray[n2];
            overridesSet.add(libmodname);
            ++n2;
        }
        LibraryModulesSvc.addToClasspath(project, ref, overridesSet);
    }

    private static void addToClasspath(IProject project, LibraryModuleRef libmodref, Set<String> overrides) throws CoreException {
        LibraryModulesSvc.removeFromClasspath(project, libmodref.getName());
        IJavaProject jproj = JavaCore.create((IProject)project);
        IClasspathEntry[] old = jproj.getRawClasspath();
        IClasspathEntry[] cp = new IClasspathEntry[old.length + 1];
        IPath path = SharedLibraryContainer.convertLibraryRefToPath(libmodref);
        IClasspathEntry cpe = JavaCore.newContainerEntry((IPath)path);
        if (overrides.isEmpty()) {
            System.arraycopy(old, 0, cp, 0, old.length);
            cp[old.length] = cpe;
        } else {
            int pos = -1;
            int i = 0;
            while (i < old.length) {
                LibraryModuleRef xlibref;
                IClasspathEntry x = old[i];
                if (SharedLibraryContainer.isSharedLibraryContainer(x) && overrides.contains((xlibref = SharedLibraryContainer.convertPathToLibraryRef(x.getPath())).getName())) {
                    pos = i;
                    break;
                }
                ++i;
            }
            if (pos == -1) {
                System.arraycopy(old, 0, cp, 0, old.length);
                cp[old.length] = cpe;
            } else {
                System.arraycopy(old, 0, cp, 0, pos);
                cp[pos] = cpe;
                System.arraycopy(old, pos, cp, pos + 1, old.length - pos);
            }
        }
        jproj.setRawClasspath(cp, null);
    }

    public static void removeLibraryModuleRef(IProject project, LibraryModuleRef libref) throws CoreException {
        LibraryModulesSvc.removeLibraryModuleRef(project, libref.getName());
    }

    public static void removeLibraryModuleRef(IProject project, String libraryName) throws CoreException {
        if (project == null) {
            String msg = NLS.bind((String)Resources.paramCannotBeNull, (Object)"project");
            throw new IllegalArgumentException(msg);
        }
        if (libraryName == null) {
            String msg = NLS.bind((String)Resources.paramCannotBeNull, (Object)"libraryName");
            throw new IllegalArgumentException(msg);
        }
        if (JavaProjectUtil.isJavaProject((IProject)project)) {
            if (!ValidateEditUtil.validateEdit((IFile[])new IFile[]{project.getFile(".classpath")}).isOK()) {
                return;
            }
            LibraryModulesSvc.removeFromClasspath(project, libraryName);
        }
        LibraryModulesSvc.removeFromDescriptor(project, libraryName);
        if (!WtpProjectUtil.isEarProject((IProject)project)) {
            for (IProject earProject : WtpProjectUtil.findReferencingEarProjects((IProject)project)) {
                if (!LibraryModulesSvc.isReferencedInDescriptor(earProject, libraryName)) continue;
                boolean referenced = false;
                for (IProject moduleProject : WtpProjectUtil.findProjectsReferencedByEar((IProject)earProject)) {
                    if (!LibraryModulesSvc.isOnClasspath(moduleProject, libraryName)) continue;
                    referenced = true;
                    break;
                }
                if (referenced) continue;
                LibraryModulesSvc.removeLibraryModuleRef(earProject, libraryName);
            }
        }
    }

    public static void removeFromDescriptor(IProject project, String libraryName) throws CoreException {
        ILibraryRefDescriptorPart desc = LibraryModulesSvc.getDescriptor(project);
        if (desc != null) {
            try {
                try {
                    desc.removeLibraryRef(libraryName);
                    desc.resource().save();
                }
                catch (ResourceStoreException e) {
                    throw new CoreException(WlsCorePlugin.createErrorStatus((Exception)((Object)e)));
                }
            }
            finally {
                desc.dispose();
            }
        }
    }

    public static void removeFromClasspath(IProject project, String libraryName) throws CoreException {
        SharedLibraryContainer.removeFromClasspath(project, libraryName);
    }

    public static void updateLibraryModuleRef(IProject project, String currentExtensionName, LibraryModuleRef newRef) throws CoreException {
        LibraryModulesSvc.updateInClasspath(project, currentExtensionName, newRef);
        LibraryModulesSvc.updateInDescriptor(project, currentExtensionName, newRef);
    }

    public static void updateInClasspath(IProject project, String currentExtensionName, LibraryModuleRef newRef) throws CoreException {
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject jproj = JavaCore.create((IProject)project);
            IClasspathEntry[] projectCPEntries = jproj.getRawClasspath();
            int cpIndex = 0;
            while (cpIndex < projectCPEntries.length) {
                IClasspathEntry cpe = projectCPEntries[cpIndex];
                if (cpe.getEntryKind() == 5 && cpe.getPath().segmentCount() >= 2 && cpe.getPath().segments()[1].equals(currentExtensionName)) {
                    IClasspathEntry newEntry;
                    String spec = "";
                    if (newRef.getSpecificationVersion() != null) {
                        spec = newRef.getSpecificationVersion().toString();
                    }
                    String impl = "";
                    if (newRef.getImplementationVersion() != null) {
                        impl = newRef.getImplementationVersion().toString();
                    }
                    String matchType = "allow-newer";
                    if (!newRef.getAllowNewerVersions()) {
                        matchType = "exact";
                    }
                    String sep = "/";
                    Path newPath = new Path(String.valueOf(cpe.getPath().segments()[0]) + sep + newRef.getName() + sep + matchType + sep + spec + sep + impl);
                    projectCPEntries[cpIndex] = newEntry = JavaCore.newContainerEntry((IPath)newPath, (IAccessRule[])cpe.getAccessRules(), (IClasspathAttribute[])cpe.getExtraAttributes(), (boolean)cpe.isExported());
                    jproj.setRawClasspath(projectCPEntries, null);
                    return;
                }
                ++cpIndex;
            }
        }
    }

    public static void updateInDescriptor(IProject project, String currentLibraryName, LibraryModuleRef newRef) throws CoreException {
        ILibraryRefDescriptorPart desc = LibraryModulesSvc.getDescriptor(project);
        try {
            try {
                ILibraryRef libref = desc.getLibraryRef(currentLibraryName);
                if (libref != null) {
                    LibraryModulesSvc.update(libref, newRef);
                }
                desc.resource().save();
            }
            catch (ResourceStoreException e) {
                throw new CoreException(WlsCorePlugin.createErrorStatus((Exception)((Object)e)));
            }
        }
        finally {
            desc.dispose();
        }
    }

    public static List<LibraryModuleRef> getClasspathReferences(IProject pj) throws CoreException {
        ArrayList<LibraryModuleRef> list = new ArrayList<LibraryModuleRef>();
        if (!JavaProjectUtil.isJavaProject((IProject)pj)) {
            return list;
        }
        IJavaProject jpj = JavaCore.create((IProject)pj);
        IClasspathEntry[] iClasspathEntryArray = jpj.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (SharedLibraryContainer.isSharedLibraryContainer(cpe)) {
                list.add(SharedLibraryContainer.convertPathToLibraryRef(cpe.getPath()));
            }
            ++n2;
        }
        return list;
    }

    public static boolean isOnClasspath(IProject pj, String libraryName) throws CoreException {
        return SharedLibraryContainer.isOnClasspath(pj, libraryName);
    }

    public static List<LibraryModuleRef> getDescriptorReferences(IProject pj) throws CoreException {
        List<LibraryModuleRef> result;
        ILibraryRefDescriptorPart desc = LibraryModulesSvc.getDescriptor(pj);
        if (desc == null) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList();
            for (ILibraryRef libref : desc.getLibraryRefs()) {
                result.add(LibraryModulesSvc.convert(libref));
            }
            desc.dispose();
        }
        return result;
    }

    public static boolean isReferencedInDescriptor(IProject pj, String libraryName) throws CoreException {
        boolean result;
        ILibraryRefDescriptorPart desc = LibraryModulesSvc.getDescriptor(pj);
        if (desc == null) {
            result = false;
        } else {
            result = desc.getLibraryRef(libraryName) != null;
            desc.dispose();
        }
        return result;
    }

    public static LibraryModule resolve(LibraryModuleRef ref) throws CoreException {
        try {
            return LibraryModulesSvc.getRegistry().resolve(ref);
        }
        catch (UnresolvableReferenceException e) {
            throw new CoreException(WlsCorePlugin.createErrorStatus(e));
        }
        catch (AmbiguousReferenceException e) {
            throw new CoreException(WlsCorePlugin.createErrorStatus(e));
        }
    }

    public static boolean getUsagePreference(IProject project) {
        IEclipsePreferences prefs = LibraryModulesSvc.getProjectPreferences(project);
        return prefs.getBoolean("use.library.modules", true);
    }

    public static void setUsagePreference(IProject project, boolean useLibraryModules) {
        IEclipsePreferences prefs = LibraryModulesSvc.getProjectPreferences(project);
        prefs.putBoolean("use.library.modules", useLibraryModules);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)e);
        }
    }

    private static IEclipsePreferences getProjectPreferences(IProject project) {
        ProjectScope pjprefs = new ProjectScope(project);
        return pjprefs.getNode("oracle.eclipse.tools.weblogic");
    }

    public static File getTempDir() {
        return LibraryModulesSvc.getWorkspaceMetadataLocation();
    }

    private static ILibraryRefDescriptorPart getDescriptor(IProject project) {
        if (WtpProjectUtil.isEarProject((IProject)project)) {
            return WebLogicDescriptorFactory.getAppDescriptor(project);
        }
        if (WtpProjectUtil.isDynamicWebProject((IProject)project)) {
            return WebLogicDescriptorFactory.getWebDescriptor(project);
        }
        return null;
    }

    public static final LibraryModuleRef convert(ILibraryRef libref) {
        String name = libref.getLibraryName().text();
        String specVersion = libref.getSpecificationVersion().text();
        String implVersion = libref.getImplementationVersion().text();
        boolean exactMatch = (Boolean)libref.isExactMatchRequired().content(true);
        return new LibraryModuleRef(name != null ? name : "", specVersion != null ? new Version(specVersion) : null, implVersion != null ? new Version(implVersion) : null, !exactMatch);
    }

    private static final void update(ILibraryRef target, LibraryModuleRef source) {
        target.setLibraryName(source.getName());
        target.setSpecificationVersion(StringUtil.toStringNullable((Object)source.getSpecificationVersion()));
        target.setImplementationVersion(StringUtil.toStringNullable((Object)source.getImplementationVersion()));
        target.setExactMatchRequired(!source.getAllowNewerVersions());
    }

    private static final File getWorkspaceMetadataLocation() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        File wsdir = ws.getRoot().getLocation().toFile();
        File wsmdloc = new File(wsdir, WS_METADATA_LOCATION_LEGACY);
        if (!wsmdloc.exists()) {
            wsmdloc = new File(wsdir, WS_METADATA_LOCATION);
        }
        return wsmdloc;
    }

    private static final class Resources
    extends NLS {
        public static String paramCannotBeNull;

        static {
            Resources.initializeMessages((String)LibraryModulesSvc.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

