/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.j2eelib;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.util.fileio.ManifestUtil;
import oracle.eclipse.tools.common.util.fileio.ZipUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.j2eelib.ClasspathEntry;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.SharedLibraryAttachment;
import oracle.eclipse.tools.weblogic.j2eelib.SharedLibraryAttachmentProviderSystem;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LibraryModule {
    private static final String NL = System.getProperty("line.separator");
    private static final String MF_EXTENSION_NAME = "Extension-Name";
    private static final String MF_SPECIFICATION_VERSION = "Specification-Version";
    private static final String MF_IMPLEMENTATION_VERSION = "Implementation-Version";
    private static final String SRC_MANIFEST_PATH = "meta-inf/source.mf";
    private static final String SRC_MANIFEST_WILDCARD = "*";
    private static final String JAVADOC_MANIFEST_PATH = "meta-inf/javadoc.mf";
    private static final String JAVADOC_MANIFEST_WILDCARD = "*";
    private File location;
    private long lastModified;
    private String name;
    private Type type;
    private Version specVersion;
    private Version implVersion;
    private Map<String, File> sourceLocations;
    private Map<String, File> sourceLocationsOverrides;
    private Map<String, URL> javadocLocations;
    private Map<String, URL> javadocLocationsOverrides;
    private File tempdir;
    private final boolean[] fromManifest = new boolean[3];
    private HashSet<Listener> listeners = new HashSet();
    private Set<String> targetList = new HashSet<String>();

    public LibraryModule(File location, String name, Version specVersion, Version implVersion, Map<String, File> sourceLocations, Map<String, URL> javadocLocations, File tempdir) throws IOException {
        this.init(location, name, specVersion, implVersion, LibraryModule.cloneOrCreate(sourceLocations), LibraryModule.cloneOrCreate(javadocLocations), tempdir, true);
    }

    public LibraryModule(Element root) throws IOException {
        File location = null;
        String name = null;
        Version specVersion = null;
        Version implVersion = null;
        File tempdir = null;
        HashMap<String, File> sourceLocations = new HashMap<String, File>();
        HashMap<String, URL> javadocLocations = new HashMap<String, URL>();
        for (Element e : DomUtil.elements((Element)root)) {
            String library;
            String n = e.getNodeName();
            if (n.equals("location")) {
                location = new File(DomUtil.text((Node)e));
                continue;
            }
            if (n.equals("name")) {
                name = DomUtil.text((Node)e);
                continue;
            }
            if (n.equals("specification-version")) {
                specVersion = new Version(DomUtil.text((Node)e));
                continue;
            }
            if (n.equals("implementation-version")) {
                implVersion = new Version(DomUtil.text((Node)e));
                continue;
            }
            if (n.equals("source-location")) {
                library = e.getAttribute("library");
                File srcloc = new File(DomUtil.text((Node)e));
                sourceLocations.put(library, srcloc);
                continue;
            }
            if (n.equals("javadoc-location")) {
                library = e.getAttribute("library");
                URL javadocloc = new URL(DomUtil.text((Node)e));
                javadocLocations.put(library, javadocloc);
                continue;
            }
            if (!n.equals("temp-dir")) continue;
            tempdir = new File(DomUtil.text((Node)e));
        }
        this.init(location, name, specVersion, implVersion, sourceLocations, javadocLocations, tempdir, false);
    }

    public LibraryModule(String name, File location, Version specVersion, Version implVersion) {
        this.name = name;
        this.location = location;
        this.specVersion = specVersion;
        this.implVersion = implVersion;
    }

    private void init(File location, String name, Version specVersion, Version implVersion, Map<String, File> sourceLocations, Map<String, URL> javadocLocations, File tempdir, boolean genSubDir) throws IOException {
        this.location = location;
        ZipFile zip = ZipUtil.open((File)this.location);
        try {
            String fname = location.getName().toLowerCase();
            if (fname.endsWith(".ear")) {
                this.type = Type.EAR;
            } else if (fname.endsWith(".war")) {
                this.type = Type.WAR;
            } else if (fname.endsWith(".jar")) {
                this.type = ZipUtil.getZipEntry((ZipFile)zip, (String)"meta-inf/ejb-jar.xml") != null ? Type.EJB : Type.JAR;
            } else {
                throw new IllegalArgumentException();
            }
            Map manifest = ManifestUtil.readManifest((ZipFile)zip);
            String nameFromMf = (String)manifest.get(MF_EXTENSION_NAME);
            if (nameFromMf != null) {
                this.name = nameFromMf;
                this.fromManifest[0] = true;
            } else {
                this.name = name != null ? name : FileUtil.getNameWithoutExtension((File)this.location);
            }
            String specVersionFromMf = (String)manifest.get(MF_SPECIFICATION_VERSION);
            if (specVersionFromMf != null) {
                this.specVersion = new Version(specVersionFromMf);
                this.fromManifest[1] = true;
            } else {
                this.specVersion = specVersion;
            }
            String implVersionFromMf = (String)manifest.get(MF_IMPLEMENTATION_VERSION);
            if (implVersionFromMf != null) {
                this.implVersion = new Version(implVersionFromMf);
                this.fromManifest[2] = true;
            } else {
                this.implVersion = implVersion;
            }
            this.sourceLocations = new HashMap<String, File>();
            this.sourceLocationsOverrides = sourceLocations;
            Map<String, String> sourceManifest = LibraryModule.readPropertiesFile(zip, SRC_MANIFEST_PATH);
            for (Map.Entry<String, String> entry : sourceManifest.entrySet()) {
                File path = LibraryModule.toFile(location.getParentFile(), entry.getValue());
                this.sourceLocations.put(entry.getKey(), path);
            }
            this.sourceLocations.putAll(sourceLocations);
            this.javadocLocations = new HashMap<String, URL>();
            this.javadocLocationsOverrides = javadocLocations;
            Map<String, String> javadocManifest = LibraryModule.readPropertiesFile(zip, JAVADOC_MANIFEST_PATH);
            for (Map.Entry<String, String> entry : javadocManifest.entrySet()) {
                String value = entry.getValue();
                URL url = value.contains("://") ? new URL(value) : LibraryModule.toFile(location.getParentFile(), value).toURI().toURL();
                this.javadocLocations.put(entry.getKey(), url);
            }
            this.javadocLocations.putAll(javadocLocations);
            if (genSubDir) {
                StringBuilder buf = new StringBuilder();
                buf.append(this.name);
                if (this.specVersion != null) {
                    buf.append('_');
                    buf.append(this.specVersion.toString());
                }
                if (this.implVersion != null) {
                    buf.append('_');
                    buf.append(this.implVersion.toString());
                }
                this.tempdir = new File(tempdir, buf.toString());
            } else {
                this.tempdir = tempdir;
            }
        }
        catch (Throwable throwable) {
            try {
                zip.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zip.close();
        }
        catch (IOException iOException) {}
        this.lastModified = this.location.lastModified();
    }

    public File getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNameModifiable() {
        return !this.fromManifest[0];
    }

    public Type getType() {
        return this.type;
    }

    public Version getSpecificationVersion() {
        return this.specVersion;
    }

    public boolean isSpecificationVersionModifiable() {
        return !this.fromManifest[1];
    }

    public Version getImplementationVersion() {
        return this.implVersion;
    }

    public boolean isImplementationVersionModifiable() {
        return !this.fromManifest[2];
    }

    public Map<String, File> getSourceLocations() {
        return this.getSourceLocations(false);
    }

    public Map<String, File> getSourceLocations(boolean overridesOnly) {
        if (overridesOnly) {
            return Collections.unmodifiableMap(this.sourceLocationsOverrides);
        }
        return Collections.unmodifiableMap(this.sourceLocations);
    }

    public File getSourceLocation(String library) {
        SharedLibraryAttachment attachment;
        File file = this.sourceLocations.get(library);
        if (file == null) {
            file = this.sourceLocations.get("*");
        }
        if (file == null && (attachment = SharedLibraryAttachmentProviderSystem.getAttachment(this, library)) != null) {
            file = attachment.getSourceLocation();
        }
        return file;
    }

    public Map<String, URL> getJavadocLocations() {
        return this.getJavadocLocations(false);
    }

    public Map<String, URL> getJavadocLocations(boolean overridesOnly) {
        if (overridesOnly) {
            return Collections.unmodifiableMap(this.javadocLocationsOverrides);
        }
        return Collections.unmodifiableMap(this.javadocLocations);
    }

    public URL getJavadocLocation(String library) {
        SharedLibraryAttachment attachment;
        URL url = this.javadocLocations.get(library);
        if (url == null) {
            url = this.javadocLocations.get("*");
        }
        if (url == null && (attachment = SharedLibraryAttachmentProviderSystem.getAttachment(this, library)) != null) {
            url = attachment.getJavadocLocation();
        }
        return url;
    }

    public Set<ClasspathEntry> getClasspathEntries() throws IOException {
        return this.getClasspathEntries((IRuntime)null);
    }

    public Set<ClasspathEntry> getClasspathEntries(IProject project) throws IOException {
        IRuntime runtime = null;
        try {
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            if (fproj != null) {
                runtime = fproj.getPrimaryRuntime();
            }
        }
        catch (CoreException e) {
            WlsCorePlugin.logException((Exception)((Object)e));
        }
        return this.getClasspathEntries(runtime);
    }

    public Set<ClasspathEntry> getClasspathEntries(IRuntime runtime) throws IOException {
        WebLogicServerInstall wlsInstall;
        File beahome = null;
        if (runtime != null && (wlsInstall = WebLogicServerInstall.getWebLogicServerInstall(runtime)) != null) {
            beahome = wlsInstall.getMiddlewareHomeLocation();
        }
        LinkedHashSet<ClasspathEntry> cp = new LinkedHashSet<ClasspathEntry>();
        if (this.type == Type.WAR) {
            File root = this.explode();
            File f = new File(root, "WEB-INF/lib");
            if (f.exists()) {
                File[] fileArray = f.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    if (child.getPath().toLowerCase().endsWith(".jar")) {
                        this.addClasspathEntries(cp, child, root, beahome);
                    }
                    ++n2;
                }
            }
            if ((f = new File(root, "WEB-INF/classes")).exists()) {
                this.addClasspathEntries(cp, f, root, beahome);
            }
        } else if (this.type == Type.EJB || this.type == Type.JAR) {
            File parent = this.location.getParentFile();
            this.addClasspathEntries(cp, this.location, parent, beahome);
        } else if (this.type == Type.EAR) {
            File root = this.explode();
            File f = new File(root, "APP-INF/lib");
            if (f.exists()) {
                File[] fileArray = f.listFiles();
                int n = fileArray.length;
                int n3 = 0;
                while (n3 < n) {
                    File child = fileArray[n3];
                    if (child.getPath().toLowerCase().endsWith(".jar")) {
                        this.addClasspathEntries(cp, child, root, beahome);
                    }
                    ++n3;
                }
            }
            if ((f = new File(root, "APP-INF/classes")).exists()) {
                this.addClasspathEntries(cp, f, root, beahome);
            }
            if ((f = new File(root, "META-INF/application.xml")).exists()) {
                for (Element e1 : DomUtil.elements((Element)DomUtil.root((File)f), (String)"module")) {
                    for (Element e2 : DomUtil.elements((Element)e1, (String)"ejb")) {
                        f = new File(root, DomUtil.text((Node)e2).trim());
                        this.addClasspathEntries(cp, f, root, beahome);
                    }
                }
            }
        } else {
            String msg = "Unknown library module type: " + (Object)((Object)this.type);
            throw new IllegalArgumentException(msg);
        }
        return cp;
    }

    private void addClasspathEntries(Set<ClasspathEntry> cp, File path, File base, File beahome) {
        URL javadoc;
        File source;
        String relative;
        if (base != null) {
            relative = FileUtil.getRelativePath((File)path, (File)base);
            source = this.getSourceLocation(relative);
            javadoc = this.getJavadocLocation(relative);
        } else {
            relative = path.getAbsolutePath();
            source = null;
            javadoc = null;
        }
        if (cp.add(new ClasspathEntry(path, relative, source, javadoc))) {
            String manifestClasspathEntry = null;
            try {
                manifestClasspathEntry = ManifestUtil.readManifestEntry((File)path, (String)"Class-Path");
            }
            catch (IOException e) {
                WlsCorePlugin.logException(e);
            }
            if (manifestClasspathEntry != null) {
                String[] stringArray = manifestClasspathEntry.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String entry = stringArray[n2];
                    String trimmedEntry = entry.trim();
                    if (trimmedEntry.length() > 0) {
                        File f = null;
                        if (trimmedEntry.startsWith("@BEA_HOME@")) {
                            if (beahome != null) {
                                f = new File(beahome, trimmedEntry.substring("@BEA_HOME@".length()));
                            }
                        } else {
                            f = new File(trimmedEntry);
                            if (!f.isAbsolute()) {
                                f = new File(path.getParentFile(), trimmedEntry);
                            }
                        }
                        if (f != null) {
                            try {
                                f = f.getCanonicalFile();
                            }
                            catch (IOException iOException) {}
                            if (f.exists()) {
                                this.addClasspathEntries(cp, f, null, beahome);
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public boolean exists() {
        return this.location.exists();
    }

    public synchronized File explode() throws IOException {
        File dest;
        File stamp = new File(this.tempdir, ".stamp");
        if (stamp.exists()) {
            long lastModified;
            int slot;
            block26: {
                DataInputStream in = new DataInputStream(new FileInputStream(stamp));
                slot = -1;
                lastModified = -1L;
                try {
                    try {
                        slot = in.readInt();
                        lastModified = in.readLong();
                    }
                    catch (IOException iOException) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException2) {}
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (this.location.lastModified() == lastModified) {
                return new File(this.tempdir, String.valueOf(slot));
            }
        }
        try {
            FileUtil.delete((File)this.tempdir, (boolean)true);
        }
        catch (Exception exception) {}
        int slot = 1;
        while ((dest = new File(this.tempdir, String.valueOf(slot))).exists()) {
            ++slot;
        }
        ZipUtil.unzip((File)this.location, (File)dest);
        HashMap<String, String> entries = new HashMap<String, String>();
        if (this.isNameModifiable()) {
            entries.put(MF_EXTENSION_NAME, this.getName());
        }
        if (this.isSpecificationVersionModifiable() && this.specVersion != null) {
            entries.put(MF_SPECIFICATION_VERSION, this.getSpecificationVersion().toString());
        }
        if (this.isImplementationVersionModifiable() && this.implVersion != null) {
            entries.put(MF_IMPLEMENTATION_VERSION, this.getImplementationVersion().toString());
        }
        if (!entries.isEmpty()) {
            File manifestFile = ManifestUtil.findManifestFile((File)dest);
            ManifestUtil.setManifestEntries((File)manifestFile, entries);
        }
        DataOutputStream out = new DataOutputStream(new FileOutputStream(stamp));
        try {
            out.writeInt(slot);
            out.writeLong(this.location.lastModified());
            out.flush();
        }
        catch (Throwable throwable) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            out.close();
        }
        catch (IOException iOException) {}
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        HashSet<Listener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        HashSet<Listener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        ArrayList<Listener> copy;
        HashSet<Listener> hashSet = this.listeners;
        synchronized (hashSet) {
            copy = new ArrayList<Listener>(this.listeners);
        }
        for (Listener listener : copy) {
            listener.libraryArchiveChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForChanges() {
        boolean notify = false;
        LibraryModule libraryModule = this;
        synchronized (libraryModule) {
            long actualLastModified = this.location.lastModified();
            if (actualLastModified != this.lastModified) {
                this.lastModified = actualLastModified;
                notify = true;
            }
        }
        if (notify) {
            this.notifyListeners();
        }
    }

    public void write(Writer w) throws IOException {
        w.write("  <library-module>");
        w.write(NL);
        w.write("    <location>");
        w.write(this.location.getPath());
        w.write("</location>");
        w.write(NL);
        if (this.isNameModifiable()) {
            w.write("    <name>");
            w.write(this.name);
            w.write("</name>");
            w.write(NL);
        }
        if (this.isSpecificationVersionModifiable() && this.specVersion != null) {
            w.write("    <specification-version>");
            w.write(this.specVersion.toString());
            w.write("</specification-version>");
            w.write(NL);
        }
        if (this.isImplementationVersionModifiable() && this.implVersion != null) {
            w.write("    <implementation-version>");
            w.write(this.implVersion.toString());
            w.write("</implementation-version>");
            w.write(NL);
        }
        for (Map.Entry<String, File> entry : this.sourceLocationsOverrides.entrySet()) {
            w.write("    <source-location library=\"");
            w.write(entry.getKey());
            w.write("\">");
            w.write(entry.getValue().getAbsolutePath());
            w.write("</source-location>");
            w.write(NL);
        }
        for (Map.Entry<String, Serializable> entry : this.javadocLocationsOverrides.entrySet()) {
            w.write("    <javadoc-location library=\"");
            w.write(entry.getKey());
            w.write("\">");
            w.write(((URL)entry.getValue()).toExternalForm());
            w.write("</javadoc-location>");
            w.write(NL);
        }
        w.write("    <temp-dir>");
        w.write(this.tempdir.getAbsolutePath());
        w.write("</temp-dir>");
        w.write(NL);
        w.write("  </library-module>");
        w.write(NL);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name);
        buf.append(",spec-version:");
        if (this.specVersion != null) {
            buf.append(this.specVersion.toString());
        }
        buf.append(",impl-version:");
        if (this.implVersion != null) {
            buf.append(this.implVersion.toString());
        }
        buf.append(",location:");
        buf.append(this.location.getAbsolutePath());
        return buf.toString();
    }

    private static Map<String, String> readPropertiesFile(ZipFile zip, String path) throws IOException {
        HashMap<String, String> res = new HashMap<String, String>();
        ZipEntry zipentry = ZipUtil.getZipEntry((ZipFile)zip, (String)path);
        if (zipentry != null) {
            Properties props = new Properties();
            InputStream in = zip.getInputStream(zipentry);
            try {
                props.load(in);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                res.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return res;
    }

    private static <T> Map<String, T> cloneOrCreate(Map<String, T> map) {
        if (map == null) {
            return new HashMap();
        }
        return new HashMap<String, T>(map);
    }

    private static File toFile(File base, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(base, path);
    }

    public static LibraryModuleRef getLibVersion(File jarFile) throws ZipException, IOException {
        String extensionName = null;
        String specVersion = null;
        String implVersion = null;
        if (jarFile != null && jarFile.exists()) {
            ZipFile zf = new ZipFile(jarFile);
            try {
                Map manifest = ManifestUtil.readManifest((ZipFile)zf);
                extensionName = (String)manifest.get(MF_EXTENSION_NAME);
                specVersion = (String)manifest.get(MF_SPECIFICATION_VERSION);
                implVersion = (String)manifest.get(MF_IMPLEMENTATION_VERSION);
            }
            catch (Throwable throwable) {
                try {
                    zf.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                zf.close();
            }
            catch (Exception exception) {}
        }
        return new LibraryModuleRef(extensionName == null ? "" : extensionName, new Version(specVersion == null ? "" : specVersion), new Version(implVersion == null ? "" : implVersion), true);
    }

    public void setTargets(Set<String> targetList) {
        this.targetList = targetList;
    }

    public Set<String> getTargets() {
        return this.targetList;
    }

    public static class Listener {
        public void libraryArchiveChanged() {
        }
    }

    public static enum Type {
        EAR("ear"),
        WAR("war"),
        EJB("ejb"),
        JAR("jar");

        private final String str;

        private Type(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

