/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.internal.validation;

import java.io.File;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectValidator;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

public final class WlsRuntimeValidator
implements IFacetedProjectValidator {
    private static final String INVALID_RUNTIME_LOCATION_MARKER = "oracle.eclipse.tools.weblogic.invalidRuntimeLocation";
    private static final String ATTR_RUNTIME = "runtime";

    public void validate(IFacetedProject fproj) throws CoreException {
        for (IRuntime runtime : fproj.getTargetedRuntimes()) {
            IRuntimeComponent rc = WlsRuntimeUtil.getWlsRuntimeComponent(runtime);
            if (rc == null) continue;
            rc.getRuntimeComponentVersion();
            File wlhome = WlsRuntimeUtil.getWlsRuntimePath(rc);
            if (wlhome.getPath().length() == 0 || WlsRuntimeUtil.isValidWebLogicHome(wlhome)) continue;
            String msg = NLS.bind((String)Resources.invalidRuntimeLocation, (Object)runtime.getName());
            IMarker marker = fproj.createErrorMarker(INVALID_RUNTIME_LOCATION_MARKER, msg);
            marker.setAttribute(ATTR_RUNTIME, (Object)runtime.getName());
        }
    }

    private static final class Resources
    extends NLS {
        public static String invalidRuntimeLocation;

        static {
            Resources.initializeMessages((String)WlsRuntimeValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

