/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import oracle.eclipse.tools.common.wtp.core.ServerUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeComponentType;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.model.RuntimeLocatorDelegate;

public final class WlsRuntimeLocatorDelegate
extends RuntimeLocatorDelegate {
    public void searchForRuntimes(IPath path, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        File f = path.toFile();
        if (!f.isDirectory()) {
            return;
        }
        this.searchForRuntimes(f, listener, new ArrayList<String>(), monitor);
    }

    private void searchForRuntimes(File path, RuntimeLocatorDelegate.IRuntimeSearchListener listener, Collection<String> namesOfDetectedRuntimes, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        IRuntimeComponentVersion rcv = WlsRuntimeComponentType.detectVersion(path);
        if (rcv != null) {
            IRuntimeType rtype = WlsRuntimeComponentType.convert(rcv);
            String rname = ServerUtil.createDefaultRuntimeName((IRuntimeType)rtype, namesOfDetectedRuntimes);
            try {
                IRuntimeWorkingCopy rwc = (IRuntimeWorkingCopy)WlsRuntimeUtil.createWlsRuntime(path, rname, false);
                namesOfDetectedRuntimes.add(rname);
                listener.runtimeFound(rwc);
            }
            catch (CoreException e) {
                WlsCorePlugin.logException((Exception)((Object)e));
                return;
            }
        } else {
            File[] fileArray = path.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory() && !child.isHidden() && !monitor.isCanceled()) {
                    this.searchForRuntimes(child, listener, namesOfDetectedRuntimes, monitor);
                }
                ++n2;
            }
        }
    }
}

