/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.internal;

import java.io.File;
import java.util.Collection;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeSpy;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.j2eelib.IAutoRegistrationFilter;
import oracle.eclipse.tools.weblogic.j2eelib.IFilter;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.j2eelib.internal.AutoRegistrationFiltersExtPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class WlsRuntimeLifecycleListener
implements WlsRuntimeSpy.IListener {
    @Override
    public void handleEvent(final org.eclipse.wst.server.core.IRuntime runtime, WlsRuntimeSpy.EventType type) {
        IPath location = runtime.getLocation();
        if (location == null) {
            return;
        }
        if (type == WlsRuntimeSpy.EventType.REMOVED) {
            return;
        }
        File wlhome = location.toFile();
        File deployableLibrariesLocation = new File(wlhome, "common/deployable-libraries");
        IRuntime r = RuntimeBridgeUtil.bridge((org.eclipse.wst.server.core.IRuntime)runtime);
        final Collection<IAutoRegistrationFilter> filters = AutoRegistrationFiltersExtPoint.getFilters(r);
        IFilter filter = new IFilter(){

            @Override
            public boolean check(LibraryModule lib) {
                for (IAutoRegistrationFilter f : filters) {
                    try {
                        if (f.check(runtime, lib)) continue;
                        return false;
                    }
                    catch (Exception ex) {
                        WlsCorePlugin.logException(ex);
                    }
                }
                return true;
            }
        };
        if (type == WlsRuntimeSpy.EventType.REFRESH) {
            LibraryModulesSvc.refreshLibraryModules(deployableLibrariesLocation, filter);
            return;
        }
        LibraryModulesSvc.registerLibraryModules(deployableLibrariesLocation, filter);
    }
}

