/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeClassLoader;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.server.core.IRuntime;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

final class WlsRuntimeClassLoaderBuilder {
    private static final String INCLUDE_SUB_DIRS_SUFFIX = "/*";
    private static final String USE_PARENT_DIR_PREFIX = "../";
    private static final String PATH_SEP = "/";
    private static final String LOC_PROPERTY = "location";
    private String _id;
    private String _parentId;
    private IRuntimeComponentVersion _componentVersion;
    private final Map<String, SoftReference<WlsRuntimeClassLoader>> _cache = new HashMap<String, SoftReference<WlsRuntimeClassLoader>>();
    private Map<String, Set> _entriesByContributor = new TreeMap<String, Set>();

    WlsRuntimeClassLoaderBuilder(String contributor) {
        this._id = contributor;
    }

    private Set getContributorEntries(String contributor) {
        LinkedHashSet entries = this._entriesByContributor.get(contributor);
        if (entries == null) {
            entries = new LinkedHashSet();
            this._entriesByContributor.put(contributor, entries);
        }
        return entries;
    }

    synchronized void addPathEntry(String contributor, String path) {
        assert (path != null);
        assert (path.length() > 0) : "ClassLoader paths must have a path defined";
        assert (!path.startsWith(PATH_SEP)) : "ClassLoader paths must not start with '/'";
        this.getContributorEntries(contributor).add(path);
    }

    synchronized void addBundleEntry(String contributor, String bundleId, String path) {
        assert (bundleId != null);
        assert (path != null);
        assert (path.length() > 0) : "ClassLoader paths must have a path defined";
        assert (!path.startsWith(PATH_SEP)) : "ClassLoader paths must not start with '/'";
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            LoggingService.logDebug((Plugin)WlsCorePlugin.getInstance(), (String)("Unable to find bundle: " + bundleId));
            return;
        }
        URL url = bundle.getEntry(path);
        try {
            url = FileLocator.toFileURL((URL)url);
            if (url != null) {
                this.getContributorEntries(contributor).add(url);
            }
        }
        catch (IOException ioe) {
            LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (Throwable)ioe);
        }
    }

    synchronized WlsRuntimeClassLoader getClassLoader(IRuntimeComponent component) {
        assert (this._componentVersion == component.getRuntimeComponentVersion()) : "attempting to get a ClassLoader for " + component + " from incorrect builder";
        String location = component.getProperty(LOC_PROPERTY);
        assert (location != null);
        StringBuilder key = new StringBuilder(location);
        URL patchJarURL = this.getPatchURL(component);
        key.append(String.valueOf(patchJarURL));
        WlsRuntimeClassLoader cl = null;
        SoftReference<WlsRuntimeClassLoader> ref = this._cache.get(key.toString());
        if (ref != null) {
            cl = ref.get();
        }
        if (cl == null) {
            File toolsJARLocation;
            List<URL> urls = this.getURLs(location);
            if (patchJarURL != null) {
                urls.add(0, patchJarURL);
            }
            if ((toolsJARLocation = WlsRuntimeUtil.getToolsJAR(component)) != null) {
                urls.add(this.fileToURL(toolsJARLocation));
            } else {
                LoggingService.logError((String)"oracle.eclipse.tools.weblogic", (String)"Unable to find tools.jar within Java VM associated with target WebLogic runtime; features dependent on tools.jar may not function");
            }
            cl = new WlsRuntimeClassLoader(urls.toArray(new URL[urls.size()]), this.getParentBundleClassLoader(), component);
            this._cache.put(key.toString(), new SoftReference<WlsRuntimeClassLoader>(cl));
        }
        assert (cl != null);
        return cl;
    }

    void setParentBundleId(String parentBuilderId) {
        this._parentId = parentBuilderId;
    }

    void setRuntimeComponent(IRuntimeComponentVersion version) {
        this._componentVersion = version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WlsRuntimeClassLoaderBuilder: ");
        sb.append(this._id);
        for (String contributor : this._entriesByContributor.keySet()) {
            sb.append("\n\tCONTRIBUTOR: ").append(contributor);
            Set entries = this._entriesByContributor.get(contributor);
            for (Object entry : entries) {
                sb.append("\n\t\tENTRY: ").append(entry);
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    private URL fileToURL(File file) {
        if (!file.exists()) {
            LoggingService.logError((String)"oracle.eclipse.tools.weblogic", (String)("attempting to load non-existent file: " + file));
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException murle) {
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)murle);
            return null;
        }
    }

    private URL getPatchURL(IRuntimeComponent component) {
        IRuntime r = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)component.getRuntime());
        if (r != null) {
            IPath path;
            IWeblogicServerRuntime wsr = (IWeblogicServerRuntime)r.getAdapter(IWeblogicServerRuntime.class);
            IPath iPath = path = wsr != null ? wsr.getPatchProfileJarPath() : null;
            if (path == null) {
                return null;
            }
            try {
                return path.toFile().toURI().toURL();
            }
            catch (MalformedURLException murle) {
                LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (Throwable)murle, (String)"Unable to determine patch profile");
            }
        }
        return null;
    }

    private List<URL> getURLs(String wlLocation) {
        if (!wlLocation.endsWith(PATH_SEP)) {
            wlLocation = String.valueOf(wlLocation) + PATH_SEP;
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String contributor : this._entriesByContributor.keySet()) {
            Set entries = this._entriesByContributor.get(contributor);
            for (Object entry : entries) {
                URL url;
                File f;
                if (entry instanceof URL) {
                    urls.add((URL)entry);
                    continue;
                }
                if (!(entry instanceof String)) continue;
                String path = (String)entry;
                String parent = wlLocation;
                if (path.startsWith(USE_PARENT_DIR_PREFIX)) {
                    path = path.substring(USE_PARENT_DIR_PREFIX.length());
                    parent = new File(wlLocation).getParent();
                }
                boolean includeSubDirs = false;
                if (path.endsWith(INCLUDE_SUB_DIRS_SUFFIX)) {
                    path = path.substring(0, path.length() - INCLUDE_SUB_DIRS_SUFFIX.length());
                    includeSubDirs = true;
                }
                if ((f = new File(parent, path)).isDirectory() && includeSubDirs) {
                    f.listFiles(new Filter(urls));
                    continue;
                }
                if (!f.exists() || (url = this.fileToURL(f)) == null) continue;
                urls.add(url);
            }
        }
        return urls;
    }

    private ClassLoader getParentBundleClassLoader() {
        Bundle bundle = Platform.getBundle((String)this._parentId);
        if (bundle != null) {
            assert (bundle.getState() == 32) : "bundle " + this._parentId + " is not active";
            return ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
        }
        return null;
    }

    synchronized void resetLocation(IPath location, IPath patchJarPath) {
        assert (location != null);
        StringBuilder sb = new StringBuilder().append(location.toPortableString());
        URL patchURL = null;
        if (patchJarPath != null) {
            try {
                patchURL = patchJarPath.toFile().toURI().toURL();
            }
            catch (MalformedURLException murle) {
                LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (Throwable)murle, (String)"Unable to parse patch Jar path");
            }
        }
        sb.append(patchURL);
        this._cache.remove(sb.toString());
    }

    private final class Filter
    implements FileFilter {
        private final List<URL> _urls;

        public Filter(List<URL> urls) {
            this._urls = urls;
        }

        @Override
        public boolean accept(File file) {
            URL url;
            String name;
            if (file.isDirectory()) {
                file.listFiles(this);
            } else if (file.exists() && ((name = file.getName().toLowerCase()).endsWith(".jar") || name.endsWith(".zip")) && (url = WlsRuntimeClassLoaderBuilder.this.fileToURL(file)) != null) {
                this._urls.add(url);
            }
            return false;
        }
    }
}

