/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.internal;

import java.util.Set;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.WlsRuntimeClassLoader;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public final class WlsClassloaderProjectAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        assert (adapterType != null);
        assert (ClassLoader.class.isAssignableFrom(adapterType));
        IFacetedProject fproj = null;
        if (adaptableObject instanceof IProject) {
            fproj = this.getFacetedProject((IProject)adaptableObject);
        } else if (adaptableObject instanceof IFacetedProject) {
            fproj = (IFacetedProject)adaptableObject;
        } else if (adaptableObject instanceof IJavaProject) {
            fproj = this.getFacetedProject(((IJavaProject)adaptableObject).getProject());
        } else if (adaptableObject instanceof ICompilationUnit) {
            IJavaProject jproj = ((ICompilationUnit)adaptableObject).getJavaProject();
            fproj = this.getFacetedProject(jproj.getProject());
        }
        if (fproj == null) {
            return null;
        }
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = this.getServerRuntime(fproj);
        return runtime != null ? runtime.getAdapter(WlsRuntimeClassLoader.class) : null;
    }

    private IFacetedProject getFacetedProject(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException ce) {
            LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (CoreException)ce);
            return null;
        }
    }

    public Class[] getAdapterList() {
        throw new UnsupportedOperationException("WlsClassloaderProjectAdapterFactory.getAdapterList is unsupported");
    }

    private org.eclipse.wst.common.project.facet.core.runtime.IRuntime getServerRuntime(IFacetedProject fproj) {
        try {
            Set runtimes = fproj.getTargetedRuntimes();
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime localTargetRuntime = null;
            Enum localTargetVer = null;
            for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime rt : runtimes) {
                IWeblogicServerRuntime wsr;
                IRuntime wstRuntime = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)rt);
                if (wstRuntime == null || (wsr = (IWeblogicServerRuntime)wstRuntime.getAdapter(IWeblogicServerRuntime.class)) == null) continue;
                WebLogicServerVersion tempVer = WebLogicServerVersion.convert(wstRuntime.getRuntimeType().getVersion());
                if (localTargetVer != null && localTargetVer.compareTo(tempVer) <= 0) continue;
                localTargetRuntime = rt;
                localTargetVer = tempVer;
            }
            return localTargetRuntime;
        }
        catch (Exception exception) {
            LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (Throwable)exception, (String)("unable to determine runtime from project " + fproj));
            return null;
        }
    }
}

