/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.RuntimeComponentProvider;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.server.core.internal.RuntimeComponentProviderDelegate;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.server.core.IRuntime;

public final class RuntimeComponentProvidersExtensionPoint {
    public static final String EXTENSION_POINT_ID = "runtimeComponentProviders";
    private static final String EL_RUNTIME_COMPONENT_PROVIDER = "runtime-component-provider";
    private static final String ATTR_CLASS = "class";
    private static List<RuntimeComponentProvider> providers = null;

    public static synchronized List<RuntimeComponentProvider> getProviders() {
        if (providers == null) {
            ArrayList<RuntimeComponentProvider> list = new ArrayList<RuntimeComponentProvider>();
            for (ProviderDef pdef : RuntimeComponentProvidersExtensionPoint.readExtensions()) {
                RuntimeComponentProvider provider = (RuntimeComponentProvider)PluginUtil.instantiate((String)pdef.pluginId, (String)pdef.className, RuntimeComponentProvider.class);
                if (provider == null) continue;
                list.add(provider);
            }
            providers = Collections.unmodifiableList(list);
        }
        return providers;
    }

    private static List<ProviderDef> readExtensions() {
        ArrayList<ProviderDef> providers = new ArrayList<ProviderDef>();
        for (IConfigurationElement element : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"oracle.eclipse.tools.weblogic", (String)EXTENSION_POINT_ID))) {
            String pluginId = element.getContributor().getName();
            if (!element.getName().equals(EL_RUNTIME_COMPONENT_PROVIDER)) continue;
            try {
                String className = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_CLASS);
                providers.add(new ProviderDef(pluginId, className));
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
        return providers;
    }

    public static final class Funnel
    extends RuntimeComponentProviderDelegate {
        public List<IRuntimeComponent> getRuntimeComponents(IRuntime runtime) {
            WebLogicServerInstall install = WebLogicServerInstall.getWebLogicServerInstall(runtime);
            ArrayList<IRuntimeComponent> components = new ArrayList<IRuntimeComponent>();
            for (RuntimeComponentProvider provider : RuntimeComponentProvidersExtensionPoint.getProviders()) {
                try {
                    List<IRuntimeComponent> res = provider.getRuntimeComponents(install);
                    if (res == null) continue;
                    components.addAll(res);
                }
                catch (Exception e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)e);
                }
            }
            return components;
        }
    }

    private static final class ProviderDef {
        public final String pluginId;
        public final String className;

        public ProviderDef(String pluginId, String className) {
            this.pluginId = pluginId;
            this.className = className;
        }
    }
}

