/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.weblogic.IDomainLocator;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class KnownDomainsLocator
implements IDomainLocator {
    private static final String SAMPLE_DOMAINS_DIR = "samples/domains";
    private static final String USER_DOMAINS_DIR = "../user_projects/domains";

    @Override
    public List<File> locateDomains(IRuntime wlsRuntime, IProgressMonitor monitor) {
        ArrayList<File> domains = new ArrayList<File>();
        File wlhome = WlsRuntimeUtil.getWlsRuntimePath(wlsRuntime);
        if (wlhome != null) {
            this.addDomainsFromDir(domains, new File(wlhome, SAMPLE_DOMAINS_DIR));
            this.addDomainsFromDir(domains, new File(wlhome, USER_DOMAINS_DIR));
        }
        return domains;
    }

    private void addDomainsFromDir(List<File> domains, File dir) {
        if (dir.exists() && dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    domains.add(f);
                }
                ++n2;
            }
        }
    }
}

