/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.internal;

import java.io.File;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class DefaultDescriptorGenerator {
    private static final String WEB_DESCRIPTOR_PATH = "WEB-INF/web.xml";

    public static boolean hasDescriptor(IProject project, File outputDir) throws CoreException {
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        if (fproj.hasProjectFacet(WebFacetUtils.WEB_FACET)) {
            return new File(outputDir, WEB_DESCRIPTOR_PATH).exists();
        }
        throw new UnsupportedOperationException();
    }

    public static File createDefaultDescriptor(IProject project, File outputDir) throws CoreException {
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        if (fproj.hasProjectFacet(WebFacetUtils.WEB_FACET)) {
            return DefaultDescriptorGenerator.createDefaultDescriptorForWebModule(fproj, outputDir);
        }
        throw new UnsupportedOperationException();
    }

    public static File createDefaultDescriptorForWebModule(IFacetedProject fproj, File outputDir) throws CoreException {
        if (!fproj.getInstalledVersion(WebFacetUtils.WEB_FACET).getVersionString().equals("2.5")) {
            throw new UnsupportedOperationException();
        }
        String contents = Resources.bind((String)Resources.defaultWeb25Descriptor, (Object)fproj.getProject().getName());
        if (!outputDir.isDirectory()) {
            return null;
        }
        File f = new File(outputDir, WEB_DESCRIPTOR_PATH);
        EclipseFileUtil.writeFile((File)f, (String)contents);
        return f;
    }

    private static final class Resources
    extends NLS {
        public static String defaultWeb25Descriptor;

        static {
            Resources.initializeMessages((String)DefaultDescriptorGenerator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

