/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.facets.internal;

import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.wtp.ValidatorUtil;
import oracle.eclipse.tools.weblogic.descriptors.ILibraryRef;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicWebModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.j2eelib.J2EELibraryToolsFramework;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class WlsWebFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)3);
        try {
            IWebLogicWebModuleDescriptor descriptor = WebLogicDescriptorFactory.getWebDescriptor(project);
            descriptor.setServerVersion(fv.getVersionString());
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            String contextRoot = (String)vc.getMetaProperties().get("context-root");
            descriptor.setContextRoot(contextRoot);
            for (ILibraryRef libref : descriptor.getLibraryRefs()) {
                LibraryModulesSvc.addToClasspath(project, LibraryModulesSvc.convert(libref), new String[0]);
            }
            try {
                try {
                    descriptor.resource().save();
                }
                catch (ResourceStoreException e) {
                    throw new CoreException(WlsCorePlugin.createErrorStatus((Exception)((Object)e)));
                }
            }
            finally {
                descriptor.dispose();
            }
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            ValidatorUtil.disableValidation((IProject)project, (String[])new String[]{"org.eclipse.wst.wsdl.validation.wsdl"});
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            J2EELibraryToolsFramework.addValidationBuilder(project.getProject());
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }
}

