/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.facets.internal;

import java.util.Map;
import oracle.eclipse.tools.common.util.wtp.ValidatorUtil;
import oracle.eclipse.tools.weblogic.ejb.EJBCoreUtil;
import oracle.eclipse.tools.weblogic.ejb.EJBProjectMessages;
import oracle.eclipse.tools.weblogic.ejb.EJBProjectProperties;
import oracle.eclipse.tools.weblogic.ejb.builder.EJBGenBuilderEnabler;
import oracle.eclipse.tools.weblogic.j2eelib.J2EELibraryToolsFramework;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.core.util.IFactoryPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class WlsEjbGenFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion facetVersion, Object configObject, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 7);
        }
        try {
            new EJBGenBuilderEnabler().addBuilder(project, null, monitor);
            if (monitor != null) {
                monitor.worked(1);
            }
            IJavaProject jproj = JavaCore.create((IProject)project);
            this.configureJ2EEComponent(project, jproj, facetVersion);
            if (monitor != null) {
                monitor.worked(1);
            }
            this.configureAPT(jproj);
            if (monitor != null) {
                monitor.worked(1);
            }
            this.setCreateTables(project);
            if (monitor != null) {
                monitor.worked(1);
            }
            this.disableEJBValidation(project);
            if (monitor != null) {
                monitor.worked(1);
            }
            J2EELibraryToolsFramework.addValidationBuilder(project.getProject());
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void setCreateTables(IProject project) throws CoreException {
        Map<String, String> props = EJBProjectProperties.readProperties(project);
        props.put("jarSettings.createTables", "CREATE_ONLY");
        EJBProjectProperties.writeProperties(project, props);
    }

    private void disableEJBValidation(IProject project) throws CoreException {
        ValidatorUtil.disableValidation((IProject)project, (String[])new String[]{"org.eclipse.jst.j2ee.internal.ejb.workbench.validation.UIEjbValidator"});
    }

    private void configureJ2EEComponent(IProject project, IJavaProject jproj, IProjectFacetVersion facetVersion) throws CoreException {
        ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)facetVersion);
        ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)facetVersion);
    }

    private void configureAPT(IJavaProject jproj) throws CoreException {
        IFactoryPath ifp = AptConfig.getFactoryPath((IJavaProject)jproj);
        try {
            ifp.enablePlugin("oracle.eclipse.tools.weblogic");
        }
        catch (CoreException coreException) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.weblogic", 0, EJBProjectMessages.missingWeblogicPlugin, null));
        }
        AptConfig.setFactoryPath((IJavaProject)jproj, (IFactoryPath)ifp);
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)true);
    }

    private void switchEjbJarLocation(IProject project, IJavaProject jproj) throws CoreException {
        IVirtualComponent c = ComponentCore.createComponent((IProject)project);
        IVirtualFolder ejbRoot = c.getRootFolder();
        Path ejbJarPath = new Path("META-INF/ejb-jar.xml");
        Path metaInfPath = new Path("META-INF");
        IVirtualFile ejbJar = ejbRoot.getFile((IPath)ejbJarPath);
        IVirtualFolder metaInf = ejbRoot.getFolder((IPath)metaInfPath);
        IPath[] ejbSrcPaths = EJBCoreUtil.getEJBSrcPath(jproj);
        if (ejbSrcPaths.length == 0) {
            return;
        }
        ejbJar.removeLink(ejbSrcPaths[0].append((IPath)ejbJarPath), 0, null);
        metaInf.removeLink(ejbSrcPaths[0].append((IPath)metaInfPath), 0, null);
        IPath outputPath = EJBCoreUtil.getAPTOutputFolder(project).getFullPath().removeFirstSegments(1);
        IPath newLocation = outputPath.append((IPath)ejbJarPath);
        ejbJar.createLink(newLocation, 0, null);
        IPath currentEjbJarPath = ejbSrcPaths[0].append((IPath)ejbJarPath);
        IFile ejbJarFile = project.getFile(currentEjbJarPath);
        if (ejbJarFile.exists()) {
            ejbJarFile.delete(true, null);
        }
    }
}

